/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.datechooser;

import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.datechooser.DateChooser;
import de.jaret.util.ui.datechooser.IDateChooserListener;
import de.jaret.util.ui.datechooser.IFieldIdentifier;
import de.jaret.util.ui.datechooser.TimeChooserPanel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TimeChooser
extends Composite
implements FocusListener,
IDateChooserListener {
    public static final int KEEP_AND_MARK = 0;
    public static final int RESET_TO_LASTVALID = 1;
    public static final Color MARKER_COLOR = Display.getCurrent().getSystemColor(3);
    protected int _invalidInputBehaviour = 0;
    protected boolean _editable = true;
    private boolean _enabled = true;
    private boolean _selectAllOnFocusGained = true;
    private boolean _textfieldMouseWheelEnable = true;
    protected List<IDateChooserListener> _listenerList = new Vector<IDateChooserListener>();
    protected Date _date = new Date();
    protected Text _textField;
    protected Button _dropdownButton;
    protected Shell _dropDownShell;
    protected boolean _dropped = false;
    boolean _goingToDropDown = false;
    protected TimeChooserPanel _chooserPanel;
    protected IFieldIdentifier _fieldIdentifier;
    private Color _textfieldBGColor;
    private boolean _hasFocus = false;
    protected NumberFormat _twoDigitNF;
    protected DateChooser _dateChooser;
    protected boolean _hasValidInput = true;

    public TimeChooser(Composite parent, int style) {
        super(parent, style);
        this.createControls();
        this._twoDigitNF = NumberFormat.getNumberInstance();
        this._twoDigitNF.setMinimumIntegerDigits(2);
        this._twoDigitNF.setMaximumIntegerDigits(2);
        this.updateTextField(this._date);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TimeChooser.this.onDispose();
            }
        });
    }

    private void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this._textField = new Text((Composite)this, 133120);
        GridData gd = new GridData(768);
        this._textField.setLayoutData((Object)gd);
        this._textField.addFocusListener((FocusListener)this);
        this._textfieldBGColor = this._textField.getBackground();
        this._textField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (Character.isDigit(e.character) || e.character < ' ' || e.character == '\u007f' || e.character == ':') {
                    return;
                }
                e.doit = false;
            }
        });
        this._textField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if ((keyEvent.stateMask & 0x40000) != 0 && keyEvent.keyCode == 32) {
                    TimeChooser.this.setDropped(!TimeChooser.this.isDropped());
                    keyEvent.doit = false;
                } else if (keyEvent.keyCode == 13) {
                    TimeChooser.this._textField.traverse(16);
                } else if (keyEvent.keyCode == 0x1000001) {
                    TimeChooser.this.rollField(1);
                    keyEvent.doit = false;
                } else if (keyEvent.keyCode == 0x1000002) {
                    TimeChooser.this.rollField(-1);
                    keyEvent.doit = false;
                } else if (keyEvent.keyCode == 58) {
                    System.out.println("::::");
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        int count = -event.count / 3;
                        if (!TimeChooser.this._textfieldMouseWheelEnable) break;
                        TimeChooser.this.rollField(count);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported event");
                    }
                }
            }
        };
        this.addListener(37, listener);
        this._dropdownButton = new Button((Composite)this, 1028);
        gd = new GridData();
        this._dropdownButton.setLayoutData((Object)gd);
        this._dropdownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TimeChooser.this.setDropped(!TimeChooser.this.isDropped());
            }
        });
    }

    public void onDispose() {
        if (this._dropDownShell != null) {
            this._dropDownShell.dispose();
        }
    }

    private void rollField(int delta) {
        if (this.validateInput()) {
            int caretpos = this._textField.getCaretPosition();
            if (caretpos < 3) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(this._date);
                ((Calendar)cal).roll(11, delta);
                this.setDate(cal.getTime());
            } else {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(this._date);
                ((Calendar)cal).roll(12, delta);
                this.setDate(cal.getTime());
            }
        }
    }

    public boolean isDropped() {
        return this._dropped;
    }

    public void setDropped(boolean dropped) {
        if (dropped != this._dropped) {
            this._dropped = dropped;
            if (this._dropped && this._editable && this._enabled) {
                if (this._dropDownShell == null) {
                    this._dropDownShell = this.createDropDown();
                }
                this._goingToDropDown = true;
                this._chooserPanel.setDate(this.getDate());
                Point size = this._dropdownButton.getSize();
                Point dispLocation = this.toDisplay(this._dropdownButton.getLocation());
                Point dropDownSize = this._dropDownShell.computeSize(-1, -1);
                int dsWidth = dropDownSize.x;
                int dsHeight = dropDownSize.y;
                int locx = dispLocation.x + size.x - dsWidth;
                int locy = dispLocation.y + size.y + 3;
                if (locx < 0) {
                    locx = 0;
                } else if (locx + dsWidth > Display.getCurrent().getBounds().width) {
                    locx = Display.getCurrent().getBounds().width - dsWidth;
                }
                if (locy + dsHeight > Display.getCurrent().getBounds().height) {
                    locy = dispLocation.y - dsHeight - 3;
                }
                this._dropDownShell.setLocation(locx, locy);
                this._dropDownShell.setSize(dsWidth, dsHeight);
                this._dropDownShell.pack();
                this._dropDownShell.layout(true);
                this._dropDownShell.setVisible(true);
                this._dropDownShell.setActive();
                this._chooserPanel.forceFocus();
                this.resetMark();
            } else if (this._dropDownShell != null) {
                this._dropDownShell.setVisible(false);
                this._goingToDropDown = false;
                this._textField.setFocus();
            }
        }
    }

    private Shell createDropDown() {
        Shell dropDown = new Shell(this.getShell(), 2056);
        dropDown.setLayout((Layout)new FillLayout());
        this._chooserPanel = new TimeChooserPanel((Composite)dropDown, 2048);
        this._chooserPanel.setDate(this.getDate());
        this._chooserPanel.addDateChooserListener(this);
        this._chooserPanel.setBackground(this.getBackground());
        this._chooserPanel.addFocusListener(this);
        dropDown.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent event) {
                TimeChooser.this.setDropped(false);
            }
        });
        return dropDown;
    }

    private Date correctDate(Date date) {
        if (this._dateChooser != null && this._dateChooser.getDateInternal() != null) {
            JaretDate d = new JaretDate(this._dateChooser.getDateInternal());
            JaretDate time = new JaretDate(date);
            d.setHours(time.getHours());
            d.setMinutes(time.getMinutes());
            date = d.getDate();
        }
        return date;
    }

    public Date getDate() {
        this._date = this.correctDate(this._date);
        return this._date;
    }

    protected Date getDateInternal() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
        this.updateTextField(this._date);
    }

    protected String formatTime(Date date) {
        JaretDate d = new JaretDate(date);
        return this._twoDigitNF.format(d.getHours()) + ":" + this._twoDigitNF.format(d.getMinutes());
    }

    private void updateTextField(Date date) {
        if (date != null) {
            int caretpos = this._textField.getCaretPosition();
            this._textField.setText(this.formatTime(date));
            this._textField.setSelection(caretpos, caretpos);
        } else {
            this._textField.setText("");
        }
    }

    public void setText(String text) {
        this._textField.setText(text);
    }

    public void selectAll() {
        this._textField.selectAll();
    }

    public void setSelection(int pos) {
        this._textField.setSelection(pos);
    }

    public void clearSelection() {
        this._textField.clearSelection();
    }

    public void cut() {
        this._textField.cut();
    }

    public void copy() {
        this._textField.copy();
    }

    public void paste() {
        this._textField.paste();
    }

    public boolean setFocus() {
        super.setFocus();
        return this._textField.setFocus();
    }

    public boolean forceFocus() {
        return this._textField.forceFocus();
    }

    public Text getTextField() {
        return this._textField;
    }

    public void dateChosen(Date date) {
        this.setDate(this._chooserPanel.getDate());
        this.setDropped(false);
        this.fireDateChosen(this.correctDate(date));
    }

    public void choosingCanceled() {
        this.updateTextField(this._date);
        this.setDropped(false);
        this.fireChoosingCanceled();
    }

    public void dateIntermediateChange(Date date) {
        this.updateTextField(date);
        this.fireIntermediateChange(this.correctDate(date));
    }

    public void inputInvalid() {
    }

    public void focusGained(FocusEvent evt) {
        if (evt.widget.equals(this._textField) && this._selectAllOnFocusGained) {
            this._textField.selectAll();
        }
        if (!this._hasFocus) {
            this._hasFocus = true;
            super.notifyListeners(15, new Event());
        }
    }

    public void focusLost(FocusEvent evt) {
        this.validateInput();
        if (Display.getCurrent().getCursorControl() == this._dropdownButton) {
            this._goingToDropDown = true;
        }
        if (this._hasFocus && !this._goingToDropDown) {
            this._hasFocus = false;
            super.notifyListeners(16, new Event());
        }
    }

    protected Date parseTime(String text, Date date) {
        JaretDate d = new JaretDate(date);
        try {
            String hourString = text.substring(0, 2);
            String minuteString = text.substring(3);
            int h = Integer.parseInt(hourString);
            int m = Integer.parseInt(minuteString);
            d.setHours(h);
            d.setMinutes(m);
        }
        catch (Exception e) {
            return null;
        }
        return d.getDate();
    }

    public boolean validateInput() {
        boolean valid = false;
        String text = this._textField.getText();
        Date date = null;
        date = this.parseTime(text, this._date);
        boolean bl = valid = date != null;
        if (date != null) {
            this.setDate(date);
            this.resetMark();
        } else {
            switch (this._invalidInputBehaviour) {
                case 0: {
                    this.setMark();
                    break;
                }
                case 1: {
                    this.updateTextField(this._date);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid InputBehaviour set");
                }
            }
        }
        if (!valid && this._hasValidInput) {
            this._hasValidInput = valid;
            this.fireInputInvalid();
        }
        this._hasValidInput = valid;
        return valid;
    }

    private void resetMark() {
        this._textField.setBackground(this._textfieldBGColor);
    }

    private void setMark() {
        this._textField.setBackground(MARKER_COLOR);
    }

    public int getInvalidInputBehaviour() {
        return this._invalidInputBehaviour;
    }

    public void setInvalidInputBehaviour(int invalidInputBehaviour) {
        this._invalidInputBehaviour = invalidInputBehaviour;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._textField.setEditable(editable);
        this.setDropped(false);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._enabled = enabled;
        this._textField.setEnabled(enabled);
        this._dropdownButton.setEnabled(enabled);
        this.setDropped(false);
    }

    public TimeChooserPanel getTimeChooserPanel() {
        if (this._dropDownShell == null) {
            this._dropDownShell = this.createDropDown();
        }
        return this._chooserPanel;
    }

    public void addDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList<IDateChooserListener>();
        }
        this._listenerList.add(listener);
    }

    public void remDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            return;
        }
        this._listenerList.remove(listener);
    }

    protected void fireDateChosen(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateChosen(date);
            }
        }
    }

    protected void fireIntermediateChange(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateIntermediateChange(date);
            }
        }
    }

    protected void fireChoosingCanceled() {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.choosingCanceled();
            }
        }
    }

    protected void fireInputInvalid() {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.inputInvalid();
            }
        }
    }

    public boolean isSelectAllOnFocusGained() {
        return this._selectAllOnFocusGained;
    }

    public void setSelectAllOnFocusGained(boolean selectAllOnFocusGained) {
        this._selectAllOnFocusGained = selectAllOnFocusGained;
    }

    public IFieldIdentifier getFieldIdentifier() {
        return this._fieldIdentifier;
    }

    public void setFieldIdentifier(IFieldIdentifier fieldIdentifier) {
        this._fieldIdentifier = fieldIdentifier;
    }

    public boolean isTextfieldMouseWheelEnable() {
        return this._textfieldMouseWheelEnable;
    }

    public void setTextfieldMouseWheelEnable(boolean mouseWheelEnable) {
        this._textfieldMouseWheelEnable = mouseWheelEnable;
    }

    public DateChooser getDateChooser() {
        return this._dateChooser;
    }

    public void setDateChooser(DateChooser dateChooser) {
        this._dateChooser = dateChooser;
    }
}

