/*
 *  File: DateChooserExample.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.examples.datechooser;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.jaret.util.date.JaretDate;
import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import de.jaret.util.date.holidayenumerator.HolidayEnumeratorFactory;
import de.jaret.util.ui.datechooser.DateChooser;
import de.jaret.util.ui.datechooser.DateChooserAdapter;
import de.jaret.util.ui.datechooser.IAdditionalDayInformationProvider;
import de.jaret.util.ui.datechooser.IDateChooserListener;
import de.jaret.util.ui.datechooser.IFieldIdentifier;
import de.jaret.util.ui.datechooser.SimpleFieldIdentifier;
import de.jaret.util.ui.datechooser.TimeChooser;

/**
 * Test program that displays a DateFieldCombo. The Locale used can be changed in the constructor.
 * 
 * @author Peter Kliem
 * @version $Id: DateChooserExample.java 574 2007-10-03 11:59:15Z olk $
 */
public class DateChooserExample {

    Shell _shell;

    DateChooser _dfc;
    TimeChooser _tc;

    Date _date = new Date();

    public DateChooserExample() {
        _shell = new Shell(Display.getCurrent());
        _shell.setSize(600, 200);
        //
        // ***** Change locale for testing here
        //
        Locale locale = Locale.GERMANY;
        String regionId = "NRW";
        // Locale locale = Locale.US; Strign regionId = null;
        // Locale locale = Locale.FRANCE; String regionId = null;

        //
        // ******* Check FieldIdentifier here
        //
        IFieldIdentifier fi = new SimpleFieldIdentifier(".", new int[] {Calendar.DAY_OF_MONTH, Calendar.MONTH,
                Calendar.YEAR});

        createControls(locale, regionId, fi);
        _shell.open();
        Display display;
        display = _shell.getDisplay();

        /*
         * do the event loop until the shell is closed to block the call
         */
        while (_shell != null && !_shell.isDisposed()) {
            try {
                if (!display.readAndDispatch()) {
                    display.sleep();
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
        display.update();
    }

    /**
     * Create the controls that compose the datefieldcombo test.
     * 
     */
    protected void createControls(Locale locale, String regionId, IFieldIdentifier fi) {
        GridLayout gl = new GridLayout(3, false);
        _shell.setLayout(gl);

        _dfc = new DateChooser(_shell, SWT.NULL, locale);
        HolidayEnumerator he = HolidayEnumeratorFactory.getHolidayEnumeratorInstance(locale, regionId);
        _dfc.setHolidayEnumerator(he);
        _dfc.setFieldIdentifier(fi);

        // a fake information provider providing information about tomorrow
        _dfc.setAdditionalDayInformationProvider(new IAdditionalDayInformationProvider() {
            JaretDate tomorrow = new JaretDate().advanceDays(1);
            
            public String getToolTipText(Date date) {
                if (tomorrow.compareDateTo(new JaretDate(date))==0) {
                    return "Information from the additional information provider";
                }
                return null;
            }

            public boolean renderBold(Date date) {
                return tomorrow.compareDateTo(new JaretDate(date))==0;
            }
            
        });
        
        
        // focus listener to control focus behaviour
        _dfc.addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                System.out.println("DateChooser Focus gained");
            }

            public void focusLost(FocusEvent e) {
                System.out.println("DateChooser Focus lost");
            }

        });

        _tc = new TimeChooser(_shell, SWT.NULL);
        // focus listener to control focus behaviour
        _tc.addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                System.out.println("TimeChooser Focus gained");
            }

            public void focusLost(FocusEvent e) {
                System.out.println("TimeChooser Focus lost");
            }

        });

        // wire date and timechooser
        _dfc.setTimeChooser(_tc);
        _tc.setDateChooser(_dfc);
        
        
        // field schowing the resulting date
        final Text resultingDate = new Text(_shell, SWT.NULL);
        resultingDate.setEditable(false);
        resultingDate.setText(_dfc.getDate().toString());

        // choosing a date updates the result field
        _dfc.addDateChooserListener(new DateChooserAdapter() {
            public void dateChosen(Date date) {
                resultingDate.setText(date.toString());
            }
        });
        _tc.addDateChooserListener(new DateChooserAdapter() {
            public void dateChosen(Date date) {
                resultingDate.setText(date.toString());
            }
        });

        // loosing focus triggers update of the result field as well
        FocusListener focusListener = new FocusAdapter() {
            public void focusLost(FocusEvent e) {
                resultingDate.setText(_dfc.getDate().toString());
            }
        };
        _tc.addFocusListener(focusListener);
        _dfc.addFocusListener(focusListener);
        

        Text textField = new Text(_shell, SWT.BORDER);
        textField.setText("... just another control");

        Composite panel = new Composite(_shell, SWT.NULL);
        panel.setLayout(new RowLayout());

        final Button editableCheck = new Button(panel, SWT.CHECK);
        editableCheck.setText("Editable");
        editableCheck.setSelection(true);
        editableCheck.addSelectionListener(new SelectionAdapter() {

            public void widgetSelected(SelectionEvent arg0) {
                _dfc.setEditable(editableCheck.getSelection());
                _tc.setEditable(editableCheck.getSelection());
            }

        });
        /*
         * final Button enableCheck = new Button(panel, SWT.CHECK); enableCheck.setText("Enable");
         * enableCheck.setSelection(true); enableCheck.addSelectionListener(new SelectionListener() {
         * 
         * public void widgetSelected(SelectionEvent arg0) { if (enableCheck.getSelection()) { _dfc.setEnabled(true); }
         * else { _dfc.setEditable(false); } } public void widgetDefaultSelected(SelectionEvent arg0) { }
         * 
         * });
         */
        final Button oneclickCheck = new Button(panel, SWT.CHECK);
        oneclickCheck.setText("oneClick");
        oneclickCheck.addSelectionListener(new SelectionAdapter() {

            public void widgetSelected(SelectionEvent arg0) {
                _dfc.setOneClickSelection(oneclickCheck.getSelection());
            }

        });

    }

    public static void main(String args[]) {
        DateChooserExample dfct = new DateChooserExample();
    }

}
