/*
 *  File: DateChooserPanelExample.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.examples.datechooser;


import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import de.jaret.util.ui.datechooser.DateChooserPanel;

/**
 * Simple test for the DateChooserPanel.
 * 
 * @author Peter Kliem
 * @version $Id: DateChooserPanelExample.java 441 2007-05-20 13:39:14Z olk $
 */
public class DateChooserPanelExample {

    Shell _shell;

    public DateChooserPanelExample() {
        _shell = new Shell(Display.getCurrent());
        _shell.setSize(400, 200);
        createControls();
        _shell.open();
        Display display;
        display = _shell.getDisplay();

        /*
         * do the event loop until the shell is closed to block
         * the call
         */
        while (_shell != null && !_shell.isDisposed()) {
            try {
                if (!display.readAndDispatch())
                    display.sleep();
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
        display.update();
    }



    protected void createControls() {
        _shell.setLayout(new FillLayout());

        DateChooserPanel mll = new DateChooserPanel(_shell, SWT.NULL);
        mll.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
    }


    public static void main(String args[]) {
        DateChooserPanelExample lct = new DateChooserPanelExample();
    }



}
