/*
 *  File: TimeChooserPanelExample.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.examples.datechooser;


import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import de.jaret.util.ui.datechooser.DateChooserPanel;
import de.jaret.util.ui.datechooser.TimeChooserPanel;

/**
 * Simple test for the TimeChooserPanel.
 * 
 * @author Peter Kliem
 * @version $Id: TimeChooserPanelExample.java 497 2007-06-18 22:00:02Z olk $
 */
public class TimeChooserPanelExample {

    Shell _shell;

    public TimeChooserPanelExample() {
        _shell = new Shell(Display.getCurrent());
        _shell.setSize(400, 200);
        createControls();
        _shell.open();
        Display display;
        display = _shell.getDisplay();

        /*
         * do the event loop until the shell is closed to block
         * the call
         */
        while (_shell != null && !_shell.isDisposed()) {
            try {
                if (!display.readAndDispatch())
                    display.sleep();
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
        display.update();
    }



    protected void createControls() {
        _shell.setLayout(new FillLayout());

        TimeChooserPanel mll = new TimeChooserPanel(_shell, SWT.NULL);
        mll.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
    }


    public static void main(String args[]) {
        TimeChooserPanelExample lct = new TimeChooserPanelExample();
    }



}
