/*
 *  File: IViewstateSaver.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.addon;

import org.eclipse.ui.IMemento;

import de.jaret.util.ui.table.JaretTable;

/**
 * Interface describing a service to store the viewstate of a jaret table in an IMemento, thus alowing easy save/restore
 * of changes to the viewstate made by the user.
 * 
 * @author Peter Kliem
 * @version $Id: IViewstateSaver.java 341 2007-04-03 21:04:08Z olk $
 */
public interface IViewstateSaver {
    /**
     * Save the viewstate of a jaret table.
     * 
     * @param jaretTable table to save the viewstate of
     * @param id additional id for structuring (may be <code>null</code> if not needed)
     * @param memento memento to store the viewstate in
     */
    void saveViewstate(JaretTable jaretTable, String id, IMemento memento);

    /**
     * Restore the viewstate of a table.
     * 
     * @param jaretTable table to set the viewstate on
     * @param id additional id (may be <code>null</code>)
     * @param memento memento to read from
     */
    void restoreViewstate(JaretTable jaretTable, String id, IMemento memento);

}
