/*
 *  File: AbstractTableAction.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.addon.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import de.jaret.util.ui.table.JaretTable;

/**
 * Abstract base for table actions that listen to gloabl focus traversals.
 * 
 * @author kliem
 * @version $Id: AbstractTableAction.java 354 2007-04-09 13:53:45Z olk $
 */
public abstract class AbstractTableAction extends Action implements IWorkbenchAction, Listener {
    /** memeber to hold tghat jaret table the action is currently focussed on. */
    protected JaretTable _table;

    /**
     * Construct the action. Hooks as a filter to the currebt display.
     */
    public AbstractTableAction() {
        Display.getCurrent().addFilter(SWT.FocusIn, this);
        Display.getCurrent().addFilter(SWT.FocusOut, this);
    }

    /**
     * Dispose the action. Will unhook the filter from the display.
     */
    public void dispose() {
        Display.getCurrent().removeFilter(SWT.FocusIn, this);
        Display.getCurrent().removeFilter(SWT.FocusOut, this);
    }

    /**
     * Abstract method to be implemented by subclasses. Will be called whenever a jaret table gets the focus.
     * 
     * @param table the concrete table that gained the focus
     */
    public abstract void hook(JaretTable table);

    /**
     * Abstract method to be implemented by subclasses. Will be called whenever a jaret table looses focus.
     * 
     * @param table the concrete table loosing the focus.
     */
    public abstract void unHook(JaretTable table);

    /**
     * {@inheritDoc} Checks for focus.in and focus.out events to hook/unhook the action to a table.
     */
    public void handleEvent(Event event) {
        if (event.type == SWT.FocusIn) {
            if (event.widget instanceof JaretTable) {
                _table = (JaretTable) event.widget;
                hook(_table);
            }
        } else if (event.type == SWT.FocusOut && _table != null) {
            setEnabled(false);
            unHook(_table);
            _table = null;
        }
    }

}
