/*
 *  File: ConfigureColumnsTableAction.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.addon.actions;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.util.action.ConfigureColumnsAction;

/**
 * Action bringing up a dialog for configuring the tabel columns (visibility, order). Fixed columns can not manipulated.
 * 
 * @author kliem
 * @version $Id: ConfigureColumnsTableAction.java 354 2007-04-09 13:53:45Z olk $
 */
public class ConfigureColumnsTableAction extends AbstractTableAction {
    /** public id of the action. */
    public static final String ID = "de.jaret.util.ui.table.addon.actions.ConfigureColumnsTableAction";
    /** action from the base jaret table package to be used as a delegate. */
    private ConfigureColumnsAction _configAction;

    /**
     * Construct the action.
     */
    public ConfigureColumnsTableAction() {
        setId(ID);
        setText("Configure columns");
        setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public void hook(JaretTable table) {
        setEnabled(true);
        _configAction = new ConfigureColumnsAction(table, false);
    }

    /**
     * {@inheritDoc}
     */
    public void unHook(JaretTable table) {
        setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public void run() {
        _configAction.run();
    }

    /**
     * {@inheritDoc}
     */
    public void dispose() {
        super.dispose();
        _configAction = null;
    }
}
