/*
 *  File: FilterTableAction.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.addon.actions;

import de.jaret.util.ui.table.JaretTable;

/**
 * Enable/disable filters of the table.
 * 
 * @author Peter Kliem
 * @version $Id: FilterTableAction.java 354 2007-04-09 13:53:45Z olk $
 */
public class FilterTableAction extends AbstractTableAction {
    /** public id of the action. */
    public static final String ID = "de.jaret.util.ui.table.addon.actions.FilterTableAction";

    /**
     * Construct the action.
     */
    public FilterTableAction() {
        setId(ID);
        setText("Filter");
        setEnabled(false);

    }

    /**
     * {@inheritDoc} Renders as checkbox holding state.
     */
    public int getStyle() {
        return AS_CHECK_BOX;
    }

    /**
     * {@inheritDoc}
     */
    public void hook(JaretTable table) {
        setEnabled(true);
        setChecked(table.getAutoFilterEnable()); // reflect autofilter state
    }

    /**
     * {@inheritDoc}
     */
    public void unHook(JaretTable table) {
        setEnabled(false);
        super.setChecked(false); // when not enabled appear unchecked
    }

    /**
     * {@inheritDoc}
     */
    public void setChecked(boolean checked) {
        super.setChecked(checked);
        _table.setAutoFilterEnable(checked);
    }

    /**
     * {@inheritDoc}
     */
    public void dispose() {
        super.dispose();
    }
}
