/*
 *  File: HideColumnsTableAction.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.addon.actions;

import java.util.List;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IJaretTableCell;
import de.jaret.util.ui.table.model.IJaretTableSelectionModelListener;
import de.jaret.util.ui.table.model.IRow;

/**
 * Action that hides selected columns in a table. The action operates a selection listener on the table it is hooked on.
 * 
 * @author kliem
 * @version $Id: HideColumnsTableAction.java 357 2007-04-09 14:13:00Z olk $
 */
public class HideColumnsTableAction extends AbstractTableAction implements IJaretTableSelectionModelListener {
    /** public id of the action. */
    public static final String ID = "de.jaret.util.ui.table.addon.actions.HideColumnsTableAction";

    /**
     * Construct the action.
     */
    public HideColumnsTableAction() {
        setId(ID);
        setText("Hide selected columns");
        setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public void hook(JaretTable table) {
        table.getSelectionModel().addTableSelectionModelListener(this);
        if (_table.getSelectionModel().getSelection().getSelectedColumns().size() > 0) {
            setEnabled(true);
        }
    }

    /**
     * {@inheritDoc}
     */
    public void unHook(JaretTable table) {
        table.getSelectionModel().removeTableSelectionModelListener(this);
        setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public void run() {
        List<IColumn> cols = _table.getSelectionModel().getSelection().getSelectedColumns();
        for (IColumn column : cols) {
            _table.getTableViewState().setColumnVisible(column, false);
        }
        _table.getSelectionModel().clearSelection();
    }

    /**
     * {@inheritDoc}
     */
    public void dispose() {
        if (_table != null) {
            _table.getSelectionModel().removeTableSelectionModelListener(this);
        }
        super.dispose();
    }

    /**
     * {@inheritDoc}
     */
    public void cellSelectionAdded(IJaretTableCell cell) {
    }

    /**
     * {@inheritDoc}
     */
    public void cellSelectionRemoved(IJaretTableCell cell) {
    }

    /**
     * {@inheritDoc}
     */
    public void columnSelectionAdded(IColumn column) {
        if (_table != null) {
            setEnabled(true);
        }
    }

    /**
     * {@inheritDoc}
     */
    public void columnSelectionRemoved(IColumn column) {
        if (_table != null) {
            if (_table.getSelectionModel().getSelection().getSelectedColumns().size() == 0) {
                setEnabled(false);
            }
        }
    }

    /**
     * {@inheritDoc}
     */
    public void rowSelectionAdded(IRow row) {
    }

    /**
     * {@inheritDoc}
     */
    public void rowSelectionRemoved(IRow row) {
    }

}
