/*
 *  File: OptimzeAllRowHeightsTableAction.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.addon.actions;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.util.action.OptimizeAllRowHeightsAction;

/**
 * Action that causes setting the optimal row height for all rows in a table.
 * 
 * @author kliem
 * @version $Id: OptimizeAllRowHeightsTableAction.java 358 2007-04-09 14:43:45Z olk $
 */
public class OptimizeAllRowHeightsTableAction extends AbstractTableAction {
    /** public id of the action. */
    public static final String ID = "de.jaret.util.ui.table.addon.actions.OptimzeAllRowHeightsTableAction";
    /** delegate action from the base table package. */
    private OptimizeAllRowHeightsAction _optAction;

    /**
     * Construct the action.
     */
    public OptimizeAllRowHeightsTableAction() {
        setId(ID);
        setText("Optimize all row heights");
        setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public void hook(JaretTable table) {
        setEnabled(true);
        _optAction = new OptimizeAllRowHeightsAction(table);
    }

    /**
     * {@inheritDoc}
     */
    public void unHook(JaretTable table) {
        setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public void run() {
        _optAction.run();
    }

    /**
     * {@inheritDoc}
     */
    public void dispose() {
        super.dispose();
        _optAction = null;
    }
}
