/*
 *  File: ShowConfigurationTableaction.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.addon.actions;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;

/**
 * Action that simply prints out the column widths on stdout. This is just a help for optimizing initial setup of a
 * table.
 * 
 * @author kliem
 * @version $Id: ShowConfigurationTableAction.java 360 2007-04-09 14:45:26Z olk $
 */
public class ShowConfigurationTableAction extends AbstractTableAction {
    /** public id of the action. */
    public static final String ID = "de.jaret.util.ui.table.addon.actions.ShowConfigurationTableaction";

    /**
     * Construct the action.
     */
    public ShowConfigurationTableAction() {
        setId(ID);
        setText("Show config");
        setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public void run() {
        for (int i = 0; i < _table.getTableModel().getColumnCount(); i++) {
            IColumn col = _table.getTableModel().getColumn(i);
            boolean visible = _table.getTableViewState().getColumnVisible(col);
            int pos = _table.getTableViewState().getSortedColumns().indexOf(col);
            int width = _table.getTableViewState().getColumnWidth(col);
            System.out.println(i + ": " + col.getId() + " width:" + width + " visible:" + visible + " position:" + pos);
        }
    }

    /**
     * {@inheritDoc}
     */
    public void hook(JaretTable table) {
        setEnabled(true);
    }

    /**
     * {@inheritDoc}
     */
    public void unHook(JaretTable table) {
        setEnabled(false);
    }

}
