/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table;

import de.jaret.util.date.JaretDate;
import de.jaret.util.misc.PropertyObservable;
import de.jaret.util.misc.PropertyObservableBase;
import de.jaret.util.ui.table.editor.BooleanCellEditor;
import de.jaret.util.ui.table.editor.DateCellEditor;
import de.jaret.util.ui.table.editor.DoubleCellEditor;
import de.jaret.util.ui.table.editor.EnumComboEditor;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.editor.IntegerCellEditor;
import de.jaret.util.ui.table.editor.TextCellEditor;
import de.jaret.util.ui.table.filter.DefaultAutoFilter;
import de.jaret.util.ui.table.filter.IAutoFilter;
import de.jaret.util.ui.table.filter.IRowFilter;
import de.jaret.util.ui.table.model.DefaultHierarchicalTableViewState;
import de.jaret.util.ui.table.model.DefaultTableViewState;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IHierarchicalJaretTableModel;
import de.jaret.util.ui.table.model.IHierarchicalTableViewState;
import de.jaret.util.ui.table.model.IJaretTableCell;
import de.jaret.util.ui.table.model.IJaretTableModel;
import de.jaret.util.ui.table.model.IJaretTableModelListener;
import de.jaret.util.ui.table.model.IJaretTableSelection;
import de.jaret.util.ui.table.model.IJaretTableSelectionModel;
import de.jaret.util.ui.table.model.IJaretTableSelectionModelListener;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.IRowSorter;
import de.jaret.util.ui.table.model.ITableFocusListener;
import de.jaret.util.ui.table.model.ITableNode;
import de.jaret.util.ui.table.model.ITableViewState;
import de.jaret.util.ui.table.model.ITableViewStateListener;
import de.jaret.util.ui.table.model.JaretTableCellImpl;
import de.jaret.util.ui.table.model.JaretTableSelectionModelImpl;
import de.jaret.util.ui.table.model.StdHierarchicalTableModel;
import de.jaret.util.ui.table.renderer.BooleanCellRenderer;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.DateCellRenderer;
import de.jaret.util.ui.table.renderer.DefaultTableHeaderRenderer;
import de.jaret.util.ui.table.renderer.DoubleCellRenderer;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import de.jaret.util.ui.table.renderer.IHierarchyRenderer;
import de.jaret.util.ui.table.renderer.ITableHeaderRenderer;
import de.jaret.util.ui.table.renderer.ImageCellRenderer;
import de.jaret.util.ui.table.renderer.TableHierarchyRenderer;
import de.jaret.util.ui.table.renderer.TextCellRenderer;
import de.jaret.util.ui.table.strategies.DefaultCCPStrategy;
import de.jaret.util.ui.table.strategies.DefaultFillDragStrategy;
import de.jaret.util.ui.table.strategies.ICCPStrategy;
import de.jaret.util.ui.table.strategies.IFillDragStrategy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaretTable
extends Canvas
implements ITableViewStateListener,
IJaretTableModelListener,
IJaretTableSelectionModelListener,
PropertyChangeListener,
PropertyObservable {
    private static final boolean DEBUGPAINTTIME = false;
    private static final int SELDELTA = 4;
    private static final int FILLDRAGMARKSIZE = 4;
    private static final int DEFAULTHEADERHEIGHT = 16;
    private static final int DEFAULTMINHEADERHEIGHT = 10;
    private static final int POPUPTRIGGER = 3;
    public static final String PROPERTYNAME_HEADERHEIGHT = "HeaderHeight";
    public static final String PROPERTYNAME_FIRSTROWIDX = "FirstRowIdx";
    public static final String PROPERTYNAME_FIRSTROWPIXELOFFSET = "FirstRowPixelOffset";
    public static final String PROPERTYNAME_ROWSORTER = "RowSorter";
    public static final String PROPERTYNAME_ROWFILTER = "RowFilter";
    public static final String PROPERTYNAME_SORTING = "Sorting";
    public static final String PROPERTYNAME_FILTERING = "Filtering";
    public static final String PROPERTYNAME_AUTOFILTERENABLE = "AutoFilterEnable";
    protected int _firstRowIdx = 0;
    protected int _firstRowPixelOffset = 0;
    protected int _firstColIdx = 0;
    protected int _firstColPixelOffset = 0;
    protected int _fixedColumns = 0;
    protected int _fixedRows = 0;
    protected Map<IColumn, ICellRenderer> _colCellRendererMap = new HashMap<IColumn, ICellRenderer>();
    protected Map<Class<?>, ICellRenderer> _colClassRendererMap = new HashMap();
    protected Map<IColumn, ICellEditor> _colCellEditorMap = new HashMap<IColumn, ICellEditor>();
    protected Map<Class<?>, ICellEditor> _colClassEditorMap = new HashMap();
    protected boolean _supportFillDragging = true;
    protected IFillDragStrategy _fillDragStrategy = new DefaultFillDragStrategy();
    protected ICCPStrategy _ccpStrategy = new DefaultCCPStrategy();
    protected IJaretTableModel _model;
    protected IHierarchicalJaretTableModel _hierarchicalModel;
    protected ITableViewState _tvs = new DefaultTableViewState();
    protected List<IRow> _rows = new ArrayList<IRow>();
    protected IRowFilter _rowFilter;
    protected IRowSorter _rowSorter;
    protected List<IColumn> _cols = new ArrayList<IColumn>();
    protected Rectangle _headerRect;
    protected int _headerHeight = 16;
    protected int _minHeaderHeight = 10;
    protected boolean _drawHeader = true;
    protected Rectangle _tableRect;
    protected ITableHeaderRenderer _headerRenderer = new DefaultTableHeaderRenderer();
    protected Rectangle _fixedColRect;
    protected Rectangle _fixedRowRect;
    protected Rectangle _dragMarkerRect;
    protected Rectangle _autoFilterRect;
    protected boolean _autoFilterEnabled = false;
    protected AutoFilter _autoFilter = new AutoFilter(this);
    protected Map<IColumn, IAutoFilter> _autoFilterMap = new HashMap<IColumn, IAutoFilter>();
    protected Map<Class<?>, Class<? extends IAutoFilter>> _autoFilterClassMap = new HashMap();
    protected Map<IColumn, Class<? extends IAutoFilter>> _autoFilterColumnMap = new HashMap<IColumn, Class<? extends IAutoFilter>>();
    private boolean _headerResizeAllowed = true;
    private boolean _rowResizeAllowed = true;
    private boolean _columnResizeAllowed = true;
    protected boolean _resizeRestriction = false;
    protected boolean _excludeFixedRowsFromSorting = true;
    protected boolean _allowSorting = true;
    protected IRow _focussedRow = null;
    protected IColumn _focussedColumn = null;
    protected List<ITableFocusListener> _tableFocusListeners;
    protected IJaretTableSelectionModel _selectionModel = new JaretTableSelectionModelImpl();
    protected ICellEditor _editor;
    protected Control _editorControl = null;
    protected IRow _editorRow;
    protected Menu _headerContextMenu;
    protected Menu _rowContextMenu;
    protected PropertyChangeSupport _propertyChangeSupport;
    protected List<RowInfo> _rowInfoCache = null;
    protected List<ColInfo> _colInfoCache = new ArrayList<ColInfo>();
    protected RowInfo _heightDraggedRowInfo = null;
    protected ColInfo _widthDraggedColumn = null;
    protected boolean _headerDragged = false;
    protected int _firstCellSelectX = -1;
    protected int _firstCellSelectY = -1;
    protected int _lastCellSelectX = -1;
    protected int _lastCellSelectY = -1;
    protected boolean _isFillDrag = false;
    protected int _firstColSelectIdx = -1;
    protected int _lastColSelectIdx = -1;
    int _lastKeyColSelectIdx = -1;
    int _firstKeyColSelectIdx = -1;
    protected int _firstRowSelectIdx = -1;
    protected int _lastRowSelectIdx = -1;
    int _lastKeyRowSelectIdx = -1;
    int _firstKeyRowSelectIdx = -1;
    protected Point _lastKeySelect = null;
    protected Point _firstKeySelect = null;
    Rectangle _firstFillDragSelect = null;
    private boolean _horizontalFillDrag;
    protected SelectType _lastSelectType = SelectType.NONE;
    protected Collection<IRow> _rowsToOptimize = Collections.synchronizedCollection(new HashSet());
    private int _oldHorizontalScroll = -1;
    private int _oldVerticalScroll = -1;
    private boolean _optimizeScrolling = true;
    private Rectangle _selectedIdxRectangle = null;

    public JaretTable(Composite parent, int style) {
        super(parent, style | 0x100000 | 0x40000 | 0x20000000);
        ScrollBar horizontalBar;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                JaretTable.this.onPaint(event);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent me) {
                JaretTable.this.mouseDouble(me.x, me.y);
            }

            public void mouseDown(MouseEvent me) {
                JaretTable.this.forceFocus();
                JaretTable.this.mousePressed(me.x, me.y, me.button == 3, me.stateMask);
            }

            public void mouseUp(MouseEvent me) {
                JaretTable.this.mouseReleased(me.x, me.y, me.button == 3);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent me) {
                if ((me.stateMask & 0x80000) != 0) {
                    JaretTable.this.mouseDragged(me.x, me.y, me.stateMask);
                } else {
                    JaretTable.this.mouseMoved(me.x, me.y, me.stateMask);
                }
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent arg0) {
            }

            public void mouseExit(MouseEvent arg0) {
                if (Display.getCurrent().getActiveShell() != null) {
                    Display.getCurrent().getActiveShell().setCursor(Display.getCurrent().getSystemCursor(0));
                }
            }

            public void mouseHover(MouseEvent me) {
                JaretTable.this.setToolTipText(JaretTable.this.getToolTipText(me.x, me.y));
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JaretTable.this.onDispose(event);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                JaretTable.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 11: {
                        JaretTable.this.updateScrollBars();
                        break;
                    }
                }
            }
        };
        this.addListener(11, listener);
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JaretTable.this.handleVerticalScroll(event);
                }
            });
        }
        if ((horizontalBar = this.getHorizontalBar()) != null) {
            horizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JaretTable.this.handleHorizontalScroll(event);
                }
            });
        }
        this._tableRect = this.getClientArea();
        this._fixedColRect = this.getClientArea();
        this.registerDefaultRenderers();
        this.registerDefaultEditors();
        this.registerDefaultAutofilters();
        this._tvs.addTableViewStateListener(this);
        this._selectionModel.addTableSelectionModelListener(this);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this._propertyChangeSupport = new PropertyChangeSupport(this);
    }

    private void onDispose(DisposeEvent event) {
        if (this._headerRenderer != null) {
            this._headerRenderer.dispose();
        }
        for (ICellRenderer renderer : this._colCellRendererMap.values()) {
            renderer.dispose();
        }
        for (ICellRenderer renderer : this._colClassRendererMap.values()) {
            renderer.dispose();
        }
        for (ICellEditor editor : this._colCellEditorMap.values()) {
            editor.dispose();
        }
        for (ICellEditor editor : this._colClassEditorMap.values()) {
            editor.dispose();
        }
        for (IAutoFilter autoFilter : this._autoFilterMap.values()) {
            autoFilter.dispose();
        }
        if (this._rowSorter != null) {
            this._rowSorter.removePropertyChangeListener(this);
        }
        if (this._rowFilter != null) {
            this._rowFilter.removePropertyChangeListener(this);
        }
        if (this._ccpStrategy != null) {
            this._ccpStrategy.dispose();
        }
    }

    private void registerDefaultRenderers() {
        CellRendererBase cellRenderer = new TextCellRenderer();
        this.registerCellRenderer(Void.TYPE, (ICellRenderer)cellRenderer);
        this.registerCellRenderer(String.class, (ICellRenderer)cellRenderer);
        this.registerCellRenderer(Image.class, (ICellRenderer)new ImageCellRenderer());
        cellRenderer = new BooleanCellRenderer();
        this.registerCellRenderer(Boolean.class, (ICellRenderer)cellRenderer);
        this.registerCellRenderer(Boolean.TYPE, (ICellRenderer)cellRenderer);
        cellRenderer = new DateCellRenderer();
        this.registerCellRenderer(Date.class, (ICellRenderer)cellRenderer);
        this.registerCellRenderer(JaretDate.class, (ICellRenderer)cellRenderer);
        cellRenderer = new DoubleCellRenderer();
        this.registerCellRenderer(Double.class, (ICellRenderer)cellRenderer);
        this.registerCellRenderer(Double.TYPE, (ICellRenderer)cellRenderer);
    }

    private void registerDefaultEditors() {
        this.registerCellEditor(String.class, (ICellEditor)new TextCellEditor(true));
        this.registerCellEditor(Boolean.class, (ICellEditor)new BooleanCellEditor(true));
        this.registerCellEditor(Date.class, (ICellEditor)new DateCellEditor());
        this.registerCellEditor(JaretDate.class, (ICellEditor)new DateCellEditor());
        this.registerCellEditor(Enum.class, (ICellEditor)new EnumComboEditor());
        this.registerCellEditor(Integer.class, (ICellEditor)new IntegerCellEditor());
        this.registerCellEditor(Integer.TYPE, (ICellEditor)new IntegerCellEditor());
        this.registerCellEditor(Double.class, (ICellEditor)new DoubleCellEditor());
        this.registerCellEditor(Double.TYPE, (ICellEditor)new DoubleCellEditor());
    }

    private void registerDefaultAutofilters() {
        this.registerAutoFilterForClass(String.class, DefaultAutoFilter.class);
    }

    public void registerCellRenderer(Class<?> clazz, ICellRenderer cellRenderer) {
        this._colClassRendererMap.put(clazz, cellRenderer);
    }

    public void registerCellRenderer(IColumn column, ICellRenderer cellRenderer) {
        this._colCellRendererMap.put(column, cellRenderer);
    }

    protected ICellRenderer getCellRenderer(IRow row, IColumn column) {
        ICellRenderer renderer = null;
        renderer = this._colCellRendererMap.get(column);
        if (renderer == null) {
            Object value = column.getValue(row);
            if (value != null) {
                renderer = this.getCellRendererFromMap(value.getClass());
            }
            if (renderer == null) {
                renderer = this._colClassRendererMap.get(Void.TYPE);
            }
        }
        return renderer;
    }

    public void registerCellEditor(Class<?> clazz, ICellEditor cellEditor) {
        this._colClassEditorMap.put(clazz, cellEditor);
    }

    public void registerCellEditor(IColumn column, ICellEditor cellEditor) {
        this._colCellEditorMap.put(column, cellEditor);
    }

    private ICellEditor getCellEditor(IRow row, IColumn column) {
        ICellEditor editor = null;
        editor = this._colCellEditorMap.get(column);
        if (editor == null) {
            Object value = column.getValue(row);
            if (value != null) {
                editor = this.getCellEditorFromMap(value.getClass());
            } else if (column.getContentClass(row) != null) {
                editor = this.getCellEditorFromMap(column.getContentClass(row));
            } else if (column.getContentClass() != null) {
                editor = this.getCellEditorFromMap(column.getContentClass());
            }
        }
        return editor;
    }

    private ICellEditor getCellEditorFromMap(Class<?> clazz) {
        Class<?>[] interfaces;
        ICellEditor result = null;
        result = this._colClassEditorMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._colClassEditorMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<?> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._colClassEditorMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._colClassEditorMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    private ICellRenderer getCellRendererFromMap(Class<?> clazz) {
        Class<?>[] interfaces;
        ICellRenderer result = null;
        result = this._colClassRendererMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._colClassRendererMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<?> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._colClassRendererMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._colClassRendererMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public void registerAutoFilterForClass(Class<?> clazz, Class<? extends IAutoFilter> autoFilterClass) {
        this._autoFilterClassMap.put(clazz, autoFilterClass);
    }

    public void registerAutoFilterForColumn(IColumn column, Class<? extends IAutoFilter> autoFilterClass) {
        this._autoFilterColumnMap.put(column, autoFilterClass);
    }

    protected Class<? extends IAutoFilter> getAutoFilterClass(IColumn column) {
        Class<? extends IAutoFilter> result = this._autoFilterColumnMap.get(column);
        if (result != null) {
            return result;
        }
        Class<?> contentClass = column.getContentClass();
        if (contentClass != null) {
            result = this.getAutoFilterClassForClass(contentClass);
        }
        if (result == null) {
            result = this._autoFilterClassMap.get(String.class);
        }
        return result;
    }

    private Class<? extends IAutoFilter> getAutoFilterClassForClass(Class<?> clazz) {
        Class<?>[] interfaces;
        Class<? extends IAutoFilter> result = null;
        result = this._autoFilterClassMap.get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            result = this._autoFilterClassMap.get(c);
            if (result == null) continue;
            return result;
        }
        for (Class<?> sc = clazz.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            Class<?>[] scinterfaces;
            result = this._autoFilterClassMap.get(sc);
            if (result != null) {
                return result;
            }
            for (Class<?> c : scinterfaces = sc.getInterfaces()) {
                result = this._autoFilterClassMap.get(c);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    private void mouseDouble(int x, int y) {
        if (this._tableRect.contains(x, y) || this._fixedColumns > 0 && this._fixedColRect.contains(x, y) || this._fixedRows > 0 && this._fixedRowRect.contains(x, y)) {
            this.setFocus(x, y);
            this.startEditing(this.rowForY(y), this.colForX(x), '\u0000');
        }
    }

    private void mousePressed(int x, int y, boolean popuptrigger, int stateMask) {
        if (this._dragMarkerRect != null && this._dragMarkerRect.contains(x, y)) {
            this._isFillDrag = true;
            this._firstFillDragSelect = this._selectedIdxRectangle;
            return;
        }
        IRow row = this.rowByBottomBorder(y);
        if (row != null && this._rowResizeAllowed && (this._tvs.getRowHeigthMode(row) == ITableViewState.RowHeightMode.VARIABLE || this._tvs.getRowHeigthMode(row) == ITableViewState.RowHeightMode.OPTANDVAR) && (!this._resizeRestriction || Math.abs(x - this._tableRect.x) <= 4 || this._fixedColRect != null && this._fixedColRect.contains(x, y))) {
            this._heightDraggedRowInfo = this.getRowInfo(row);
            return;
        }
        IColumn col = this.colByRightBorder(x);
        if (col != null && this._columnResizeAllowed && this._tvs.columnResizingAllowed(col) && (!this._resizeRestriction || this._headerRect == null || this._headerRect.contains(x, y))) {
            this._widthDraggedColumn = this.getColInfo(col);
            return;
        }
        if (this._headerResizeAllowed && Math.abs(this._headerRect.y + this._headerRect.height - y) <= 4) {
            this._headerDragged = true;
            return;
        }
        boolean doSelect = true;
        if (this._tableRect.contains(x, y) || this._fixedColumns > 0 && this._fixedColRect.contains(x, y) || this._fixedRows > 0 && this._fixedRowRect.contains(x, y)) {
            this.setFocus(x, y);
            boolean bl = doSelect = !this.handleEditorSingleClick(x, y);
        }
        if (this._tableRect.contains(x, y) || this._fixedColumns > 0 && this._fixedColRect.contains(x, y) || this._fixedRows > 0 && this._fixedRowRect.contains(x, y)) {
            IRow xrow = this.rowForY(y);
            IColumn xcol = this.colForX(x);
            if (xrow != null && xcol != null && this.isHierarchyColumn(xrow, xcol)) {
                Rectangle rect = this.getCellBounds(xrow, xcol);
                IHierarchyRenderer hrenderer = (IHierarchyRenderer)this.getCellRenderer(xrow, xcol);
                if (hrenderer.isInActiveArea(xrow, rect, x, y)) {
                    this.toggleExpanded(xrow);
                }
            }
        }
        IColumn xcol = this.colForX(x);
        if (this._allowSorting && this._headerRect.contains(x, y) && this._headerRenderer.isSortingClick(this.getHeaderDrawingArea(xcol), xcol, x, y)) {
            this._tvs.setSorting(xcol);
        } else if (doSelect) {
            this.handleSelection(x, y, stateMask, false);
        }
    }

    private void toggleExpanded(IRow row) {
        IHierarchicalTableViewState hvs = (IHierarchicalTableViewState)this._tvs;
        hvs.setExpanded((ITableNode)row, !hvs.isExpanded((ITableNode)row));
    }

    private boolean isHierarchyColumn(IRow row, IColumn col) {
        if (row == null || col == null) {
            return false;
        }
        return this.getCellRenderer(row, col) instanceof TableHierarchyRenderer;
    }

    public boolean isHierarchyColumn(IColumn column) {
        if (column == null) {
            return false;
        }
        return this.isHierarchyColumn(this._rows.get(0), column);
    }

    private Rectangle getHeaderDrawingArea(IColumn col) {
        int x = this.getColInfo((IColumn)col).x;
        Rectangle r = new Rectangle(x, this._tableRect.y, this._tvs.getColumnWidth(col), this._tableRect.height);
        return r;
    }

    private boolean isRowSelection(int x, int y) {
        return Math.abs(x - this._tableRect.x) <= 4 || this._fixedColRect != null && this._fixedColRect.contains(x, y);
    }

    private boolean isColumnSelection(int x, int y) {
        return this._headerRect != null && this._headerRect.contains(x, y) || this._fixedRowRect != null && this._fixedRowRect.contains(x, y);
    }

    private void handleSelection(int x, int y, int stateMask, boolean dragging) {
        this._lastKeySelect = null;
        this._firstKeySelect = null;
        this._firstKeyColSelectIdx = -1;
        this._lastKeyColSelectIdx = -1;
        this._firstKeyRowSelectIdx = -1;
        this._lastKeyRowSelectIdx = -1;
        IRow row = this.rowForY(y);
        int rowIdx = row != null ? this._rows.indexOf(row) : -1;
        IColumn col = this.colForX(x);
        int colIdx = this.getColumnIdx(col);
        if (dragging && this._isFillDrag) {
            if (this._selectionModel.isCellSelectionAllowed() && this._tableRect.contains(x, y) && col != null && row != null) {
                if (this._firstCellSelectX == -1) {
                    this._firstCellSelectX = colIdx;
                    this._firstCellSelectY = rowIdx;
                }
                if (Math.abs(this._firstCellSelectX - colIdx) > Math.abs(this._firstCellSelectY - rowIdx)) {
                    rowIdx = this._firstCellSelectY;
                    row = this.rowForIdx(rowIdx);
                    this._horizontalFillDrag = false;
                } else {
                    colIdx = this._firstCellSelectX;
                    col = this.colForIdx(colIdx);
                    this._horizontalFillDrag = true;
                }
                this.ensureSelectionContainsRegion(this._firstFillDragSelect, colIdx, rowIdx, this._lastCellSelectX, this._lastCellSelectY);
                this._lastCellSelectX = colIdx;
                this._lastCellSelectY = rowIdx;
                this.setFocus(row, col);
            }
            return;
        }
        if (row != null && this._selectionModel.isFullRowSelectionAllowed() && (this.isRowSelection(x, y) || this._selectionModel.isOnlyRowSelectionAllowed() || this._firstRowSelectIdx != -1)) {
            if (this._firstRowSelectIdx == -1) {
                this._firstRowSelectIdx = rowIdx;
            }
            if ((stateMask & 0x40000) != 0) {
                if (!this._selectionModel.getSelection().getSelectedRows().contains(row)) {
                    this._selectionModel.addSelectedRow(row);
                } else {
                    this._selectionModel.remSelectedRow(row);
                }
                this._lastSelectType = SelectType.ROW;
            } else if (dragging) {
                this.ensureSelectionContainsRowRegion(this._firstRowSelectIdx, rowIdx, this._lastRowSelectIdx);
                this._lastRowSelectIdx = rowIdx;
                this._lastSelectType = SelectType.ROW;
            } else {
                this._selectionModel.clearSelection();
                this._selectionModel.addSelectedRow(row);
                this._lastSelectType = SelectType.ROW;
            }
            this._lastRowSelectIdx = rowIdx;
            return;
        }
        if (this._selectionModel.isFullColumnSelectionAllowed() && (this.isColumnSelection(x, y) || this._firstColSelectIdx != -1)) {
            if (this._firstColSelectIdx == -1) {
                this._firstColSelectIdx = colIdx;
            }
            if ((stateMask & 0x40000) != 0) {
                if (!this._selectionModel.getSelection().getSelectedColumns().contains(col)) {
                    this._selectionModel.addSelectedColumn(col);
                } else {
                    this._selectionModel.remSelectedColumn(col);
                }
                this._lastSelectType = SelectType.COLUMN;
            } else if (dragging) {
                this.ensureSelectionContainsColRegion(this._firstColSelectIdx, colIdx, this._lastColSelectIdx);
                this._lastColSelectIdx = colIdx;
                this._lastSelectType = SelectType.COLUMN;
            } else {
                this._selectionModel.clearSelection();
                this._selectionModel.addSelectedColumn(col);
                this._lastSelectType = SelectType.COLUMN;
            }
            this._lastColSelectIdx = colIdx;
            return;
        }
        if (this._selectionModel.isCellSelectionAllowed() && this._tableRect.contains(x, y) && col != null && row != null) {
            JaretTableCellImpl cell = new JaretTableCellImpl(row, col);
            if (this._firstCellSelectX == -1) {
                this._firstCellSelectX = colIdx;
                this._firstCellSelectY = rowIdx;
            }
            if ((stateMask & 0x40000) != 0) {
                if (!this._selectionModel.getSelection().getSelectedCells().contains(cell)) {
                    this._selectionModel.addSelectedCell(cell);
                } else {
                    this._selectionModel.remSelectedCell(cell);
                }
                this._lastSelectType = SelectType.CELL;
            } else if (dragging) {
                this.ensureSelectionContainsRegion(this._firstCellSelectX, this._firstCellSelectY, colIdx, rowIdx, this._lastCellSelectX, this._lastCellSelectY);
                this._lastCellSelectX = colIdx;
                this._lastCellSelectY = rowIdx;
                this._lastSelectType = SelectType.CELL;
            } else {
                this._selectionModel.clearSelection();
                this._selectionModel.addSelectedCell(cell);
                this._lastSelectType = SelectType.CELL;
            }
            this.setFocus(row, col);
        }
    }

    private void ensureSelectionContainsRowRegion(int firstRowSelectIdx, int rowIdx, int lastRowSelectIdx) {
        int first = Math.min(firstRowSelectIdx, rowIdx);
        int end = Math.max(firstRowSelectIdx, rowIdx);
        for (int i = first; i <= end; ++i) {
            IRow row = this.rowForIdx(i);
            if (this._selectionModel.getSelection().getSelectedRows().contains(row)) continue;
            this._selectionModel.addSelectedRow(row);
        }
        if (lastRowSelectIdx != -1) {
            int f = Math.min(firstRowSelectIdx, lastRowSelectIdx);
            int e = Math.max(firstRowSelectIdx, lastRowSelectIdx);
            for (int i = f; i <= e; ++i) {
                if (i >= first && i <= end) continue;
                IRow row = this.rowForIdx(i);
                this._selectionModel.remSelectedRow(row);
            }
        }
    }

    private void ensureSelectionContainsColRegion(int firstColIdx, int colIdx, int lastColSelectIdx) {
        int first = Math.min(firstColIdx, colIdx);
        int end = Math.max(firstColIdx, colIdx);
        for (int i = first; i <= end; ++i) {
            IColumn col = this.colForIdx(i);
            if (this._selectionModel.getSelection().getSelectedColumns().contains(col)) continue;
            this._selectionModel.addSelectedColumn(col);
        }
        if (lastColSelectIdx != -1) {
            int f = Math.min(firstColIdx, lastColSelectIdx);
            int e = Math.max(firstColIdx, lastColSelectIdx);
            for (int i = f; i <= e; ++i) {
                if (i >= first && i <= end) continue;
                IColumn col = this.colForIdx(i);
                this._selectionModel.remSelectedColumn(col);
            }
        }
    }

    private void ensureSelectionContainsRegion(int firstCellSelectX, int firstCellSelectY, int colIdx, int rowIdx, int lastCellSelectX, int lastCellSelectY) {
        int firstx = Math.min(firstCellSelectX, colIdx);
        int endx = Math.max(firstCellSelectX, colIdx);
        int firsty = Math.min(firstCellSelectY, rowIdx);
        int endy = Math.max(firstCellSelectY, rowIdx);
        for (int x = firstx; x <= endx; ++x) {
            for (int y = firsty; y <= endy; ++y) {
                JaretTableCellImpl cell = new JaretTableCellImpl(this.rowForIdx(y), this.colForIdx(x));
                if (this._selectionModel.getSelection().getSelectedCells().contains(cell)) continue;
                this._selectionModel.addSelectedCell(cell);
            }
        }
        if (lastCellSelectX != -1) {
            int lfx = Math.min(firstCellSelectX, lastCellSelectX);
            int lex = Math.max(firstCellSelectX, lastCellSelectX);
            int lfy = Math.min(firstCellSelectY, lastCellSelectY);
            int ley = Math.max(firstCellSelectY, lastCellSelectY);
            for (int x = lfx; x <= lex; ++x) {
                for (int y = lfy; y <= ley; ++y) {
                    if (x >= firstx && x <= endx && y >= firsty && y <= endy) continue;
                    JaretTableCellImpl cell = new JaretTableCellImpl(this.rowForIdx(y), this.colForIdx(x));
                    this._selectionModel.remSelectedCell(cell);
                }
            }
        }
    }

    private void ensureSelectionContainsRegion(Rectangle firstIdxRect, int colIdx, int rowIdx, int lastCellSelectX, int lastCellSelectY) {
        int firstx = Math.min(firstIdxRect.x, colIdx);
        int endx = Math.max(firstIdxRect.x + firstIdxRect.width - 1, colIdx);
        int firsty = Math.min(firstIdxRect.y, rowIdx);
        int endy = Math.max(firstIdxRect.y + firstIdxRect.height - 1, rowIdx);
        for (int x = firstx; x <= endx; ++x) {
            for (int y = firsty; y <= endy; ++y) {
                JaretTableCellImpl cell = new JaretTableCellImpl(this.rowForIdx(y), this.colForIdx(x));
                if (this._selectionModel.getSelection().getSelectedCells().contains(cell)) continue;
                this._selectionModel.addSelectedCell(cell);
            }
        }
        if (lastCellSelectX != -1 && lastCellSelectY != -1) {
            int lfx = Math.min(firstIdxRect.x, lastCellSelectX);
            int lex = Math.max(firstIdxRect.x + firstIdxRect.width - 1, lastCellSelectX);
            int lfy = Math.min(firstIdxRect.y, lastCellSelectY);
            int ley = Math.max(firstIdxRect.y + firstIdxRect.height - 1, lastCellSelectY);
            for (int x = lfx; x <= lex; ++x) {
                for (int y = lfy; y <= ley; ++y) {
                    if (x >= firstx && x <= endx && y >= firsty && y <= endy) continue;
                    JaretTableCellImpl cell = new JaretTableCellImpl(this.rowForIdx(y), this.colForIdx(x));
                    this._selectionModel.remSelectedCell(cell);
                }
            }
        }
    }

    private void mouseDragged(int x, int y, int stateMask) {
        if (this._isFillDrag) {
            this.handleSelection(x, y, stateMask, true);
        } else if (this._heightDraggedRowInfo != null) {
            int newHeight = y - this._heightDraggedRowInfo.y;
            if (newHeight < this._tvs.getMinimalRowHeight()) {
                newHeight = this._tvs.getMinimalRowHeight();
            }
            this._tvs.setRowHeight(this._heightDraggedRowInfo.row, newHeight);
            if (this._tvs.getRowHeigthMode(this._heightDraggedRowInfo.row) == ITableViewState.RowHeightMode.OPTANDVAR) {
                this._tvs.setRowHeightMode(this._heightDraggedRowInfo.row, ITableViewState.RowHeightMode.VARIABLE);
            }
        } else if (this._widthDraggedColumn != null) {
            int newWidth = x - this._widthDraggedColumn.x;
            if (newWidth < this._tvs.getMinimalColWidth()) {
                newWidth = this._tvs.getMinimalColWidth();
            }
            if (this._tvs.getColumnWidth(this._widthDraggedColumn.column) != newWidth) {
                this._tvs.setColumnWidth(this._widthDraggedColumn.column, newWidth);
            }
        } else if (this._headerDragged) {
            int newHeight = y - this._headerRect.y;
            if (newHeight < this._minHeaderHeight) {
                newHeight = this._minHeaderHeight;
            }
            this.setHeaderHeight(newHeight);
        } else {
            this.handleSelection(x, y, stateMask, true);
        }
    }

    private void mouseMoved(int x, int y, int stateMask) {
        Shell activeShell;
        Display display = Display.getCurrent();
        Shell shell = activeShell = display != null ? display.getActiveShell() : null;
        if (this._dragMarkerRect != null && this._dragMarkerRect.contains(x, y)) {
            if (activeShell != null) {
                activeShell.setCursor(display.getSystemCursor(5));
            }
            return;
        }
        IRow row = this.rowByBottomBorder(y);
        if (row != null && this._rowResizeAllowed && (this._tvs.getRowHeigthMode(row) == ITableViewState.RowHeightMode.VARIABLE || this._tvs.getRowHeigthMode(row) == ITableViewState.RowHeightMode.OPTANDVAR) && (!this._resizeRestriction || Math.abs(x - this._tableRect.x) <= 4 || this._fixedColRect != null && this._fixedColRect.contains(x, y))) {
            if (activeShell != null) {
                activeShell.setCursor(display.getSystemCursor(7));
            }
            return;
        }
        IColumn col = this.colByRightBorder(x);
        if (col != null && this._columnResizeAllowed && this._tvs.columnResizingAllowed(col) && (!this._resizeRestriction || this._headerRect == null || this._headerRect.contains(x, y))) {
            if (activeShell != null) {
                activeShell.setCursor(display.getSystemCursor(13));
            }
            return;
        }
        if (this._headerRect != null && this._headerResizeAllowed && Math.abs(this._headerRect.y + this._headerRect.height - y) <= 4) {
            if (activeShell != null) {
                activeShell.setCursor(display.getSystemCursor(7));
            }
            return;
        }
        if (Display.getCurrent().getActiveShell() != null) {
            Display.getCurrent().getActiveShell().setCursor(Display.getCurrent().getSystemCursor(0));
        }
    }

    private void mouseReleased(int x, int y, boolean popUpTrigger) {
        if (this._isFillDrag) {
            this.handleFill();
        }
        this._heightDraggedRowInfo = null;
        this._widthDraggedColumn = null;
        this._headerDragged = false;
        this._firstCellSelectX = -1;
        this._firstCellSelectY = -1;
        this._lastCellSelectX = -1;
        this._lastCellSelectY = -1;
        this._firstColSelectIdx = -1;
        this._firstRowSelectIdx = -1;
        this._isFillDrag = false;
        if (this._headerRect.contains(x, y) && popUpTrigger) {
            this.displayHeaderContextMenu(x, y);
        } else if (popUpTrigger && this.isRowSelection(x, y)) {
            this.displayRowContextMenu(x, y);
        }
    }

    private void handleFill() {
        block4: {
            if (this._fillDragStrategy == null) break block4;
            if (this._horizontalFillDrag) {
                for (int i = this._firstFillDragSelect.x; i < this._firstFillDragSelect.x + this._firstFillDragSelect.width; ++i) {
                    IJaretTableCell firstCell = this.getCellForIdx(i, this._firstFillDragSelect.y);
                    List<IJaretTableCell> cells = this.getSelectedCellsVertical(i);
                    cells.remove(firstCell);
                    this._fillDragStrategy.doFill(this, firstCell, cells);
                }
            } else {
                for (int i = this._firstFillDragSelect.y; i < this._firstFillDragSelect.y + this._firstFillDragSelect.height; ++i) {
                    IJaretTableCell firstCell = this.getCellForIdx(this._firstFillDragSelect.x, i);
                    List<IJaretTableCell> cells = this.getSelectedCellsHorizontal(i);
                    cells.remove(firstCell);
                    this._fillDragStrategy.doFill(this, firstCell, cells);
                }
            }
        }
    }

    private List<IJaretTableCell> getSelectedCellsVertical(int x) {
        ArrayList<IJaretTableCell> cells = new ArrayList<IJaretTableCell>();
        List<IJaretTableCell> s = this.getSelectionModel().getSelection().getSelectedCells();
        for (IJaretTableCell cell : s) {
            Point p = this.getCellDisplayIdx(cell);
            if (p.x != x) continue;
            cells.add(cell);
        }
        return cells;
    }

    private List<IJaretTableCell> getSelectedCellsHorizontal(int y) {
        ArrayList<IJaretTableCell> cells = new ArrayList<IJaretTableCell>();
        List<IJaretTableCell> s = this.getSelectionModel().getSelection().getSelectedCells();
        for (IJaretTableCell cell : s) {
            Point p = this.getCellDisplayIdx(cell);
            if (p.y != y) continue;
            cells.add(cell);
        }
        return cells;
    }

    private String getToolTipText(int x, int y) {
        IJaretTableCell cell = this.getCell(x, y);
        if (cell != null) {
            String tt;
            Rectangle bounds = this.getCellBounds(cell);
            ICellRenderer renderer = this.getCellRenderer(cell.getRow(), cell.getColumn());
            if (renderer != null && (tt = renderer.getTooltip(this, bounds, cell.getRow(), cell.getColumn(), x, y)) != null) {
                return tt;
            }
        }
        return null;
    }

    private void handleKeyPressed(KeyEvent event) {
        if ((event.stateMask & 0x20000) != 0 && Character.isISOControl(event.character)) {
            switch (event.keyCode) {
                case 0x1000004: {
                    this.selectRight();
                    break;
                }
                case 0x1000003: {
                    this.selectLeft();
                    break;
                }
                case 0x1000002: {
                    this.selectDown();
                    break;
                }
                case 0x1000001: {
                    this.selectUp();
                    break;
                }
            }
        } else if ((event.stateMask & 0x40000) != 0 && Character.isISOControl(event.character)) {
            switch (event.keyCode) {
                case 99: {
                    this.copy();
                    break;
                }
                case 120: {
                    this.cut();
                    break;
                }
                case 118: {
                    this.paste();
                    break;
                }
                case 97: {
                    this.selectAll();
                    break;
                }
            }
        } else {
            this._lastKeySelect = null;
            this._firstKeySelect = null;
            switch (event.keyCode) {
                case 0x1000004: {
                    this.focusRight();
                    break;
                }
                case 0x1000003: {
                    this.focusLeft();
                    break;
                }
                case 0x1000002: {
                    this.focusDown();
                    break;
                }
                case 0x1000001: {
                    this.focusUp();
                    break;
                }
                case 9: {
                    this.focusRight();
                    break;
                }
                case 0x100000B: {
                    this.startEditing(this._focussedRow, this._focussedColumn, '\u0000');
                    break;
                }
                default: {
                    if (event.character == ' ' && this.isHierarchyColumn(this._focussedRow, this._focussedColumn)) {
                        this.toggleExpanded(this._focussedRow);
                        break;
                    }
                    if (Character.isISOControl(event.character)) break;
                    this.startEditing(event.character);
                }
            }
        }
    }

    private void selectRight() {
        IJaretTableCell cell = this.getFocussedCell();
        if (this._lastSelectType == SelectType.CELL && cell != null) {
            int cx = this.getColumnIdx(cell.getColumn());
            int cy = this.getRowIdx(cell.getRow());
            if (this._lastKeySelect == null) {
                this._lastKeySelect = new Point(-1, -1);
            }
            if (this._firstKeySelect == null) {
                this._firstKeySelect = new Point(cx, cy);
                this._selectionModel.clearSelection();
            }
            this.focusRight();
            cell = this.getFocussedCell();
            cx = this.getColumnIdx(cell.getColumn());
            cy = this.getRowIdx(cell.getRow());
            this.ensureSelectionContainsRegion(this._firstKeySelect.x, this._firstKeySelect.y, cx, cy, this._lastKeySelect.x, this._lastKeySelect.y);
            this._lastSelectType = SelectType.CELL;
            this._lastKeySelect = new Point(cx, cy);
        } else if (this._lastSelectType == SelectType.COLUMN && (this._lastColSelectIdx != -1 || this._lastKeyColSelectIdx != -1)) {
            int colIdx;
            if (this._firstKeyColSelectIdx == -1) {
                this._firstKeyColSelectIdx = this._lastColSelectIdx;
            }
            int n = colIdx = this._lastKeyColSelectIdx != -1 ? this._lastKeyColSelectIdx + 1 : this._firstKeyColSelectIdx + 1;
            if (colIdx > this._cols.size() - 1) {
                colIdx = this._cols.size() - 1;
            }
            this.ensureSelectionContainsColRegion(this._firstKeyColSelectIdx, colIdx, this._lastKeyColSelectIdx);
            this._lastKeyColSelectIdx = colIdx;
        }
    }

    private void selectLeft() {
        IJaretTableCell cell = this.getFocussedCell();
        if (this._lastSelectType == SelectType.CELL && cell != null) {
            if (cell != null) {
                int cx = this.getColumnIdx(cell.getColumn());
                int cy = this.getRowIdx(cell.getRow());
                if (this._lastKeySelect == null) {
                    this._lastKeySelect = new Point(-1, -1);
                }
                if (this._firstKeySelect == null) {
                    this._firstKeySelect = new Point(cx, cy);
                    this._selectionModel.clearSelection();
                }
                this.focusLeft();
                cell = this.getFocussedCell();
                cx = this.getColumnIdx(cell.getColumn());
                cy = this.getRowIdx(cell.getRow());
                this.ensureSelectionContainsRegion(this._firstKeySelect.x, this._firstKeySelect.y, cx, cy, this._lastKeySelect.x, this._lastKeySelect.y);
                this._lastSelectType = SelectType.CELL;
                this._lastKeySelect = new Point(cx, cy);
            }
        } else if (this._lastSelectType == SelectType.COLUMN && (this._lastColSelectIdx != -1 || this._lastKeyColSelectIdx != -1)) {
            int colIdx;
            if (this._firstKeyColSelectIdx == -1) {
                this._firstKeyColSelectIdx = this._lastColSelectIdx;
            }
            int n = colIdx = this._lastKeyColSelectIdx != -1 ? this._lastKeyColSelectIdx - 1 : this._firstKeyColSelectIdx - 1;
            if (colIdx < 0) {
                colIdx = 0;
            }
            this.ensureSelectionContainsColRegion(this._firstKeyColSelectIdx, colIdx, this._lastKeyColSelectIdx);
            this._lastKeyColSelectIdx = colIdx;
        }
    }

    private void selectDown() {
        IJaretTableCell cell = this.getFocussedCell();
        if (this._lastSelectType == SelectType.CELL && cell != null) {
            if (cell != null) {
                int cx = this.getColumnIdx(cell.getColumn());
                int cy = this.getRowIdx(cell.getRow());
                if (this._lastKeySelect == null) {
                    this._lastKeySelect = new Point(-1, -1);
                }
                if (this._firstKeySelect == null) {
                    this._firstKeySelect = new Point(cx, cy);
                    this._selectionModel.clearSelection();
                }
                this.focusDown();
                cell = this.getFocussedCell();
                cx = this.getColumnIdx(cell.getColumn());
                cy = this.getRowIdx(cell.getRow());
                this.ensureSelectionContainsRegion(this._firstKeySelect.x, this._firstKeySelect.y, cx, cy, this._lastKeySelect.x, this._lastKeySelect.y);
                this._lastSelectType = SelectType.CELL;
                this._lastKeySelect = new Point(cx, cy);
            }
        } else if (this._lastSelectType == SelectType.ROW && (this._lastRowSelectIdx != -1 || this._lastKeyRowSelectIdx != -1)) {
            int rowIdx;
            if (this._firstKeyRowSelectIdx == -1) {
                this._firstKeyRowSelectIdx = this._lastRowSelectIdx;
            }
            int n = rowIdx = this._lastKeyRowSelectIdx != -1 ? this._lastKeyRowSelectIdx + 1 : this._firstKeyRowSelectIdx + 1;
            if (rowIdx > this._rows.size() - 1) {
                rowIdx = this._rows.size() - 1;
            }
            this.ensureSelectionContainsRowRegion(this._firstKeyRowSelectIdx, rowIdx, this._lastKeyRowSelectIdx);
            this._lastKeyRowSelectIdx = rowIdx;
        }
    }

    private void selectUp() {
        IJaretTableCell cell = this.getFocussedCell();
        if (this._lastSelectType == SelectType.CELL && cell != null) {
            if (cell != null) {
                int cx = this.getColumnIdx(cell.getColumn());
                int cy = this.getRowIdx(cell.getRow());
                if (this._lastKeySelect == null) {
                    this._lastKeySelect = new Point(-1, -1);
                }
                if (this._firstKeySelect == null) {
                    this._firstKeySelect = new Point(cx, cy);
                    this._selectionModel.clearSelection();
                }
                this.focusUp();
                cell = this.getFocussedCell();
                cx = this.getColumnIdx(cell.getColumn());
                cy = this.getRowIdx(cell.getRow());
                this.ensureSelectionContainsRegion(this._firstKeySelect.x, this._firstKeySelect.y, cx, cy, this._lastKeySelect.x, this._lastKeySelect.y);
                this._lastSelectType = SelectType.CELL;
                this._lastKeySelect = new Point(cx, cy);
            }
        } else if (this._lastSelectType == SelectType.ROW && (this._lastRowSelectIdx != -1 || this._lastKeyRowSelectIdx != -1)) {
            int rowIdx;
            if (this._firstKeyRowSelectIdx == -1) {
                this._firstKeyRowSelectIdx = this._lastRowSelectIdx;
            }
            int n = rowIdx = this._lastKeyRowSelectIdx != -1 ? this._lastKeyRowSelectIdx - 1 : this._firstKeyRowSelectIdx - 1;
            if (rowIdx < 0) {
                rowIdx = 0;
            }
            this.ensureSelectionContainsRowRegion(this._firstKeyRowSelectIdx, rowIdx, this._lastKeyRowSelectIdx);
            this._lastKeyRowSelectIdx = rowIdx;
        }
    }

    public IJaretTableCell getFocussedCell() {
        if (this._focussedColumn != null && this._focussedRow != null) {
            return new JaretTableCellImpl(this._focussedRow, this._focussedColumn);
        }
        return null;
    }

    public Point getFocussedCellIdx() {
        if (this._focussedColumn != null && this._focussedRow != null) {
            return new Point(this.getColumnIdx(this._focussedColumn), this.getRowIdx(this._focussedRow));
        }
        return null;
    }

    public Point getCellDisplayIdx(IJaretTableCell cell) {
        return new Point(this.getColumnIdx(cell.getColumn()), this.getRowIdx(cell.getRow()));
    }

    public void setValue(int colIdx, int rowIdx, Object value) {
        IColumn col = this.getColumn(colIdx);
        IRow row = this.getRow(rowIdx);
        col.setValue(row, value);
    }

    public boolean setFocus() {
        super.setFocus();
        if (this._focussedRow == null && this._rows != null && this._rows.size() > 0 && this._cols.size() > 0) {
            this.setFocus(this._rows.get(this._firstRowIdx), this._cols.get(this._firstColIdx));
        }
        return true;
    }

    private void ensureFocus() {
        if (this._focussedRow == null) {
            this._focussedRow = this._rows.get(0);
        }
        if (this._focussedColumn == null) {
            this._focussedColumn = this._cols.get(0);
        }
    }

    public void focusLeft() {
        this.ensureFocus();
        int idx = this._cols.indexOf(this._focussedColumn);
        if (idx > 0) {
            this.setFocus(this._focussedRow, this._cols.get(idx - 1));
        }
    }

    public void focusRight() {
        this.ensureFocus();
        int idx = this._cols.indexOf(this._focussedColumn);
        if (idx < this._cols.size() - 1) {
            this.setFocus(this._focussedRow, this._cols.get(idx + 1));
        }
    }

    public void focusUp() {
        this.ensureFocus();
        int idx = this._rows.indexOf(this._focussedRow);
        if (idx > 0) {
            this.setFocus(this._rows.get(idx - 1), this._focussedColumn);
        }
    }

    public void focusDown() {
        this.ensureFocus();
        int idx = this._rows.indexOf(this._focussedRow);
        if (idx < this._rows.size() - 1) {
            this.setFocus(this._rows.get(idx + 1), this._focussedColumn);
        }
    }

    private void setFocus(int x, int y) {
        IRow row = this.rowForY(y);
        IColumn col = this.colForX(x);
        if (col != null && row != null) {
            this.setFocus(row, col);
        }
    }

    public boolean isEditing() {
        return this._editor != null;
    }

    private boolean handleEditorSingleClick(int x, int y) {
        ICellEditor editor;
        IRow row = this.rowForY(y);
        IColumn col = this.colForX(x);
        if (col != null && row != null && (editor = this.getCellEditor(row, col)) != null) {
            Rectangle area = this.getCellBounds(row, col);
            return editor.handleClick(this, row, col, area, x, y);
        }
        return false;
    }

    private void startEditing(char typedKey) {
        if (this._focussedRow != null && this._focussedColumn != null) {
            this.startEditing(this._focussedRow, this._focussedColumn, typedKey);
        }
    }

    public void startEditing(IRow row, IColumn col, char typedKey) {
        if (this.isEditing()) {
            this.stopEditing(true);
        }
        if (!this._model.isEditable(row, col)) {
            return;
        }
        this.clearSelection();
        if (row != null && col != null) {
            this._editor = this.getCellEditor(row, col);
            if (this._editor != null) {
                this._editorControl = this._editor.getEditorControl(this, row, col, typedKey);
                if (this._editorControl != null) {
                    Rectangle bounds = this.getCellBounds(row, col);
                    ++bounds.x;
                    --bounds.width;
                    ++bounds.y;
                    bounds.height = this._editor.getPreferredHeight() == -1 || this._editor.getPreferredHeight() < bounds.height ? --bounds.height : this._editor.getPreferredHeight();
                    this._editorControl.setBounds(bounds);
                    this._editorControl.setVisible(true);
                    this._editorControl.forceFocus();
                }
                this._editorRow = row;
            }
        }
        if (this._editorControl == null) {
            this.stopEditing(true);
        }
    }

    private void clearSelection() {
        this._selectionModel.clearSelection();
    }

    public void stopEditing(boolean storeValue) {
        if (this.isEditing()) {
            this._editor.stopEditing(storeValue);
            if (storeValue && this._tvs.getRowHeigthMode(this._editorRow) == ITableViewState.RowHeightMode.OPTIMAL || this._tvs.getRowHeigthMode(this._editorRow) == ITableViewState.RowHeightMode.OPTANDVAR) {
                this.optimizeHeight(this._editorRow);
            }
            this._editorRow = null;
            this._editor = null;
        }
    }

    private void setFocus(IRow row, IColumn col) {
        if (this._focussedRow != row || this._focussedColumn != col) {
            IRow oldRow = this._focussedRow;
            IColumn oldCol = this._focussedColumn;
            this._focussedRow = row;
            this._focussedColumn = col;
            if (this.isCompleteVisible(this._focussedRow, this._focussedColumn)) {
                this.redraw(this._focussedRow, this._focussedColumn);
                if (oldRow != null && oldCol != null) {
                    this.redraw(oldRow, oldCol);
                }
            } else {
                this.scrollToVisible(this._focussedRow, this._focussedColumn);
            }
            this.fireTableFocusChanged(row, col);
        }
    }

    private int getPreferredRowHeight(GC gc, IRow row) {
        int result = -1;
        for (IColumn column : this._cols) {
            ICellStyle cellStyle;
            ICellRenderer renderer;
            int ph;
            if (!this._tvs.getColumnVisible(column) || (ph = (renderer = this.getCellRenderer(row, column)).getPreferredHeight(gc, cellStyle = this._tvs.getCellStyle(row, column), this._tvs.getColumnWidth(column), row, column)) <= result) continue;
            result = ph;
        }
        return result;
    }

    public void optimizeHeight(IRow row) {
        this._rowsToOptimize.add(row);
        this.syncedRedraw();
    }

    private void doNotOptimizeHeight(IRow row) {
        this._rowsToOptimize.remove(row);
    }

    public void optimizeHeight(List<IRow> rows) {
        this._rowsToOptimize.addAll(rows);
        this.syncedRedraw();
    }

    private void doRowHeightOptimization(GC gc) {
        for (IRow row : this._rowsToOptimize) {
            int h = this.getPreferredRowHeight(gc, row);
            if (h == -1) continue;
            this._tvs.setRowHeight(row, h);
        }
        this._rowsToOptimize.clear();
    }

    public void scrollToVisible(IRow row, IColumn column) {
        int shownX;
        int cIdx;
        int cellX;
        int shownY;
        int rIdx = this._rows.indexOf(row);
        int cellY = this.getAbsBeginYForRowIdx(rIdx) - this.getFixedRowsHeight();
        if (cellY < (shownY = this.getAbsBeginYForRowIdx(this._firstRowIdx) + this._firstRowPixelOffset - this.getFixedRowsHeight())) {
            if (this.getVerticalBar() != null) {
                this.getVerticalBar().setSelection(cellY);
            }
        } else {
            int cellHeight = this._tvs.getRowHeight(row);
            if (this.getVerticalBar() != null) {
                this.getVerticalBar().setSelection(cellY + cellHeight - this._tableRect.height);
            }
        }
        if ((cellX = this.getAbsBeginXForColIdx(cIdx = this._cols.indexOf(column)) - this.getFixedColumnsWidth()) < (shownX = this.getAbsBeginXForColIdx(this._firstColIdx) - this.getFixedColumnsWidth())) {
            if (this.getHorizontalBar() != null) {
                this.getHorizontalBar().setSelection(cellX);
            }
        } else {
            int cellWidth = this._tvs.getColumnWidth(column);
            if (this.getHorizontalBar() != null) {
                this.getHorizontalBar().setSelection(cellX + cellWidth - this._tableRect.width);
            }
        }
        this.updateScrollBars();
        this.redraw();
    }

    private boolean isCompleteVisible(IRow row, IColumn column) {
        RowInfo rInfo = this.getRowInfo(row);
        if (rInfo == null) {
            return false;
        }
        ColInfo cInfo = this.getColInfo(column);
        if (cInfo == null) {
            return false;
        }
        Rectangle b = this.getCellBounds(rInfo, cInfo);
        if (!this._tableRect.contains(b.x, b.y) || !this._tableRect.contains(b.x + b.width, b.y + b.height)) {
            if (this._fixedColumns == 0 && this._fixedRows == 0) {
                return false;
            }
            if (this._fixedColumns > 0 && this._fixedColRect.contains(b.x, b.y) && this._fixedColRect.contains(b.x + b.width, b.y + b.height)) {
                return true;
            }
            return this._fixedRows > 0 && this._fixedRowRect.contains(b.x, b.y) && this._fixedRowRect.contains(b.x + b.width, b.y + b.height);
        }
        return true;
    }

    public boolean isDisplayed(IRow row) {
        RowInfo rInfo = this.getRowInfo(row);
        return rInfo != null;
    }

    public boolean isDisplayed(IColumn column) {
        ColInfo cInfo = this.getColInfo(column);
        return cInfo != null;
    }

    private IRow rowByBottomBorder(int y) {
        for (RowInfo info : this.getRowInfos()) {
            int by = info.y + info.height;
            if (Math.abs(by - y) > 4) continue;
            return info.row;
        }
        return null;
    }

    protected RowInfo getRowInfo(IRow row) {
        for (RowInfo info : this.getRowInfos()) {
            if (!info.row.equals(row)) continue;
            return info;
        }
        return null;
    }

    private IColumn colByRightBorder(int x) {
        if (this._colInfoCache != null) {
            for (ColInfo info : this._colInfoCache) {
                int bx = info.x + info.width;
                if (Math.abs(bx - x) > 4) continue;
                return info.column;
            }
        }
        return null;
    }

    private ColInfo getColInfo(IColumn col) {
        if (this._colInfoCache != null) {
            for (ColInfo info : this._colInfoCache) {
                if (!info.column.equals(col)) continue;
                return info;
            }
        }
        return null;
    }

    private Rectangle getCellBounds(IRow row, IColumn column) {
        RowInfo rInfo = this.getRowInfo(row);
        ColInfo cInfo = this.getColInfo(column);
        if (rInfo == null || cInfo == null) {
            return null;
        }
        return this.getCellBounds(rInfo, cInfo);
    }

    private Rectangle getCellBounds(RowInfo rInfo, ColInfo cInfo) {
        return new Rectangle(cInfo.x, rInfo.y, cInfo.width, rInfo.height);
    }

    private Rectangle getCellBounds(IJaretTableCell cell) {
        return this.getCellBounds(cell.getRow(), cell.getColumn());
    }

    private Rectangle getRowBounds(IRow row) {
        RowInfo rInfo = this.getRowInfo(row);
        return rInfo == null ? null : this.getRowBounds(rInfo);
    }

    private Rectangle getRowBounds(RowInfo info) {
        int bx = this._fixedColumns == 0 ? this._tableRect.x : this._fixedColRect.x;
        int width = this._fixedColumns == 0 ? this._tableRect.width : this._fixedColRect.width + this._tableRect.width;
        return new Rectangle(bx, info.y, width, info.height);
    }

    public Rectangle getColumnBounds(IColumn column) {
        ColInfo cInfo = this.getColInfo(column);
        return cInfo != null ? this.getColumnBounds(cInfo) : null;
    }

    private Rectangle getColumnBounds(ColInfo info) {
        int by = this._fixedRows == 0 ? this._tableRect.y : this._fixedRowRect.y;
        int height = this._fixedRows == 0 ? this._tableRect.height : this._fixedRowRect.height + this._tableRect.height;
        return new Rectangle(info.x, by, info.width, height);
    }

    private void redraw(IRow row, IColumn column) {
        Rectangle r = this.getCellBounds(row, column);
        if (r != null) {
            this.syncedRedraw(r.x, r.y, r.width, r.height);
        }
    }

    private void redraw(IRow row) {
        Rectangle r = this.getRowBounds(row);
        if (r != null) {
            this.syncedRedraw(r.x, r.y, r.width, r.height);
        }
    }

    private void redraw(IColumn column) {
        Rectangle r = this.getColumnBounds(column);
        if (r != null) {
            this.syncedRedraw(r.x, r.y, r.width, r.height);
        }
    }

    private void syncedRedraw(final int x, final int y, final int width, final int height) {
        Runnable r = new Runnable(){

            public void run() {
                if (!JaretTable.this.isDisposed()) {
                    JaretTable.this.redraw(x, y, width, height, true);
                }
            }
        };
        Display.getCurrent().syncExec(r);
    }

    private void syncedRedraw() {
        Runnable r = new Runnable(){

            public void run() {
                if (!JaretTable.this.isDisposed()) {
                    JaretTable.this.redraw();
                }
            }
        };
        Display.getCurrent().syncExec(r);
    }

    protected void updateScrollBars() {
        this.updateYScrollBar();
        this.updateXScrollBar();
    }

    private void updateXScrollBar() {
        if (Display.getCurrent() != null) {
            Display.getCurrent().syncExec(new Runnable(){

                public void run() {
                    ScrollBar scroll = JaretTable.this.getHorizontalBar();
                    if (scroll != null) {
                        JaretTable.this._oldHorizontalScroll = -1;
                        scroll.setMinimum(0);
                        scroll.setMaximum(JaretTable.this.getTotalWidth() - JaretTable.this.getFixedColumnsWidth());
                        scroll.setThumb(JaretTable.this.getWidth() - JaretTable.this.getFixedColumnsWidth());
                        scroll.setIncrement(50);
                        scroll.setPageIncrement(JaretTable.this.getWidth());
                    }
                }
            });
        }
    }

    private void handleHorizontalScroll(SelectionEvent event) {
        int value = this.getHorizontalBar().getSelection() + this.getFixedColumnsWidth();
        int colIdx = this.getColIdxForAbsX(value);
        int offset = value - this.getAbsBeginXForColIdx(colIdx);
        int diff = this._oldHorizontalScroll - value;
        if (Math.abs(diff) > this._tableRect.width / 2 || this._oldHorizontalScroll == -1 || !this._optimizeScrolling) {
            this._firstColIdx = colIdx;
            this._firstColPixelOffset = offset;
            this.redraw();
        } else {
            if (diff > 0) {
                this.scroll(this._tableRect.x + diff, 0, this._tableRect.x, 0, this._tableRect.width - diff, this.getHeight(), false);
            } else {
                diff = -diff;
                this.scroll(this._tableRect.x, 0, this._tableRect.x + diff, 0, this._tableRect.width - diff, this.getHeight(), false);
            }
            this._firstColIdx = colIdx;
            this._firstColPixelOffset = offset;
        }
        this._oldHorizontalScroll = value;
    }

    public void updateYScrollBar() {
        if (Display.getCurrent() != null) {
            Display.getCurrent().syncExec(new Runnable(){

                public void run() {
                    ScrollBar scroll = JaretTable.this.getVerticalBar();
                    if (scroll != null) {
                        JaretTable.this._oldVerticalScroll = -1;
                        scroll.setMinimum(0);
                        scroll.setMaximum(JaretTable.this.getTotalHeight() - JaretTable.this.getFixedRowsHeight());
                        int height = JaretTable.this.getHeight();
                        if (JaretTable.this._tableRect != null) {
                            height = JaretTable.this._tableRect.height;
                        }
                        scroll.setThumb(height);
                        scroll.setIncrement(50);
                        scroll.setPageIncrement(JaretTable.this.getHeight());
                        scroll.setSelection(JaretTable.this.getAbsBeginYForRowIdx(JaretTable.this._firstRowIdx) + JaretTable.this._firstRowPixelOffset + JaretTable.this.getFixedRowsHeight());
                    }
                }
            });
        }
    }

    private void handleVerticalScroll(SelectionEvent event) {
        int value = this.getVerticalBar().getSelection() + this.getFixedRowsHeight();
        int rowidx = this.getRowIdxForAbsY(value);
        int offset = value - this.getAbsBeginYForRowIdx(rowidx);
        int oldFirstIdx = this._firstRowIdx;
        int oldPixelOffset = this._firstRowPixelOffset;
        int diff = this._oldVerticalScroll - value;
        if (Math.abs(diff) > this._tableRect.height / 2 || this._oldVerticalScroll == -1 || !this._optimizeScrolling) {
            this.update();
            this._firstRowIdx = rowidx;
            this._firstRowPixelOffset = offset;
            this._rowInfoCache = null;
            this.redraw();
        } else {
            Rectangle completeArea = new Rectangle(this._fixedColRect.x, this._tableRect.y, this._fixedColRect.width + this._tableRect.width, this._tableRect.height);
            if (diff > 0) {
                this.scroll(0, completeArea.y + diff, 0, completeArea.y, this.getWidth(), completeArea.height - diff, false);
            } else {
                diff = -diff;
                this.scroll(0, completeArea.y, 0, completeArea.y + diff, this.getWidth(), completeArea.height - diff, false);
            }
            this._firstRowIdx = rowidx;
            this._firstRowPixelOffset = offset;
            this._rowInfoCache = null;
        }
        this._oldVerticalScroll = value;
        this.firePropertyChange(PROPERTYNAME_FIRSTROWIDX, oldFirstIdx, this._firstRowIdx);
        this.firePropertyChange(PROPERTYNAME_FIRSTROWPIXELOFFSET, oldPixelOffset, this._firstRowPixelOffset);
    }

    public int getAbsBeginXForColIdx(int colIdx) {
        int x = 0;
        for (int idx = 0; idx < colIdx; ++idx) {
            IColumn col = this._cols.get(idx);
            int colWidth = this._tvs.getColumnWidth(col);
            x += colWidth;
        }
        return x;
    }

    public int getAbsBeginXForColumn(IColumn column) {
        return this.getAbsBeginXForColIdx(this._cols.indexOf(column));
    }

    private int xForCol(IColumn column) {
        int x = this.getAbsBeginXForColIdx(this._cols.indexOf(column));
        int begin = this.getAbsBeginXForColIdx(this._firstColIdx) + this._firstColPixelOffset;
        return x - begin + this._fixedColRect.width;
    }

    public int getColIdxForAbsX(int absX) {
        int colWidth;
        int idx = 0;
        for (int x = 0; x <= absX && idx < this._cols.size(); x += colWidth, ++idx) {
            IColumn col = this._cols.get(idx);
            colWidth = this._tvs.getColumnWidth(col);
        }
        return idx < this._cols.size() ? idx - 1 : -1;
    }

    public IColumn getColumnForAbsX(int absX) {
        return this._cols.get(this.getColIdxForAbsX(absX));
    }

    private int getAbsBeginYForRowIdx(int rowidx) {
        int y = 0;
        for (int idx = 0; idx < rowidx; ++idx) {
            IRow row = this._rows.get(idx);
            int rowHeight = this._tvs.getRowHeight(row);
            y += rowHeight;
        }
        return y;
    }

    public int getRowIdxForAbsY(int absY) {
        int idx = 0;
        int y = 0;
        while (y <= absY) {
            IRow row = this._rows.get(idx);
            int rowHeight = this._tvs.getRowHeight(row);
            y += rowHeight;
            ++idx;
        }
        return idx - 1;
    }

    private int getRowIdx(IRow row) {
        return row != null ? this._rows.indexOf(row) : -1;
    }

    public IRow rowForY(int y) {
        if ((y < this._tableRect.y || y > this._tableRect.y + this._tableRect.height) && this._fixedRows == 0) {
            return null;
        }
        for (RowInfo rInfo : this.getRowInfos()) {
            if (y < rInfo.y || y >= rInfo.y + rInfo.height) continue;
            return rInfo.row;
        }
        return null;
    }

    private List<RowInfo> getRowInfos() {
        if (this._rowInfoCache == null) {
            this.fillRowInfoCache();
        }
        return this._rowInfoCache;
    }

    private void fillRowInfoCache() {
        int rHeight;
        IRow row;
        int rIdx;
        if (this._rowInfoCache != null) {
            return;
        }
        this._rowInfoCache = new ArrayList<RowInfo>();
        int y = 0;
        if (this._fixedRows > 0) {
            y = this._fixedRowRect.y;
            for (rIdx = 0; rIdx < this._fixedRows; ++rIdx) {
                row = this._rows.get(rIdx);
                rHeight = this._tvs.getRowHeight(row);
                this._rowInfoCache.add(new RowInfo(row, y, rHeight, true));
                y += rHeight;
            }
        }
        rIdx = this._firstRowIdx;
        for (y = this._tableRect.y - this._firstRowPixelOffset; y < this.getHeight() && rIdx < this._rows.size(); y += rHeight, ++rIdx) {
            row = this._rows.get(rIdx);
            rHeight = this._tvs.getRowHeight(row);
            this._rowInfoCache.add(new RowInfo(row, y, rHeight, false));
        }
    }

    private IRow rowForIdx(int idx) {
        return this._rows.get(idx);
    }

    public IColumn colForX(int x) {
        if ((x < this._tableRect.x || x > this._tableRect.x + this._tableRect.width) && this._fixedColumns == 0) {
            return null;
        }
        for (ColInfo cInfo : this._colInfoCache) {
            if (x < cInfo.x || x >= cInfo.x + cInfo.width) continue;
            return cInfo.column;
        }
        return null;
    }

    private IColumn colForIdx(int idx) {
        return this._cols.get(idx);
    }

    private int getColumnIdx(IColumn column) {
        return column != null ? this._cols.indexOf(column) : -1;
    }

    public IJaretTableCell getCell(int x, int y) {
        if (this._tableRect.contains(x, y)) {
            IRow row = this.rowForY(y);
            IColumn col = this.colForX(x);
            if (row == null || col == null) {
                return null;
            }
            return new JaretTableCellImpl(row, col);
        }
        return null;
    }

    public IJaretTableCell getCellForIdx(int colIdx, int rowIdx) {
        return new JaretTableCellImpl(this.rowForIdx(rowIdx), this.colForIdx(colIdx));
    }

    public void setTableModel(IJaretTableModel model) {
        if (this._model != null) {
            this._model.removeJaretTableModelListener(this);
        }
        this._model = model;
        this._model.addJaretTableModelListener(this);
        this._hierarchicalModel = null;
        ArrayList<IColumn> cList = new ArrayList<IColumn>();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            cList.add(model.getColumn(i));
        }
        this._tvs.setSortedColumns(cList);
        this.updateColumnList();
        this.registerRowsForOptimization();
        this.updateRowList();
        this.updateYScrollBar();
        this.updateXScrollBar();
        this.redraw();
    }

    public void setTableModel(IHierarchicalJaretTableModel hmodel) {
        if (this._model != null) {
            this._model.removeJaretTableModelListener(this);
        }
        if (this._tvs != null) {
            this._tvs.removeTableViewStateListener(this);
        }
        this._tvs = new DefaultHierarchicalTableViewState();
        this._tvs.addTableViewStateListener(this);
        this._model = new StdHierarchicalTableModel(hmodel, (IHierarchicalTableViewState)this._tvs);
        this._model.addJaretTableModelListener(this);
        this._hierarchicalModel = hmodel;
        this.updateColumnList();
        this.registerRowsForOptimization();
        this.updateRowList();
        this.updateColumnList();
        this.updateYScrollBar();
        this.updateXScrollBar();
        this.redraw();
    }

    public IHierarchicalJaretTableModel getHierarchicalModel() {
        return this._hierarchicalModel;
    }

    public IJaretTableModel getTableModel() {
        return this._model;
    }

    public void addColumn(IColumn column) {
        if (this._model == null) {
            throw new IllegalStateException("model has to be set for the operation.");
        }
        this._model.addColumn(column);
    }

    private void registerRowsForOptimization() {
        if (this._model != null) {
            for (int i = 0; i < this._model.getRowCount(); ++i) {
                IRow row = this._model.getRow(i);
                if (this._tvs.getRowHeigthMode(row) != ITableViewState.RowHeightMode.OPTANDVAR && this._tvs.getRowHeigthMode(row) != ITableViewState.RowHeightMode.OPTIMAL) continue;
                this.optimizeHeight(row);
            }
        }
    }

    private void updateRowList() {
        this._rows = new ArrayList<IRow>();
        if (this._model != null) {
            for (int i = 0; i < this._model.getRowCount(); ++i) {
                IRow row = this._model.getRow(i);
                if (i < this._fixedRows) {
                    this._rows.add(row);
                    continue;
                }
                if (this._rowFilter != null && (this._rowFilter == null || !this._rowFilter.isInResult(row)) || this._autoFilterEnabled && !this._autoFilter.isInResult(row) || this._rows.contains(row)) continue;
                this._rows.add(row);
            }
        }
        RowComparator comparator = new RowComparator();
        IRowSorter rs = null;
        rs = comparator.canSort() ? comparator : this._rowSorter;
        if (rs != null) {
            int i;
            ArrayList<IRow> fixedRows = new ArrayList<IRow>();
            if (this._excludeFixedRowsFromSorting) {
                for (i = 0; i < this._fixedRows; ++i) {
                    fixedRows.add(this._rows.remove(0));
                }
            }
            Collections.sort(this._rows, rs);
            if (this._excludeFixedRowsFromSorting) {
                for (i = fixedRows.size() - 1; i >= 0; --i) {
                    this._rows.add(0, (IRow)fixedRows.get(i));
                }
            }
        }
        this.updateYScrollBar();
    }

    public int getInternalRowIndex(IRow row) {
        return this._rows.indexOf(row);
    }

    public void updateColumnList() {
        IColumn col;
        int i;
        this._cols = new ArrayList<IColumn>();
        for (i = 0; i < this._model.getColumnCount(); ++i) {
            if (i >= this._tvs.getSortedColumns().size() || !this._tvs.getColumnVisible(col = this._tvs.getSortedColumns().get(i))) continue;
            this._cols.add(col);
        }
        for (i = 0; i < this._model.getColumnCount(); ++i) {
            col = this._model.getColumn(i);
            if (this._cols.contains(col) || !this._tvs.getColumnVisible(col)) continue;
            this._cols.add(col);
        }
    }

    private void onPaint(PaintEvent event) {
        if (event.width == 0 || event.height == 0) {
            return;
        }
        long time = System.currentTimeMillis();
        this._rowInfoCache = null;
        GC gc = event.gc;
        this.doRowHeightOptimization(gc);
        this.paint(gc, this.getWidth(), this.getHeight());
    }

    private void preparePaint(int width, int height) {
        this._headerRect = this._drawHeader ? new Rectangle(0, 0, width, this._headerHeight) : new Rectangle(0, 0, 0, 0);
        if (this._autoFilterEnabled) {
            int autoFilterHeight = this.getPreferredAutoFilterHeight();
            this._autoFilterRect = new Rectangle(0, this._headerRect.y + this._headerRect.height, this._headerRect.width, autoFilterHeight);
            this._tableRect = new Rectangle(0, this._autoFilterRect.y + this._autoFilterRect.height, width, height - this._autoFilterRect.height);
        } else {
            this._tableRect = new Rectangle(0, this._headerRect.y + this._headerRect.height, width, height - this._headerRect.height);
        }
        if (this._fixedColumns > 0) {
            int fWidth = this.getFixedColumnsWidth();
            this._headerRect.x += fWidth;
            this._headerRect.width -= fWidth;
            if (this._autoFilterEnabled) {
                this._autoFilterRect.x = this._headerRect.x;
                this._autoFilterRect.width = this._headerRect.width;
            }
            this._tableRect.x = this._headerRect.x;
            this._tableRect.width = this._headerRect.width;
            this._fixedColRect = new Rectangle(0, this._tableRect.y, fWidth, this._tableRect.height);
        } else {
            this._fixedColRect = new Rectangle(this._tableRect.x, this._tableRect.y, 0, this._tableRect.height);
        }
        if (this._fixedRows > 0) {
            int fHeight = this.getFixedRowsHeight();
            this._fixedRowRect = this._autoFilterEnabled ? new Rectangle(0, this._autoFilterRect.y + this._autoFilterRect.height, width, this.getFixedRowsHeight()) : new Rectangle(0, this._headerRect.y + this._headerRect.height, width, this.getFixedRowsHeight());
            this._tableRect.y += fHeight;
            this._tableRect.height -= fHeight;
            if (this._fixedColumns > 0) {
                this._fixedColRect.y = this._tableRect.y;
                this._fixedColRect.height = this._tableRect.height;
            }
        } else {
            this._fixedRowRect = new Rectangle(this._tableRect.x, this._tableRect.y, this._tableRect.width, 0);
        }
    }

    private int getPreferredAutoFilterHeight() {
        int result = 0;
        for (IAutoFilter af : this._autoFilterMap.values()) {
            int height = af.getControl().computeSize((int)-1, (int)-1).y;
            if (height <= result) continue;
            result = height;
        }
        return result;
    }

    public void paint(GC gc, int width, int height) {
        this.preparePaint(width, height);
        Color bg = gc.getBackground();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(gc.getClipping());
        gc.setBackground(bg);
        this.drawHeader(gc, width, height);
        this.drawTableArea(gc, width, height);
        this.setUpAutoFilter(gc);
        if (this._isFillDrag) {
            this.drawFillDragBorder(gc);
        }
    }

    private void setUpAutoFilter(GC gc) {
        if (this._autoFilterEnabled) {
            for (IColumn column : this._cols) {
                IAutoFilter af = this._autoFilterMap.get(column);
                ColInfo cInfo = this.getColInfo(column);
                if (af != null && cInfo == null) {
                    af.getControl().setVisible(false);
                    continue;
                }
                if (af == null) continue;
                af.getControl().setVisible(true);
                af.getControl().setBounds(cInfo.x, this._autoFilterRect.y, cInfo.width, this._autoFilterRect.height);
            }
        } else {
            for (IColumn column : this._cols) {
                IAutoFilter af = this._autoFilterMap.get(column);
                if (af == null) continue;
                af.getControl().setVisible(false);
            }
        }
    }

    private void drawHeader(GC gc, int width, int height) {
        if (this._headerRenderer != null && this._drawHeader) {
            int colwidth;
            IColumn col;
            for (int cIdx = 0; cIdx < this._fixedColumns; ++cIdx) {
                int x = this.getAbsBeginXForColIdx(cIdx);
                col = this._cols.get(cIdx);
                colwidth = this._tvs.getColumnWidth(col);
                if (!this._headerRenderer.disableClipping()) {
                    gc.setClipping(x, this._headerRect.y, colwidth, this._headerRect.height);
                }
                if (!col.displayHeader()) continue;
                this.drawHeader(gc, x, colwidth, col);
            }
            int x = -this._firstColPixelOffset;
            x += this._tableRect.x;
            for (int cIdx = this._firstColIdx; x < this.getWidth() && cIdx < this._cols.size(); x += colwidth, ++cIdx) {
                int clipWidth;
                col = this._cols.get(cIdx);
                colwidth = this._tvs.getColumnWidth(col);
                int xx = x > this._headerRect.x ? x : this._headerRect.x;
                int n = clipWidth = x > this._headerRect.x ? colwidth : colwidth - this._firstColPixelOffset;
                if (!this._headerRenderer.disableClipping()) {
                    gc.setClipping(xx, this._headerRect.y, clipWidth, this._headerRect.height);
                } else if (this._fixedColumns > 0) {
                    gc.setClipping(xx, this._headerRect.y, this._tableRect.width - xx, this._headerRect.height);
                }
                if (!col.displayHeader()) continue;
                this.drawHeader(gc, x, colwidth, col);
            }
        }
    }

    private void drawHeader(GC gc, int x, int colwidth, IColumn col) {
        Rectangle area = new Rectangle(x, this._headerRect.y, colwidth, this._headerRect.height);
        int sortingPos = this._tvs.getColumnSortingPosition(col);
        boolean sortingDir = this._tvs.getColumnSortingDirection(col);
        this._headerRenderer.draw(gc, area, col, sortingPos, sortingDir, false);
    }

    public boolean isSelected(IRow row, IColumn column) {
        if (this._selectionModel.getSelection().getSelectedRows().contains(row)) {
            return true;
        }
        if (this._selectionModel.getSelection().getSelectedColumns().contains(column)) {
            return true;
        }
        JaretTableCellImpl cell = new JaretTableCellImpl(row, column);
        return this._selectionModel.getSelection().getSelectedCells().contains(cell);
    }

    private void drawTableArea(GC gc, int width, int height) {
        this._colInfoCache.clear();
        boolean colCacheFilled = false;
        Rectangle clipSave = gc.getClipping();
        for (RowInfo rowInfo : this.getRowInfos()) {
            int colwidth;
            IColumn col;
            int cIdx;
            int y = rowInfo.y;
            IRow row = rowInfo.row;
            int rHeight = this._tvs.getRowHeight(row);
            int yclip = y;
            if (rowInfo.fixed && yclip < this._fixedRowRect.y) {
                yclip = this._fixedRowRect.y;
            } else if (!rowInfo.fixed && yclip < this._tableRect.y) {
                yclip = this._tableRect.y;
            }
            int x = 0;
            if (this._fixedColumns > 0) {
                x = this._fixedColRect.x;
                for (cIdx = 0; cIdx < this._fixedColumns; ++cIdx) {
                    col = this._cols.get(cIdx);
                    colwidth = this._tvs.getColumnWidth(col);
                    if (!colCacheFilled) {
                        this._colInfoCache.add(new ColInfo(col, x, colwidth));
                    }
                    gc.setClipping(x, yclip, colwidth + 1, rHeight + 1);
                    Rectangle area = new Rectangle(x, y, colwidth, rHeight);
                    this.drawCell(gc, area, row, col);
                    x += colwidth;
                }
            }
            x = this._tableRect.x - this._firstColPixelOffset;
            for (cIdx = this._firstColIdx; x < this.getWidth() && cIdx < this._cols.size(); x += colwidth, ++cIdx) {
                col = this._cols.get(cIdx);
                colwidth = this._tvs.getColumnWidth(col);
                if (!colCacheFilled) {
                    this._colInfoCache.add(new ColInfo(col, x, colwidth));
                }
                int xx = x > this._tableRect.x ? x : this._tableRect.x;
                int clipWidth = x > this._tableRect.x ? colwidth : colwidth - this._firstColPixelOffset;
                gc.setClipping(xx, yclip, clipWidth + 1, rHeight + 1);
                Rectangle area = new Rectangle(x, y, colwidth, rHeight);
                this.drawCell(gc, area, row, col);
            }
            colCacheFilled = true;
        }
        if (!colCacheFilled) {
            int colwidth;
            int x = 0;
            if (this._fixedColumns > 0) {
                for (int i = 0; i < this._fixedColumns; ++i) {
                    IColumn col = this._cols.get(i);
                    int colwidth2 = this._tvs.getColumnWidth(col);
                    this._colInfoCache.add(new ColInfo(col, x, colwidth2));
                    x += colwidth2;
                }
            }
            x = -this._firstColPixelOffset;
            x += this._tableRect.x;
            for (int cIdx = this._firstColIdx; x < this.getWidth() && cIdx < this._cols.size(); x += colwidth, ++cIdx) {
                IColumn col = this._cols.get(cIdx);
                colwidth = this._tvs.getColumnWidth(col);
                this._colInfoCache.add(new ColInfo(col, x, colwidth));
            }
        }
        if (this._fixedColRect != null && this._fixedColumns > 0) {
            IRow lastRow;
            Rectangle bounds;
            int maxY = this._fixedColRect.y + this._fixedColRect.height - 1;
            if (this._rows != null && this._rows.size() > 0 && (bounds = this.getRowBounds(lastRow = this._rows.get(this._rows.size() - 1))) != null) {
                maxY = bounds.y + bounds.height;
            }
            gc.setClipping(new Rectangle(0, 0, width, height));
            int fx = this._fixedColRect.x + this._fixedColRect.width - 1;
            gc.drawLine(fx, this._fixedRowRect.y, fx, maxY);
            gc.setClipping(clipSave);
        }
        if (this._fixedRowRect != null && this._fixedRows > 0) {
            int maxX = this._fixedRowRect.x + this._fixedRowRect.width - 1;
            if (this._cols != null && this._cols.size() > 0) {
                int mx;
                IColumn lastCol = this._cols.get(this._cols.size() - 1);
                maxX = mx = this.xForCol(lastCol) + this._tvs.getColumnWidth(lastCol);
            }
            gc.setClipping(new Rectangle(0, 0, width, height));
            int fy = this._fixedRowRect.y + this._fixedRowRect.height - 1;
            gc.drawLine(this._fixedRowRect.x, fy, maxX, fy);
            gc.setClipping(clipSave);
        }
    }

    private void drawCell(GC gc, Rectangle area, IRow row, IColumn col) {
        ICellStyle bc = this._tvs.getCellStyle(row, col);
        ICellRenderer cellRenderer = this.getCellRenderer(row, col);
        boolean hasFocus = false;
        if (this._focussedRow == row && this._focussedColumn == col) {
            hasFocus = true;
        }
        boolean isSelected = this.isSelected(row, col);
        cellRenderer.draw(gc, this, bc, area, row, col, hasFocus, isSelected, false);
        if (this._supportFillDragging && isSelected && this.isDragMarkerCell(row, col)) {
            this.drawFillDragMark(gc, area);
        }
    }

    private Rectangle getSelectedRectangle() {
        IJaretTableSelection selection = this.getSelectionModel().getSelection();
        if (!selection.isEmpty() && this._selectedIdxRectangle == null) {
            Set<IJaretTableCell> cells = selection.getAllSelectedCells(this.getTableModel());
            int minx = -1;
            int maxx = -1;
            int miny = -1;
            int maxy = -1;
            HashMap cellMap = new HashMap();
            for (IJaretTableCell cell : cells) {
                Point p = this.getCellDisplayIdx(cell);
                HashMap<Integer, IJaretTableCell> lineMap = (HashMap<Integer, IJaretTableCell>)cellMap.get(p.y);
                if (lineMap == null) {
                    lineMap = new HashMap<Integer, IJaretTableCell>();
                    cellMap.put(p.y, lineMap);
                }
                if (miny == -1 || p.y < miny) {
                    miny = p.y;
                }
                if (maxy == -1 || p.y > maxy) {
                    maxy = p.y;
                }
                lineMap.put(p.x, cell);
                if (minx == -1 || p.x < minx) {
                    minx = p.x;
                }
                if (maxx != -1 && p.x <= maxx) continue;
                maxx = p.x;
            }
            boolean everythingSelected = true;
            block1: for (int y = miny; y <= maxy && everythingSelected; ++y) {
                Map lineMap = (Map)cellMap.get(y);
                if (lineMap != null) {
                    for (int x = minx; x <= maxx; ++x) {
                        IJaretTableCell cell = (IJaretTableCell)lineMap.get(x);
                        if (cell != null) continue;
                        everythingSelected = false;
                        continue block1;
                    }
                    continue;
                }
                everythingSelected = false;
                break;
            }
            this._selectedIdxRectangle = everythingSelected ? new Rectangle(minx, miny, maxx - minx + 1, maxy - miny + 1) : null;
        }
        return this._selectedIdxRectangle;
    }

    private boolean isDragMarkerCell(IRow row, IColumn col) {
        Rectangle selIdxRect = this.getSelectedRectangle();
        if (selIdxRect != null && (selIdxRect.width == 1 || selIdxRect.height == 1)) {
            int x = this.getColumnIdx(col);
            int y = this.getRowIdx(row);
            if (x == selIdxRect.x + selIdxRect.width - 1 && y == selIdxRect.y + selIdxRect.height - 1) {
                return true;
            }
        }
        return false;
    }

    private void drawFillDragMark(GC gc, Rectangle area) {
        Color bg = gc.getBackground();
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        this._dragMarkerRect = new Rectangle(area.x + area.width - 4, area.y + area.height - 4, 4, 4);
        gc.fillRectangle(this._dragMarkerRect);
        gc.setBackground(bg);
    }

    private void drawFillDragBorder(GC gc) {
    }

    public void setHeaderHeight(int newHeight) {
        if (newHeight != this._headerHeight) {
            int oldVal = this._headerHeight;
            this._headerHeight = newHeight;
            this.redraw();
            this.firePropertyChange(PROPERTYNAME_HEADERHEIGHT, oldVal, this._headerHeight);
        }
    }

    public int getHeaderHeight() {
        return this._headerHeight;
    }

    public int getTotalHeight() {
        if (this._rows != null) {
            int h = 0;
            for (IRow row : this._rows) {
                h += this._tvs.getRowHeight(row);
            }
            return h;
        }
        return 0;
    }

    public int getTotalHeight(int numRows) {
        if (this._rows != null) {
            int h = 0;
            for (int i = 0; i < numRows; ++i) {
                IRow row = this._rows.get(i);
                h += this._tvs.getRowHeight(row);
            }
            return h;
        }
        return 0;
    }

    public int getTotalWidth() {
        if (this._cols != null) {
            int width = 0;
            for (IColumn col : this._cols) {
                width += this._tvs.getColumnWidth(col);
            }
            return width;
        }
        return 0;
    }

    public int getTotalWidth(int n) {
        if (this._cols != null) {
            int width = 0;
            for (int i = 0; i < n; ++i) {
                IColumn col = this._cols.get(i);
                width += this._tvs.getColumnWidth(col);
            }
            return width;
        }
        return 0;
    }

    private int getFixedColumnsWidth() {
        int w = 0;
        for (int i = 0; i < this._fixedColumns; ++i) {
            w += this._tvs.getColumnWidth(this._cols.get(i));
        }
        return w;
    }

    private int getFixedRowsHeight() {
        int h = 0;
        for (int i = 0; i < this._fixedRows; ++i) {
            h += this._tvs.getRowHeight(this._rows.get(i));
        }
        return h;
    }

    public int getWidth() {
        return this.getClientArea().width;
    }

    public int getHeight() {
        return this.getClientArea().height;
    }

    public ITableViewState getTableViewState() {
        return this._tvs;
    }

    public void setTableViewState(ITableViewState tvs) {
        if (this._tvs != null) {
            this._tvs.removeTableViewStateListener(this);
        }
        this._tvs = tvs;
        this._tvs.addTableViewStateListener(this);
    }

    @Override
    public void rowHeightChanged(IRow row, int newHeight) {
        Rectangle r = this.getRowBounds(row);
        if (r != null) {
            int height = this.getHeight() - r.y;
            this.redraw(r.x, r.y, r.width, height, true);
            this._rowInfoCache = null;
        }
        this.updateYScrollBar();
    }

    @Override
    public void rowHeightModeChanged(IRow row, ITableViewState.RowHeightMode newHeightMode) {
        if (this.isDisplayed(row)) {
            if (newHeightMode == ITableViewState.RowHeightMode.OPTANDVAR || newHeightMode == ITableViewState.RowHeightMode.OPTIMAL) {
                this.optimizeHeight(row);
            }
            this.redraw();
        }
        if (newHeightMode != ITableViewState.RowHeightMode.OPTANDVAR && newHeightMode != ITableViewState.RowHeightMode.OPTIMAL) {
            this.doNotOptimizeHeight(row);
        }
    }

    @Override
    public void columnWidthChanged(IColumn column, int newWidth) {
        this.registerRowsForOptimization();
        Rectangle r = this.getColumnBounds(column);
        if (this._headerRect != null) {
            int height;
            int y = this._drawHeader ? this._headerRect.y : r.y;
            int width = this.getWidth() - r.x;
            int n = height = this._drawHeader ? this._headerRect.height + r.height : r.height;
            if (this._autoFilterEnabled) {
                height += this._autoFilterRect.height;
            }
            this.redraw(r.x, y, width, height, true);
        }
        this.updateXScrollBar();
    }

    @Override
    public void columnWidthsChanged() {
        this.registerRowsForOptimization();
        this.redraw();
        this.updateXScrollBar();
    }

    @Override
    public void columnVisibilityChanged(IColumn column, boolean visible) {
        this.updateColumnList();
        this.updateXScrollBar();
        this.redraw();
    }

    @Override
    public void sortingChanged() {
        this.updateRowList();
        this.redraw();
        this.firePropertyChange(PROPERTYNAME_SORTING, null, "x");
    }

    @Override
    public void columnOrderChanged() {
        this.updateColumnList();
        this.redraw();
    }

    @Override
    public void cellStyleChanged(IRow row, IColumn column, ICellStyle style) {
        if (column == null) {
            this.redraw(row);
        } else if (row == null) {
            this.redraw(column);
        } else {
            this.redraw(row, column);
        }
    }

    public void setAutoFilterEnable(boolean enable) {
        if (this._autoFilterEnabled != enable) {
            this._autoFilterEnabled = enable;
            if (enable) {
                this.updateAutoFilter();
            }
            this.redraw();
            this.updateYScrollBar();
            this.preparePaint(this.getWidth(), this.getHeight());
            this.firePropertyChange(PROPERTYNAME_AUTOFILTERENABLE, !enable, enable);
        }
    }

    public boolean getAutoFilterEnable() {
        return this._autoFilterEnabled;
    }

    private void updateAutoFilter() {
        if (this._autoFilterEnabled) {
            IAutoFilter af;
            if (this._autoFilter == null) {
                this._autoFilter = new AutoFilter(this);
            }
            for (IColumn column : this._cols) {
                if (this._autoFilterMap.get(column) != null || (af = this.createAutoFilter(column)) == null) continue;
                af.addPropertyChangeListener(this._autoFilter);
                this._autoFilterMap.put(column, af);
            }
            for (IColumn column : this._cols) {
                af = this._autoFilterMap.get(column);
                if (af == null) continue;
                af.update();
            }
        }
    }

    private IAutoFilter createAutoFilter(IColumn column) {
        Class<? extends IAutoFilter> clazz = this.getAutoFilterClass(column);
        if (clazz == null) {
            return null;
        }
        IAutoFilter result = null;
        try {
            Constructor<? extends IAutoFilter> constructor = clazz.getConstructor(new Class[0]);
            result = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        result.setTable(this);
        result.setColumn(column);
        return result;
    }

    public boolean getDrawHeader() {
        return this._drawHeader;
    }

    public void setDrawHeader(boolean drawHeader) {
        if (this._drawHeader != drawHeader) {
            this._drawHeader = drawHeader;
            this.redraw();
        }
    }

    public ITableHeaderRenderer getHeaderRenderer() {
        return this._headerRenderer;
    }

    public void setHeaderRenderer(ITableHeaderRenderer headerRenderer) {
        this._headerRenderer = headerRenderer;
        this.redraw();
    }

    public boolean isColumnResizeAllowed() {
        return this._columnResizeAllowed;
    }

    public void setColumnResizeAllowed(boolean columnResizeAllowed) {
        this._columnResizeAllowed = columnResizeAllowed;
    }

    public boolean isHeaderResizeAllowed() {
        return this._headerResizeAllowed;
    }

    public void setHeaderResizeAllowed(boolean headerResizeAllowed) {
        this._headerResizeAllowed = headerResizeAllowed;
    }

    public boolean isRowResizeAllowed() {
        return this._rowResizeAllowed;
    }

    public void setRowResizeAllowed(boolean rowResizeAllowed) {
        this._rowResizeAllowed = rowResizeAllowed;
    }

    public void setFirstRow(int idx, int pixeloffset) {
        if (this._firstRowIdx != idx || this._firstRowPixelOffset != pixeloffset) {
            int oldFirstIdx = this._firstRowIdx;
            int oldPixelOffset = this._firstRowPixelOffset;
            this._firstRowIdx = idx;
            this._firstRowPixelOffset = pixeloffset;
            this._rowInfoCache = null;
            this.updateYScrollBar();
            this.redraw();
            this.firePropertyChange(PROPERTYNAME_FIRSTROWIDX, oldFirstIdx, idx);
            this.firePropertyChange(PROPERTYNAME_FIRSTROWPIXELOFFSET, oldPixelOffset, pixeloffset);
        }
    }

    public void displayHeaderContextMenu(int x, int y) {
        if (this._headerContextMenu != null) {
            this.dispContextMenu(this._headerContextMenu, x, y);
        }
    }

    public void displayRowContextMenu(int x, int y) {
        if (this._rowContextMenu != null) {
            this.dispContextMenu(this._rowContextMenu, x, y);
        }
    }

    private void dispContextMenu(Menu contextMenu, int x, int y) {
        Shell shell = Display.getCurrent().getActiveShell();
        Point coords = Display.getCurrent().map((Control)this, (Control)shell, x, y);
        contextMenu.setLocation(coords.x + shell.getLocation().x, coords.y + shell.getLocation().y);
        contextMenu.setVisible(true);
    }

    public void setHeaderContextMenu(Menu headerCtxMenu) {
        this._headerContextMenu = headerCtxMenu;
    }

    public Menu getHeaderContextMenu() {
        return this._headerContextMenu;
    }

    public void setRowContextMenu(Menu rowCtxMenu) {
        this._rowContextMenu = rowCtxMenu;
    }

    public Menu getRowContextMenu() {
        return this._rowContextMenu;
    }

    public int getFixedColumns() {
        return this._fixedColumns;
    }

    public void setFixedColumns(int fixedColumns) {
        if (this._fixedColumns != fixedColumns) {
            this._fixedColumns = fixedColumns;
            this._firstColIdx = fixedColumns;
            this._firstColPixelOffset = 0;
            this.redraw();
        }
    }

    public int getFixedRows() {
        return this._fixedRows;
    }

    public void setFixedRows(int fixedRows) {
        if (this._fixedRows != fixedRows) {
            this._fixedRows = fixedRows;
            this._firstRowIdx = fixedRows;
            this._firstRowPixelOffset = 0;
            this._rowInfoCache = null;
            this.redraw();
        }
    }

    @Override
    public void rowChanged(IRow row) {
        if (this._tvs.getRowHeigthMode(row) == ITableViewState.RowHeightMode.OPTIMAL || this._tvs.getRowHeigthMode(row) == ITableViewState.RowHeightMode.OPTANDVAR) {
            this.optimizeHeight(row);
        }
        this.redraw(row);
    }

    @Override
    public void rowRemoved(IRow row) {
        this.updateRowList();
        if (this.isDisplayed(row)) {
            this.syncedRedraw();
        }
        this.updateYScrollBar();
    }

    @Override
    public void rowAdded(int idx, IRow row) {
        this.updateRowList();
        this.syncedRedraw();
        this.updateYScrollBar();
    }

    @Override
    public void columnAdded(int idx, IColumn column) {
        this._tvs.getSortedColumns().add(column);
        this.updateColumnList();
        this.syncedRedraw();
        this.updateXScrollBar();
    }

    @Override
    public void columnRemoved(IColumn column) {
        this._tvs.getSortedColumns().remove(column);
        this.updateColumnList();
        if (this.isDisplayed(column)) {
            this.syncedRedraw();
        }
        this.updateXScrollBar();
    }

    @Override
    public void columnChanged(IColumn column) {
        this.redraw(column);
    }

    @Override
    public void cellChanged(IRow row, IColumn column) {
        this.redraw(row, column);
    }

    @Override
    public void tableDataChanged() {
        this.updateRowList();
        this.syncedRedraw();
    }

    public boolean getExcludeFixedRowsFromSorting() {
        return this._excludeFixedRowsFromSorting;
    }

    public void setExcludeFixedRowsFromSorting(boolean excludeFixedRowsFromSorting) {
        this._excludeFixedRowsFromSorting = excludeFixedRowsFromSorting;
    }

    public boolean getResizeRestriction() {
        return this._resizeRestriction;
    }

    public void setResizeRestriction(boolean resizeRestriction) {
        this._resizeRestriction = resizeRestriction;
    }

    @Override
    public void rowSelectionAdded(IRow row) {
        this._selectedIdxRectangle = null;
        this.redraw(row);
    }

    @Override
    public void rowSelectionRemoved(IRow row) {
        this._selectedIdxRectangle = null;
        this.redraw(row);
    }

    @Override
    public void cellSelectionAdded(IJaretTableCell cell) {
        this._selectedIdxRectangle = null;
        this.redraw(cell.getRow(), cell.getColumn());
    }

    @Override
    public void cellSelectionRemoved(IJaretTableCell cell) {
        this._selectedIdxRectangle = null;
        this.redraw(cell.getRow(), cell.getColumn());
    }

    @Override
    public void columnSelectionAdded(IColumn column) {
        this._selectedIdxRectangle = null;
        this.redraw(column);
    }

    @Override
    public void columnSelectionRemoved(IColumn column) {
        this._selectedIdxRectangle = null;
        this.redraw(column);
    }

    public IJaretTableSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void setSelectionModel(IJaretTableSelectionModel jts) {
        if (this._selectionModel != null) {
            this._selectionModel.removeTableSelectionModelListener(this);
        }
        this._selectionModel = jts;
        this._selectionModel.addTableSelectionModelListener(this);
    }

    public int getColumnCount() {
        return this._cols.size();
    }

    public IColumn getColumn(int idx) {
        return this._cols.get(idx);
    }

    public IColumn getColumn(String id) {
        for (int i = 0; i < this._model.getColumnCount(); ++i) {
            if (!this._model.getColumn(i).getId().equals(id)) continue;
            return this._model.getColumn(i);
        }
        return null;
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public IRow getRow(int idx) {
        return this._rows.get(idx);
    }

    public IRowFilter getRowFilter() {
        return this._rowFilter;
    }

    public void setRowFilter(IRowFilter rowFilter) {
        IRowFilter oldVal = this._rowFilter;
        if (this._rowFilter != null) {
            this._rowFilter.removePropertyChangeListener(this);
        }
        this._rowFilter = rowFilter;
        if (this._rowFilter != null) {
            this._rowFilter.addPropertyChangeListener(this);
        }
        this.updateRowList();
        this.updateAutoFilter();
        this.redraw();
        this.firePropertyChange(PROPERTYNAME_ROWFILTER, oldVal, this._rowFilter);
        this.firePropertyChange(PROPERTYNAME_FILTERING, null, "x");
    }

    public IRowSorter getRowSorter() {
        return this._rowSorter;
    }

    public void setRowSorter(IRowSorter rowSorter) {
        IRowSorter oldValue = this._rowSorter;
        if (this._rowSorter != null) {
            this._rowSorter.removePropertyChangeListener(this);
        }
        this._rowSorter = rowSorter;
        if (this._rowSorter != null) {
            this._rowSorter.addPropertyChangeListener(this);
        }
        this.updateRowList();
        this.redraw();
        this.firePropertyChange(PROPERTYNAME_ROWSORTER, oldValue, this._rowSorter);
        this.firePropertyChange(PROPERTYNAME_SORTING, null, "x");
    }

    public synchronized void addTableFocusListener(ITableFocusListener tfl) {
        if (this._tableFocusListeners == null) {
            this._tableFocusListeners = new Vector<ITableFocusListener>();
        }
        this._tableFocusListeners.add(tfl);
    }

    public synchronized void remTableFocusListener(ITableFocusListener tfl) {
        if (this._tableFocusListeners != null) {
            this._tableFocusListeners.remove(tfl);
        }
    }

    private void fireTableFocusChanged(IRow row, IColumn column) {
        if (this._tableFocusListeners != null) {
            for (ITableFocusListener listener : this._tableFocusListeners) {
                listener.tableFocusChanged(this, row, column);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this._rowSorter)) {
            this.updateRowList();
            this.updateAutoFilter();
            this.redraw();
            this.firePropertyChange(PROPERTYNAME_SORTING, null, "x");
        } else if (evt.getSource().equals(this._rowFilter)) {
            this.updateRowList();
            this.updateAutoFilter();
            this.redraw();
            this.firePropertyChange(PROPERTYNAME_FILTERING, null, "x");
        }
    }

    public IFillDragStrategy getFillDragStrategy() {
        return this._fillDragStrategy;
    }

    public void setFillDragStrategy(IFillDragStrategy fillDragStrategy) {
        if (fillDragStrategy == null) {
            throw new IllegalArgumentException("FillDragStrategy must not be NULL");
        }
        this._fillDragStrategy = fillDragStrategy;
    }

    public boolean isSupportFillDragging() {
        return this._supportFillDragging;
    }

    public void setSupportFillDragging(boolean supportFillDragging) {
        this._supportFillDragging = supportFillDragging;
        this._dragMarkerRect = null;
        this.redraw();
    }

    public ICCPStrategy getCcpStrategy() {
        return this._ccpStrategy;
    }

    public void setCcpStrategy(ICCPStrategy ccpStrategy) {
        this._ccpStrategy = ccpStrategy;
    }

    public void cut() {
        if (this._ccpStrategy != null) {
            this._ccpStrategy.cut(this);
        }
    }

    public void copy() {
        if (this._ccpStrategy != null) {
            this._ccpStrategy.copy(this);
        }
    }

    public void paste() {
        if (this._ccpStrategy != null) {
            this._ccpStrategy.paste(this);
        }
    }

    public void selectAll() {
        this.getSelectionModel().clearSelection();
        for (IColumn col : this._cols) {
            this.getSelectionModel().addSelectedColumn(col);
        }
    }

    public boolean getOptimizeScrolling() {
        return this._optimizeScrolling;
    }

    public void setOptimizeScrolling(boolean optimizeScrolling) {
        this._optimizeScrolling = optimizeScrolling;
    }

    public int getAutoFilterHeight() {
        return this._autoFilterEnabled ? this._autoFilterRect.height : 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldVal, Object newVal) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(propName, oldVal, newVal);
        }
    }

    public int getFirstRowPixelOffset() {
        return this._firstRowPixelOffset;
    }

    public int getFirstRowIdx() {
        return this._firstRowIdx;
    }

    public boolean getAllowSorting() {
        return this._allowSorting;
    }

    public void setAllowSorting(boolean allowSorting) {
        this._allowSorting = allowSorting;
    }

    public List<IRow> getInternalRowList() {
        return this._rows;
    }

    private class AutoFilter
    extends PropertyObservableBase
    implements IRowFilter,
    PropertyChangeListener {
        private JaretTable _table;

        public AutoFilter(JaretTable table) {
            this._table = table;
        }

        public boolean isInResult(IRow row) {
            boolean result = true;
            for (IColumn column : JaretTable.this._cols) {
                IAutoFilter af = JaretTable.this._autoFilterMap.get(column);
                if (af != null) {
                    boolean bl = result = result && af.isInResult(row);
                }
                if (result) continue;
                break;
            }
            return result;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JaretTable.this.updateRowList();
            JaretTable.this.setFirstRow(JaretTable.this._fixedRows, 0);
            JaretTable.this.redraw();
            this._table.firePropertyChange(JaretTable.PROPERTYNAME_FILTERING, null, "x");
        }
    }

    public class RowComparator
    extends PropertyObservableBase
    implements IRowSorter {
        private List<Comparator<IRow>> _comparators = new ArrayList<Comparator<IRow>>();

        public RowComparator() {
            IColumn[] arr = new IColumn[JaretTable.this._cols.size()];
            int max = 0;
            for (IColumn col : JaretTable.this._cols) {
                int sortP = JaretTable.this._tvs.getColumnSortingPosition(col);
                if (sortP <= 0) continue;
                arr[sortP] = col;
                if (sortP <= max) continue;
                max = sortP;
            }
            for (int i = 1; i <= max; ++i) {
                this._comparators.add(arr[i]);
            }
        }

        public boolean canSort() {
            return this._comparators.size() > 0;
        }

        public int compare(IRow r1, IRow r2) {
            for (Comparator<IRow> comp : this._comparators) {
                int res = comp.compare(r1, r2);
                res = JaretTable.this._tvs.getColumnSortingDirection((IColumn)comp) ? res : -res;
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectType {
        NONE,
        CELL,
        COLUMN,
        ROW;

    }

    public class ColInfo {
        public int x;
        public IColumn column;
        public int width;

        public ColInfo(IColumn columnIn, int xIn, int widthIn) {
            this.column = columnIn;
            this.x = xIn;
            this.width = widthIn;
        }
    }

    public class RowInfo {
        public int y;
        public IRow row;
        public int height;
        public boolean fixed = false;

        public RowInfo(IRow rowIn, int yIn, int heightIn, boolean fixedIn) {
            this.row = rowIn;
            this.y = yIn;
            this.height = heightIn;
            this.fixed = fixedIn;
        }
    }
}

