/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.print.JaretTablePrintConfiguration;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import de.jaret.util.ui.table.renderer.ITableHeaderRenderer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class JaretTablePrinter {
    protected double _borderTop = 1.0;
    protected double _borderBottom = 1.0;
    protected double _borderLeft = 1.0;
    protected double _borderRight = 1.0;
    protected Rectangle _printingRect;
    protected Printer _printer;
    protected double _scaleX;
    protected double _scaleY;
    protected ITableHeaderRenderer _headerRenderer;
    protected JaretTable _table;
    protected int _pageHeight;
    protected int _pageWidth;
    protected int _footerHeight;
    protected double _scale = 1.0;

    public JaretTablePrinter(Printer printer, JaretTable table) {
        this._table = table;
        this.setPrinter(printer);
    }

    public void setPrinter(Printer printer) {
        if (this._printer != null) {
            this._printer.dispose();
        }
        this._printer = printer;
        if (printer != null) {
            Point dpi = this._printer.getDPI();
            this._scaleX = (double)dpi.x / 96.0;
            this._scaleY = (double)dpi.y / 96.0;
        }
    }

    public int scaleX(int in) {
        return (int)Math.round(this._scaleX * (double)in * this._scale);
    }

    public double getScaleX() {
        return this._scaleX;
    }

    public int scaleY(int in) {
        return (int)Math.round(this._scaleY * (double)in * this._scale);
    }

    public Printer getPrinter() {
        return this._printer;
    }

    protected int pixelForCmX(double cm) {
        Point dpi = this._printer.getDPI();
        double inch = cm / 2.54;
        return (int)((double)dpi.x * inch);
    }

    protected int pixelForCmY(double cm) {
        Point dpi = this._printer.getDPI();
        double inch = cm / 2.54;
        return (int)((double)dpi.y * inch);
    }

    public Point calculatePageCount(JaretTablePrintConfiguration configuration) {
        this._scale = configuration.getScale();
        this._pageHeight = this._printer.getClientArea().height - this.pixelForCmY(this._borderTop + this._borderBottom);
        this._pageWidth = this._printer.getClientArea().width - this.pixelForCmX(this._borderLeft + this._borderRight);
        int tHeight = configuration.getRowLimit() == -1 ? this._table.getTotalHeight() : this._table.getTotalHeight(configuration.getRowLimit());
        int tWidth = configuration.getColLimit() == -1 ? this._table.getTotalWidth() : this._table.getTotalWidth(configuration.getColLimit());
        int pagesx = this.scaleX(tWidth) / this._pageWidth + 1;
        int pagesy = this.scaleY(tHeight) / (this._pageHeight - this._footerHeight) + 1;
        int headerheight = this._table.getDrawHeader() ? this._table.getHeaderHeight() : 0;
        headerheight = configuration.getRepeatHeader() ? headerheight + headerheight * (pagesy - 1) : headerheight;
        pagesy = this.scaleY(tHeight + headerheight) / (this._pageHeight - this._footerHeight) + 1;
        return new Point(pagesx, pagesy);
    }

    public void print(JaretTablePrintConfiguration configuration) {
        this._printingRect = new Rectangle(this.pixelForCmX(this._borderLeft), this.pixelForCmY(this._borderTop), this._pageWidth, this._pageHeight);
        this._headerRenderer = this._table.getHeaderRenderer().getPrintRenderer(this._printer);
        Point pages = this.calculatePageCount(configuration);
        int pagesx = pages.x;
        int pagesy = pages.y;
        this._printer.startJob(configuration.getName() != null ? configuration.getName() : "jarettable");
        GC gc = new GC((Drawable)this._printer);
        Font oldfont = gc.getFont();
        FontData fontdata = new FontData("Arial", (int)(8.0 * this._scale), 0);
        Font printerFont = new Font((Device)this._printer, fontdata);
        gc.setFont(printerFont);
        for (int px = 0; px < pagesx; ++px) {
            int startx = (int)((double)(px * this._pageWidth) / (this._scaleX * this._scale));
            IColumn column = this._table.getColumnForAbsX(startx);
            int offx = startx - this._table.getAbsBeginXForColumn(column);
            int beginColIdx = this._table.getColIdxForAbsX(startx);
            int rIdx = 0;
            for (int py = 0; py < pagesy; ++py) {
                int y = 0;
                String footerText = configuration.getFooterText() != null ? configuration.getFooterText() : "";
                footerText = footerText + "(" + (px + 1) + "/" + pagesx + "," + (py + 1) + "/" + pagesy + ")";
                this._printer.startPage();
                int starty = (int)((double)py * ((double)(this._pageHeight - this._footerHeight - (configuration.getRepeatHeader() ? this.scaleY(this._table.getHeaderHeight()) : 0)) / (this._scaleY * this._scale)));
                rIdx = py == 0 ? 0 : rIdx;
                Rectangle clipSave = gc.getClipping();
                if (starty == 0 || configuration.getRepeatHeader()) {
                    int x = -offx;
                    for (int cIdx = beginColIdx; this.scaleX(x) < this._pageWidth && cIdx < this._table.getColumnCount() && (configuration.getColLimit() == -1 || cIdx <= configuration.getColLimit()); ++cIdx) {
                        int clipWidth;
                        IColumn col = this._table.getColumn(cIdx);
                        int colwidth = this._table.getTableViewState().getColumnWidth(col);
                        int xx = x > 0 ? x : 0;
                        int n = clipWidth = x > 0 ? colwidth : colwidth - offx;
                        if (!this._headerRenderer.disableClipping()) {
                            gc.setClipping(this.scaleX(xx) + this.pixelForCmX(this._borderLeft), this.pixelForCmY(this._borderTop), this.scaleX(clipWidth), this.scaleY(this._table.getHeaderHeight()));
                            gc.setClipping(gc.getClipping().intersection(this._printingRect));
                        }
                        this.drawHeader(gc, this.scaleX(x) + this.pixelForCmX(this._borderLeft), this.scaleX(colwidth), col);
                        x += colwidth;
                    }
                    y += this._table.getHeaderHeight();
                    gc.setClipping(clipSave);
                }
                gc.setClipping(this._printingRect);
                while (this.scaleY(y) < this._pageHeight && rIdx < this._table.getRowCount() && (configuration.getRowLimit() == -1 || rIdx <= configuration.getRowLimit())) {
                    IRow row = this._table.getRow(rIdx);
                    int rHeight = this._table.getTableViewState().getRowHeight(row);
                    if (this.scaleY(y) + this.scaleY(rHeight) > this._pageHeight) break;
                    int x = -offx;
                    for (int cIdx = beginColIdx; this.scaleX(x) < this._pageWidth && cIdx < this._table.getColumnCount() && (configuration.getColLimit() == -1 || cIdx <= configuration.getColLimit()); ++cIdx) {
                        IColumn col = this._table.getColumn(cIdx);
                        int colwidth = this._table.getTableViewState().getColumnWidth(col);
                        Rectangle area = new Rectangle(this.scaleX(x) + this.pixelForCmX(this._borderLeft), this.scaleY(y) + this.pixelForCmY(this._borderTop), this.scaleX(colwidth), this.scaleY(rHeight));
                        this.drawCell(gc, area, row, col);
                        x += colwidth;
                    }
                    y += rHeight;
                    ++rIdx;
                }
                gc.setClipping(clipSave);
                this.drawFooter(gc, footerText);
                this._printer.endPage();
            }
        }
        this._printer.endJob();
        printerFont.dispose();
        gc.setFont(oldfont);
        gc.dispose();
    }

    private void drawCell(GC gc, Rectangle area, IRow row, IColumn col) {
        ICellStyle bc = this._table.getTableViewState().getCellStyle(row, col);
        ICellRenderer cellRenderer = this._table.getCellRenderer(row, col).createPrintRenderer(this._printer);
        if (cellRenderer != null) {
            cellRenderer.draw(gc, this._table, bc, area, row, col, false, false, true);
        }
        cellRenderer.dispose();
    }

    private void drawFooter(GC gc, String footer) {
        Point extent = gc.textExtent(footer);
        int y = this._printer.getClientArea().height - this._footerHeight - this.pixelForCmY(this._borderBottom);
        gc.drawString(footer, this.pixelForCmX(this._borderLeft), y);
    }

    private void drawHeader(GC gc, int x, int colwidth, IColumn col) {
        Rectangle area = new Rectangle(x, this.pixelForCmY(this._borderTop), colwidth, this.scaleY(this._table.getHeaderHeight()));
        int sortingPos = this._table.getTableViewState().getColumnSortingPosition(col);
        boolean sortingDir = this._table.getTableViewState().getColumnSortingDirection(col);
        this._headerRenderer.draw(gc, area, col, sortingPos, sortingDir, true);
    }

    public void dispose() {
        if (this._headerRenderer != null) {
            this._headerRenderer.dispose();
        }
    }
}

