/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.editor;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.editor.CellEditorBase;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class BooleanCellEditor
extends CellEditorBase
implements ICellEditor {
    protected boolean _singleClick = false;
    private static final int SELECTION_DELTA = 16;

    public BooleanCellEditor() {
    }

    public BooleanCellEditor(boolean singleClick) {
        this._singleClick = singleClick;
    }

    public Control getEditorControl(JaretTable table, IRow row, IColumn column, char typedKey) {
        if (typedKey == ' ') {
            this.toggle(row, column);
        } else if (typedKey == '\u0000') {
            this.toggle(row, column);
        }
        return null;
    }

    public void stopEditing(boolean storeInput) {
    }

    public boolean handleClick(JaretTable table, IRow row, IColumn column, Rectangle drawingArea, int x, int y) {
        Rectangle rect;
        if (this._singleClick && (rect = new Rectangle(drawingArea.x + (drawingArea.width - 16) / 2, drawingArea.y + (drawingArea.height - 16) / 2, 16, 16)).contains(x, y)) {
            this.toggle(row, column);
            return true;
        }
        return false;
    }

    private void toggle(IRow row, IColumn column) {
        Object value = column.getValue(row);
        if (value instanceof Boolean) {
            column.setValue(row, (Boolean)value != false ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    public void dispose() {
        super.dispose();
    }
}

