/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.editor;

import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.datechooser.DateChooser;
import de.jaret.util.ui.datechooser.IDateChooserListener;
import de.jaret.util.ui.datechooser.IFieldIdentifier;
import de.jaret.util.ui.datechooser.SimpleFieldIdentifier;
import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.editor.CellEditorBase;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import java.util.Date;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DateCellEditor
extends CellEditorBase
implements ICellEditor,
IDateChooserListener,
FocusListener {
    protected DateChooser _chooser;
    protected Date _oldVal;
    protected JaretDate _oldJaretDateVal;
    private boolean _jaretDate;

    private void createControl(JaretTable table) {
        this._table = table;
        if (this._chooser == null) {
            this._chooser = new DateChooser((Composite)table, 0);
            SimpleFieldIdentifier fi = new SimpleFieldIdentifier(".", new int[]{5, 2, 1});
            this._chooser.setFieldIdentifier((IFieldIdentifier)fi);
            this._chooser.setSelectAllOnFocusGained(false);
            this._chooser.setBackground(Display.getCurrent().getSystemColor(1));
            this._chooser.addFocusListener((FocusListener)this);
            this._chooser.addDateChooserListener((IDateChooserListener)this);
            this._chooser.getTextField().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 9) {
                        DateCellEditor.this._chooser.validateInput();
                        DateCellEditor.this.stopEditing(true);
                        event.doit = false;
                        DateCellEditor.this._table.forceFocus();
                        DateCellEditor.this._table.focusRight();
                    } else if (event.keyCode == 13) {
                        DateCellEditor.this._chooser.validateInput();
                        DateCellEditor.this.stopEditing(true);
                        event.doit = false;
                        DateCellEditor.this._table.forceFocus();
                        DateCellEditor.this._table.focusDown();
                    } else if (event.keyCode == 27) {
                        DateCellEditor.this.stopEditing(false);
                        DateCellEditor.this.restoreOldVal();
                        event.doit = false;
                        DateCellEditor.this._table.forceFocus();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this._chooser.getTextField().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    e.doit = false;
                }
            });
        }
    }

    public Control getEditorControl(JaretTable table, IRow row, IColumn column, char typedKey) {
        super.getEditorControl(table, row, column, typedKey);
        this.createControl(table);
        if (column.getValue(row) instanceof Date) {
            this._oldVal = (Date)column.getValue(row);
            this._jaretDate = false;
        } else if (column.getValue(row) instanceof JaretDate) {
            this._oldVal = ((JaretDate)column.getValue(row)).getDate();
            this._oldJaretDateVal = (JaretDate)column.getValue(row);
            this._jaretDate = true;
        }
        if (typedKey != '\u0000') {
            this._chooser.setText("" + typedKey);
            this._chooser.setSelection(1);
        } else {
            this._chooser.setDate(this._oldVal);
        }
        this._row = row;
        this._column = column;
        return this._chooser;
    }

    private void restoreOldVal() {
        if (!this._jaretDate) {
            this._column.setValue(this._row, this._oldVal);
        } else {
            this._column.setValue(this._row, this._oldJaretDateVal);
        }
    }

    public void stopEditing(boolean storeInput) {
        if (storeInput) {
            this.storeValue();
        }
        this._chooser.setDropped(false);
        this._chooser.setVisible(false);
    }

    private void storeValue() {
        if (!this._jaretDate) {
            this._column.setValue(this._row, this._chooser.getDate());
        } else {
            this._column.setValue(this._row, new JaretDate(this._chooser.getDate()));
        }
    }

    public void dispose() {
        if (this._chooser != null && !this._chooser.isDisposed()) {
            this._chooser.removeFocusListener((FocusListener)this);
            this._chooser.dispose();
        }
        this._table = null;
        this._column = null;
        this._row = null;
    }

    public void dateChosen(Date date) {
        this.stopEditing(true);
        this._table.forceFocus();
    }

    public void dateIntermediateChange(Date date) {
    }

    public void choosingCanceled() {
        this._chooser.setDate(this._oldVal);
    }

    public void inputInvalid() {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this._table.stopEditing(true);
    }
}

