/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.editor;

import de.jaret.util.ui.DoubleField;
import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.editor.CellEditorBase;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import java.text.ParseException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DoubleCellEditor
extends CellEditorBase
implements ICellEditor,
FocusListener {
    protected Text _text;
    protected double _oldVal;
    protected DoubleField _doubleField;

    protected double convertValue(IRow row, IColumn column) {
        Object value = column.getValue(row);
        return value != null ? (Double)value : 0.0;
    }

    protected void storeValue(IRow row, IColumn column) {
        try {
            double value = this._doubleField.getValue();
            this._column.setValue(this._row, value);
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    private void createControl(JaretTable table) {
        if (this._text == null) {
            this._table = table;
            this._text = new Text((Composite)table, 133120);
            this._doubleField = new DoubleField();
            this._doubleField.setText(this._text);
            this._text.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 9) {
                        event.doit = false;
                        DoubleCellEditor.this.stopEditing(true);
                        DoubleCellEditor.this._table.forceFocus();
                        DoubleCellEditor.this._table.focusRight();
                    } else if (event.keyCode == 13) {
                        event.doit = false;
                        DoubleCellEditor.this.stopEditing(true);
                        DoubleCellEditor.this._table.forceFocus();
                        DoubleCellEditor.this._table.focusDown();
                    } else if (event.keyCode == 27) {
                        event.doit = false;
                        DoubleCellEditor.this.stopEditing(false);
                        DoubleCellEditor.this._column.setValue(DoubleCellEditor.this._row, DoubleCellEditor.this._oldVal);
                        DoubleCellEditor.this._table.forceFocus();
                    }
                }

                public void keyReleased(KeyEvent arg0) {
                }
            });
            this._text.addFocusListener((FocusListener)this);
        }
    }

    public Control getEditorControl(JaretTable table, IRow row, IColumn column, char typedKey) {
        super.getEditorControl(table, row, column, typedKey);
        this.createControl(table);
        this._oldVal = this.convertValue(row, column);
        if (typedKey != '\u0000') {
            this._text.setText("" + typedKey);
            this._text.setSelection(1);
        } else {
            double value = this.convertValue(row, column);
            this._doubleField.setValue(value);
            this._text.selectAll();
        }
        return this._text;
    }

    public int getPreferredHeight() {
        if (this._text == null) {
            return -1;
        }
        Point size = this._text.computeSize(-1, -1);
        return size.y;
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this._table.stopEditing(true);
    }

    public void dispose() {
        super.dispose();
        if (this._text != null && !this._text.isDisposed()) {
            this._doubleField.setText(null);
            this._text.removeFocusListener((FocusListener)this);
            this._text.dispose();
        }
    }

    public void stopEditing(boolean storeInput) {
        if (storeInput) {
            this.storeValue(this._row, this._column);
        }
        this._text.setVisible(false);
    }
}

