/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.editor;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.editor.CellEditorBase;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnumComboEditor
extends CellEditorBase
implements ICellEditor,
FocusListener {
    protected Combo _combo;
    protected Object _oldVal;
    protected Object[] _items;

    public Control getEditorControl(JaretTable table, IRow row, IColumn column, char typedKey) {
        Object value;
        Class<?> clazz;
        super.getEditorControl(table, row, column, typedKey);
        this._items = new Object[0];
        if (this._combo == null) {
            this._combo = new Combo((Composite)table, 2056);
            this._combo.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 9) {
                        event.doit = false;
                        EnumComboEditor.this.stopEditing(true);
                        EnumComboEditor.this._table.forceFocus();
                        EnumComboEditor.this._table.focusRight();
                    } else if (event.keyCode == 13) {
                        event.doit = false;
                        EnumComboEditor.this.stopEditing(true);
                        EnumComboEditor.this._table.forceFocus();
                        EnumComboEditor.this._table.focusDown();
                    } else if (event.keyCode == 27) {
                        event.doit = false;
                        EnumComboEditor.this.stopEditing(false);
                        EnumComboEditor.this._column.setValue(EnumComboEditor.this._row, EnumComboEditor.this._oldVal);
                        EnumComboEditor.this._table.forceFocus();
                    }
                }

                public void keyReleased(KeyEvent arg0) {
                }
            });
            this._combo.addFocusListener((FocusListener)this);
        }
        this._items = (clazz = column.getContentClass(row)) != null && Enum.class.isAssignableFrom(clazz) ? clazz.getEnumConstants() : new Object[0];
        this._oldVal = value = column.getValue(row);
        int selIdx = -1;
        String[] stringItems = new String[this._items.length];
        for (int i = 0; i < this._items.length; ++i) {
            stringItems[i] = this._items[i].toString();
            if (value == null || !value.equals(this._items[i])) continue;
            selIdx = i;
        }
        this._combo.setItems(stringItems);
        if (selIdx != -1) {
            this._combo.select(selIdx);
        }
        return this._combo;
    }

    public void stopEditing(boolean storeInput) {
        if (storeInput) {
            int selIdx = this._combo.getSelectionIndex();
            Object selection = null;
            if (selIdx != -1) {
                selection = this._items[selIdx];
            }
            this._column.setValue(this._row, selection);
        }
        this._combo.setVisible(false);
    }

    public void dispose() {
        super.dispose();
        if (this._combo != null && !this._combo.isDisposed()) {
            this._combo.dispose();
        }
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this.stopEditing(true);
    }

    public int getPreferredHeight() {
        if (this._combo != null) {
            Point size = this._combo.computeSize(-1, -1);
            return size.y;
        }
        return -1;
    }
}

