/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.editor;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.editor.CellEditorBase;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class IntegerCellEditor
extends CellEditorBase
implements ICellEditor,
FocusListener {
    protected Spinner _spinner;
    private int _oldVal;
    private int _min = Integer.MIN_VALUE;
    private int _max = Integer.MAX_VALUE;

    public IntegerCellEditor(int min, int max) {
        this._min = min;
        this._max = max;
    }

    public IntegerCellEditor() {
    }

    protected int convertValue(IRow row, IColumn column) {
        Object value = column.getValue(row);
        return value != null ? (Integer)value : 0;
    }

    protected void storeValue(IRow row, IColumn column) {
        Integer value = this._spinner.getSelection();
        this._column.setValue(this._row, value);
    }

    private void createControl(JaretTable table) {
        if (this._spinner == null) {
            this._table = table;
            this._spinner = new Spinner((Composite)table, 2048);
            this._spinner.setMaximum(this._max);
            this._spinner.setMinimum(this._min);
            this._spinner.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    e.doit = false;
                }
            });
            this._spinner.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 9) {
                        event.doit = false;
                        IntegerCellEditor.this.stopEditing(true);
                        IntegerCellEditor.this._table.forceFocus();
                        IntegerCellEditor.this._table.focusRight();
                    } else if (event.keyCode == 13) {
                        event.doit = false;
                        IntegerCellEditor.this.stopEditing(true);
                        IntegerCellEditor.this._table.forceFocus();
                        IntegerCellEditor.this._table.focusDown();
                    } else if (event.keyCode == 27) {
                        event.doit = false;
                        IntegerCellEditor.this.stopEditing(false);
                        IntegerCellEditor.this._column.setValue(IntegerCellEditor.this._row, IntegerCellEditor.this._oldVal);
                        IntegerCellEditor.this._table.forceFocus();
                    }
                }

                public void keyReleased(KeyEvent arg0) {
                }
            });
            this._spinner.addFocusListener((FocusListener)this);
        }
    }

    public Control getEditorControl(JaretTable table, IRow row, IColumn column, char typedKey) {
        super.getEditorControl(table, row, column, typedKey);
        this.createControl(table);
        this._oldVal = (Integer)column.getValue(row);
        int value = this.convertValue(row, column);
        this._spinner.setSelection(value);
        return this._spinner;
    }

    public int getPreferredHeight() {
        if (this._spinner == null) {
            return -1;
        }
        Point size = this._spinner.computeSize(-1, -1);
        return size.y;
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this._table.stopEditing(true);
    }

    public void dispose() {
        super.dispose();
        if (this._spinner != null && !this._spinner.isDisposed()) {
            this._spinner.removeFocusListener((FocusListener)this);
            this._spinner.dispose();
        }
    }

    public void stopEditing(boolean storeInput) {
        if (storeInput) {
            this.storeValue(this._row, this._column);
        }
        this._spinner.setVisible(false);
    }
}

