/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.editor;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.editor.CellEditorBase;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectComboEditor
extends CellEditorBase
implements ICellEditor,
FocusListener {
    protected Combo _combo;
    protected Object _oldVal;
    protected String[] _stringItems;
    protected ILabelProvider _labelProvider;
    protected boolean _allowNull = true;
    protected String _nullText = "";
    protected List<? extends Object> _itemList;

    public ObjectComboEditor(List<? extends Object> list, ILabelProvider labelProvider, boolean allowNull, String nullText) {
        this._labelProvider = labelProvider;
        if (this._labelProvider == null) {
            this._labelProvider = new ToStringLabelProvider();
        }
        this._allowNull = allowNull;
        this._nullText = nullText;
        this._itemList = list;
        if (this._itemList != null) {
            this.initItems();
        }
    }

    protected void initItems() {
        this._stringItems = this._allowNull ? new String[this._itemList.size() + 1] : new String[this._itemList.size()];
        int i = 0;
        if (this._allowNull) {
            this._stringItems[0] = this._nullText;
            i = 1;
        }
        for (Object object : this._itemList) {
            this._stringItems[i++] = this._labelProvider.getText(object);
        }
    }

    @Override
    public Control getEditorControl(JaretTable table, IRow row, IColumn column, char typedKey) {
        Object value;
        super.getEditorControl(table, row, column, typedKey);
        if (this._combo == null) {
            this._combo = new Combo((Composite)table, 2056);
            this._combo.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 9) {
                        event.doit = false;
                        ObjectComboEditor.this.stopEditing(true);
                        ObjectComboEditor.this._table.forceFocus();
                        ObjectComboEditor.this._table.focusRight();
                    } else if (event.keyCode == 13) {
                        event.doit = false;
                        ObjectComboEditor.this.stopEditing(true);
                        ObjectComboEditor.this._table.forceFocus();
                        ObjectComboEditor.this._table.focusDown();
                    } else if (event.keyCode == 27) {
                        event.doit = false;
                        ObjectComboEditor.this.stopEditing(false);
                        ObjectComboEditor.this._column.setValue(ObjectComboEditor.this._row, ObjectComboEditor.this._oldVal);
                        ObjectComboEditor.this._table.forceFocus();
                    }
                }

                public void keyReleased(KeyEvent arg0) {
                }
            });
            this._combo.addFocusListener((FocusListener)this);
            this._combo.setItems(this._stringItems);
        }
        this._oldVal = value = column.getValue(row);
        int selIdx = -1;
        if (this._allowNull && value == null) {
            selIdx = 0;
        } else {
            selIdx = this._itemList.indexOf(value);
            int n = selIdx = this._allowNull ? selIdx + 1 : selIdx;
        }
        if (selIdx != -1) {
            this._combo.select(selIdx);
        }
        return this._combo;
    }

    @Override
    public void stopEditing(boolean storeInput) {
        if (storeInput) {
            int selIdx = this._combo.getSelectionIndex();
            Object selection = null;
            if (selIdx != -1) {
                if (this._allowNull && selIdx == 0) {
                    selection = null;
                } else {
                    selIdx = this._allowNull ? selIdx - 1 : selIdx;
                    selection = this._itemList.get(selIdx);
                }
            }
            this._column.setValue(this._row, selection);
        }
        this._combo.setVisible(false);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._combo != null && !this._combo.isDisposed()) {
            this._combo.dispose();
        }
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this.stopEditing(true);
    }

    @Override
    public int getPreferredHeight() {
        if (this._combo != null) {
            Point size = this._combo.computeSize(-1, -1);
            return size.y;
        }
        return -1;
    }

    public class ToStringLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

