/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.editor;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.editor.CellEditorBase;
import de.jaret.util.ui.table.editor.ICellEditor;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextCellEditor
extends CellEditorBase
implements ICellEditor,
FocusListener {
    protected boolean _multi = true;
    protected Text _text;
    private String _oldVal;
    private int _maxrows = 6;

    public TextCellEditor(boolean multi) {
        this._multi = multi;
    }

    protected String convertValue(IRow row, IColumn column) {
        Object value = column.getValue(row);
        return value != null ? value.toString() : null;
    }

    protected void storeValue(IRow row, IColumn column) {
        String value = this._text.getText();
        this._column.setValue(this._row, value);
    }

    private void createControl(JaretTable table) {
        if (this._text == null) {
            this._table = table;
            this._text = !this._multi ? new Text((Composite)table, 2048) : new Text((Composite)table, 2114);
            this._text.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    if ((event.stateMask & 0x10000) != 0 && event.keyCode == 13) {
                        event.doit = false;
                        TextCellEditor.this._text.insert("\n");
                    } else if (event.keyCode == 9) {
                        event.doit = false;
                        TextCellEditor.this.stopEditing(true);
                        TextCellEditor.this._table.forceFocus();
                        TextCellEditor.this._table.focusRight();
                    } else if (event.keyCode == 13) {
                        event.doit = false;
                        TextCellEditor.this.stopEditing(true);
                        TextCellEditor.this._table.forceFocus();
                        TextCellEditor.this._table.focusDown();
                    } else if (event.keyCode == 27) {
                        event.doit = false;
                        TextCellEditor.this.stopEditing(false);
                        TextCellEditor.this._column.setValue(TextCellEditor.this._row, TextCellEditor.this._oldVal);
                        TextCellEditor.this._table.forceFocus();
                    } else if (TextCellEditor.this._multi) {
                        Point newSize = new Point(TextCellEditor.this._text.getSize().x, TextCellEditor.this.getPreferredHeight());
                        TextCellEditor.this._text.setSize(newSize);
                    }
                }

                public void keyReleased(KeyEvent arg0) {
                }
            });
            this._text.addFocusListener((FocusListener)this);
        }
    }

    public Control getEditorControl(JaretTable table, IRow row, IColumn column, char typedKey) {
        super.getEditorControl(table, row, column, typedKey);
        this.createControl(table);
        this._oldVal = (String)column.getValue(row);
        if (typedKey != '\u0000') {
            this._text.setText("" + typedKey);
            this._text.setSelection(1);
        } else {
            String value = this.convertValue(row, column);
            this._text.setText(value != null ? value : "");
            this._text.selectAll();
        }
        return this._text;
    }

    public int getPreferredHeight() {
        if (this._text == null) {
            return -1;
        }
        int lheight = this._text.getLineHeight();
        int lcount = this._text.getLineCount();
        if (lcount > this._maxrows + 1) {
            lcount = this._maxrows;
        }
        return (lcount + 1) * lheight;
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this._table.stopEditing(true);
    }

    public void dispose() {
        super.dispose();
        if (this._text != null && !this._text.isDisposed()) {
            this._text.removeFocusListener((FocusListener)this);
            this._text.dispose();
        }
    }

    public void stopEditing(boolean storeInput) {
        if (storeInput) {
            this.storeValue(this._row, this._column);
        }
        this._text.setVisible(false);
    }

    public int getMaxrows() {
        return this._maxrows;
    }

    public void setMaxrows(int maxrows) {
        this._maxrows = maxrows;
    }
}

