/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.filter;

import de.jaret.util.ui.table.filter.AbstractAutoFilter;
import de.jaret.util.ui.table.filter.IAutoFilter;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DefaultAutoFilter
extends AbstractAutoFilter
implements IAutoFilter,
SelectionListener {
    private static final int MAX_AUTOFILTERLENGTH = -1;
    protected static final String TEXT_FILTER_ALL = "(all)";
    protected static final String TEXT_FILTER_EMPTY = "(empty)";
    protected static final String TEXT_FILTER_NONEMPTY = "(non-empty)";
    protected CCombo _combo;

    public void dispose() {
        if (this._combo != null) {
            this._combo.dispose();
        }
    }

    public Control getControl() {
        return this._combo;
    }

    public boolean isInResult(IRow row) {
        String valString;
        String filter = this._combo.getText();
        Object value = this._column.getValue(row);
        String string = valString = value != null ? value.toString() : "";
        if (!filter.equals(TEXT_FILTER_ALL)) {
            if (filter.equals(TEXT_FILTER_EMPTY) && valString.trim().length() > 0) {
                return false;
            }
            if (filter.equals(TEXT_FILTER_NONEMPTY) && valString.trim().length() == 0) {
                return false;
            }
            if (!(filter.equals(TEXT_FILTER_ALL) || filter.equals(TEXT_FILTER_EMPTY) || filter.equals(TEXT_FILTER_NONEMPTY) || filter.equals(valString))) {
                return false;
            }
        }
        return true;
    }

    public void update() {
        if (this._combo == null) {
            this._combo = new CCombo((Composite)this._table, 2056);
            this._combo.addSelectionListener((SelectionListener)this);
        }
        IColumn col = this._column;
        Set<String> colFilterStrings = this.getColFilterStrings(col, -1);
        String[] items = new String[colFilterStrings.size() + 3];
        int idx = 0;
        items[idx++] = TEXT_FILTER_ALL;
        items[idx++] = TEXT_FILTER_EMPTY;
        items[idx++] = TEXT_FILTER_NONEMPTY;
        for (String s : colFilterStrings) {
            items[idx++] = s;
        }
        this._combo.setItems(items);
        this._combo.select(0);
    }

    public void reset() {
        this._combo.select(0);
        this.firePropertyChange("FILTER", null, "x");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.firePropertyChange("FILTER", null, "x");
    }
}

