/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IColumnListener;
import de.jaret.util.ui.table.model.IRow;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumn
implements IColumn {
    protected List<IColumnListener> _listeners;

    protected void fireValueChanged(IRow row, IColumn column, Object oldValue, Object newValue) {
        if (this._listeners != null) {
            for (IColumnListener listener : this._listeners) {
                listener.valueChanged(row, column, oldValue, newValue);
            }
        }
    }

    @Override
    public synchronized void addColumnListener(IColumnListener cl) {
        if (this._listeners == null) {
            this._listeners = new Vector<IColumnListener>();
        }
        this._listeners.add(cl);
    }

    @Override
    public void remColumnListener(IColumnListener cl) {
        if (this._listeners != null) {
            this._listeners.remove(cl);
        }
    }

    @Override
    public Class<?> getContentClass(IRow row) {
        return this.getContentClass();
    }

    @Override
    public boolean displayHeader() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isEditable(IRow row) {
        return this.isEditable();
    }
}

