/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IJaretTableModel;
import de.jaret.util.ui.table.model.IJaretTableModelListener;
import de.jaret.util.ui.table.model.IRow;
import java.util.List;
import java.util.Vector;

public abstract class AbstractJaretTableModel
implements IJaretTableModel {
    protected List<IJaretTableModelListener> _listeners;

    public IColumn getColumn(String id) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumn(i).getId() == null || !this.getColumn(i).getId().equals(id)) continue;
            return this.getColumn(i);
        }
        return null;
    }

    public void setValue(IRow row, IColumn column, Object value) {
        column.setValue(row, value);
    }

    public boolean isEditable(IRow row, IColumn column) {
        return column.isEditable(row);
    }

    public synchronized void addJaretTableModelListener(IJaretTableModelListener jtml) {
        if (this._listeners == null) {
            this._listeners = new Vector<IJaretTableModelListener>();
        }
        this._listeners.add(jtml);
    }

    public synchronized void removeJaretTableModelListener(IJaretTableModelListener jtml) {
        if (this._listeners != null) {
            this._listeners.remove(jtml);
        }
    }

    protected void fireRowAdded(int idx, IRow row) {
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                IJaretTableModelListener listener = this._listeners.get(i);
                listener.rowAdded(idx, row);
            }
        }
    }

    protected void fireRowRemoved(IRow row) {
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                IJaretTableModelListener listener = this._listeners.get(i);
                listener.rowRemoved(row);
            }
        }
    }

    protected void fireRowChanged(IRow row) {
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                IJaretTableModelListener listener = this._listeners.get(i);
                listener.rowChanged(row);
            }
        }
    }

    protected void fireColumnAdded(int idx, IColumn column) {
        if (this._listeners != null) {
            for (IJaretTableModelListener listener : this._listeners) {
                listener.columnAdded(idx, column);
            }
        }
    }

    protected void fireColumnRemoved(IColumn column) {
        if (this._listeners != null) {
            for (IJaretTableModelListener listener : this._listeners) {
                listener.columnRemoved(column);
            }
        }
    }

    protected void fireColumnChanged(IColumn column) {
        if (this._listeners != null) {
            for (IJaretTableModelListener listener : this._listeners) {
                listener.columnChanged(column);
            }
        }
    }

    protected void fireCellChanged(IRow row, IColumn column) {
        if (this._listeners != null) {
            for (IJaretTableModelListener listener : this._listeners) {
                listener.cellChanged(row, column);
            }
        }
    }

    protected void fireTableDataChanged() {
        if (this._listeners != null) {
            for (IJaretTableModelListener listener : this._listeners) {
                listener.tableDataChanged();
            }
        }
    }
}

