/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.misc.PropertyObservableBase;
import de.jaret.util.ui.table.model.ITableNode;
import de.jaret.util.ui.table.model.ITableNodeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableNode
extends PropertyObservableBase
implements ITableNode {
    protected List<ITableNodeListener> _listeners;
    protected List<ITableNode> _children = new ArrayList<ITableNode>();
    protected int _level;

    @Override
    public List<ITableNode> getChildren() {
        return this._children;
    }

    @Override
    public int getLevel() {
        return this._level;
    }

    @Override
    public void setLevel(int level) {
        this._level = level;
        if (this._children != null) {
            for (ITableNode node : this._children) {
                node.setLevel(level + 1);
            }
        }
    }

    @Override
    public void addNode(ITableNode node) {
        node.setLevel(this._level + 1);
        this._children.add(node);
        this.fireNodeAdded(node);
    }

    @Override
    public void remNode(ITableNode node) {
        if (this._children.contains(node)) {
            this._children.remove(node);
            this.fireNodeRemoved(node);
        }
    }

    @Override
    public synchronized void addTableNodeListener(ITableNodeListener tnl) {
        if (this._listeners == null) {
            this._listeners = new Vector<ITableNodeListener>();
        }
        this._listeners.add(tnl);
    }

    @Override
    public void removeTableNodeListener(ITableNodeListener tnl) {
        if (this._listeners != null) {
            this._listeners.remove(tnl);
        }
    }

    protected void fireNodeAdded(ITableNode node) {
        if (this._listeners != null) {
            for (ITableNodeListener listener : this._listeners) {
                listener.nodeAdded(this, node);
            }
        }
    }

    protected void fireNodeRemoved(ITableNode node) {
        if (this._listeners != null) {
            for (ITableNodeListener listener : this._listeners) {
                listener.nodeRemoved(this, node);
            }
        }
    }
}

