/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.DefaultTableViewState;
import de.jaret.util.ui.table.model.IHierarchicalTableViewState;
import de.jaret.util.ui.table.model.IHierarchicalTableViewStateListener;
import de.jaret.util.ui.table.model.ITableNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DefaultHierarchicalTableViewState
extends DefaultTableViewState
implements IHierarchicalTableViewState {
    protected List<IHierarchicalTableViewStateListener> _listeners;
    protected Map<ITableNode, Boolean> _expandedStatesMap = new HashMap<ITableNode, Boolean>();

    public boolean isExpanded(ITableNode node) {
        Boolean state = this._expandedStatesMap.get(node);
        return state != null && state != false;
    }

    public void setExpanded(ITableNode node, boolean expanded) {
        boolean state = this.isExpanded(node);
        if (state != expanded) {
            this._expandedStatesMap.put(node, expanded);
            if (expanded) {
                this.fireNodeExpanded(node);
            } else {
                this.fireNodeFolded(node);
            }
        }
    }

    public void setExpandedRecursive(ITableNode node, boolean expanded) {
        if (node.getChildren().size() > 0) {
            this.setExpanded(node, expanded);
            for (ITableNode child : node.getChildren()) {
                this.setExpandedRecursive(child, expanded);
            }
        }
    }

    public synchronized void addHierarchicalViewstateListener(IHierarchicalTableViewStateListener htvsListener) {
        if (this._listeners == null) {
            this._listeners = new Vector<IHierarchicalTableViewStateListener>();
        }
        this._listeners.add(htvsListener);
    }

    public void remHierarchicalViewStateListener(IHierarchicalTableViewStateListener htvsListener) {
        if (this._listeners != null) {
            this._listeners.remove(htvsListener);
        }
    }

    protected void fireNodeExpanded(ITableNode node) {
        if (this._listeners != null) {
            for (IHierarchicalTableViewStateListener listener : this._listeners) {
                listener.nodeExpanded(node);
            }
        }
    }

    protected void fireNodeFolded(ITableNode node) {
        if (this._listeners != null) {
            for (IHierarchicalTableViewStateListener listener : this._listeners) {
                listener.nodeFolded(node);
            }
        }
    }
}

