/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.AbstractJaretTableModel;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IJaretTableModel;
import de.jaret.util.ui.table.model.IRow;
import java.util.ArrayList;
import java.util.List;

public class DefaultJaretTableModel
extends AbstractJaretTableModel
implements IJaretTableModel {
    protected List<IRow> _rows = new ArrayList<IRow>();
    protected List<IColumn> _cols = new ArrayList<IColumn>();

    public int getRowCount() {
        return this._rows.size();
    }

    public IRow getRow(int idx) {
        return this._rows.get(idx);
    }

    public void addRow(IRow row) {
        this._rows.add(row);
        this.fireRowAdded(this._rows.size() - 1, row);
    }

    public void addRow(int index, IRow row) {
        this._rows.add(index, row);
        this.fireRowAdded(index, row);
    }

    public void remRow(IRow row) {
        if (this._rows.contains(row)) {
            this._rows.remove(row);
            this.fireRowRemoved(row);
        }
    }

    public int getColumnCount() {
        return this._cols.size();
    }

    public IColumn getColumn(int idx) {
        return this._cols.get(idx);
    }

    public IColumn getColumn(String id) {
        for (IColumn col : this._cols) {
            if (!col.getId().equals(id)) continue;
            return col;
        }
        return null;
    }

    public void addColumn(IColumn column) {
        this._cols.add(column);
        this.fireColumnAdded(this._cols.size() - 1, column);
    }

    public void remColumn(IColumn column) {
        if (this._cols.contains(column)) {
            this._cols.remove(column);
            this.fireColumnRemoved(column);
        }
    }
}

