/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.ITableViewState;
import de.jaret.util.ui.table.model.ITableViewStateListener;
import de.jaret.util.ui.table.renderer.DefaultCellStyleProvider;
import de.jaret.util.ui.table.renderer.ICellStyle;
import de.jaret.util.ui.table.renderer.ICellStyleListener;
import de.jaret.util.ui.table.renderer.ICellStyleProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableViewState
implements ITableViewState,
ICellStyleListener {
    protected Map<IRow, RowConfiguration> _rowConfiguations = new HashMap<IRow, RowConfiguration>();
    protected Map<IColumn, ColumnConfiguration> _colConfigurations = new HashMap<IColumn, ColumnConfiguration>();
    protected List<ITableViewStateListener> _listeners;
    protected int _minimalRowHeight = 10;
    protected int _maximalRowHeight = -1;
    protected int _defaultRowHeight = 22;
    protected int _minimalColumnWidth = 10;
    protected int _maximalColumnWidth = -1;
    protected int _defaultColumnWidth = 100;
    protected List<IColumn> _sortedColumns;
    protected ICellStyleProvider _cellStyleProvider;
    protected ITableViewState.ColumnResizeMode _columnResizeMode;
    protected ITableViewState.RowHeightMode _defaultRowHeightMode = ITableViewState.RowHeightMode.OPTANDVAR;

    public DefaultTableViewState() {
        this._cellStyleProvider = new DefaultCellStyleProvider();
        this._cellStyleProvider.addCellStyleListener(this);
    }

    @Override
    public int getRowHeight(IRow row) {
        RowConfiguration configuration = this.getRowConfiguration(row);
        return configuration.rowHeight;
    }

    @Override
    public void setRowHeight(IRow row, int height) {
        RowConfiguration configuration = this.getRowConfiguration(row);
        if (configuration.rowHeight != height) {
            configuration.rowHeight = height;
            this.fireRowHeightChanged(row, height);
        }
    }

    @Override
    public void setRowHeight(int height) {
        this._defaultRowHeight = height;
        for (RowConfiguration rconfig : this._rowConfiguations.values()) {
            rconfig.rowHeight = height;
        }
        for (IRow row : this._rowConfiguations.keySet()) {
            this.fireRowHeightChanged(row, height);
        }
    }

    @Override
    public ITableViewState.RowHeightMode getRowHeigthMode(IRow row) {
        RowConfiguration configuration = this.getRowConfiguration(row);
        return configuration.heightMode;
    }

    @Override
    public void setRowHeightMode(IRow row, ITableViewState.RowHeightMode mode) {
        RowConfiguration configuration = this.getRowConfiguration(row);
        if (configuration.heightMode != mode) {
            configuration.heightMode = mode;
            this.fireRowHeightModeChanged(row, mode);
        }
    }

    @Override
    public void setRowHeightMode(ITableViewState.RowHeightMode mode) {
        this._defaultRowHeightMode = mode;
        for (RowConfiguration rconfig : this._rowConfiguations.values()) {
            rconfig.heightMode = mode;
        }
        for (IRow row : this._rowConfiguations.keySet()) {
            this.fireRowHeightModeChanged(row, mode);
        }
    }

    @Override
    public ITableViewState.RowHeightMode getRowHeightMode() {
        return this._defaultRowHeightMode;
    }

    private RowConfiguration getRowConfiguration(IRow row) {
        RowConfiguration configuration = this._rowConfiguations.get(row);
        if (configuration == null) {
            configuration = this.getDefaultRowConfiguration();
            this._rowConfiguations.put(row, configuration);
        }
        return configuration;
    }

    private RowConfiguration getDefaultRowConfiguration() {
        RowConfiguration configuration = new RowConfiguration();
        configuration.rowHeight = this._defaultRowHeight;
        configuration.heightMode = this._defaultRowHeightMode;
        return configuration;
    }

    private ColumnConfiguration getColumnConfiguration(IColumn col) {
        ColumnConfiguration configuration = this._colConfigurations.get(col);
        if (configuration == null) {
            configuration = this.getDefaultColumnConfiguration(col.getId());
            this._colConfigurations.put(col, configuration);
        }
        return configuration;
    }

    private ColumnConfiguration getColumnConfiguration(String columnId) {
        for (ColumnConfiguration colConf : this._colConfigurations.values()) {
            if (!colConf.id.equals(columnId)) continue;
            return colConf;
        }
        return this.getDefaultColumnConfiguration(columnId);
    }

    private ColumnConfiguration getDefaultColumnConfiguration(String colId) {
        ColumnConfiguration configuration = new ColumnConfiguration();
        configuration.id = colId;
        configuration.resizable = true;
        configuration.columnWidth = this._defaultColumnWidth;
        return configuration;
    }

    @Override
    public int getColumnWidth(IColumn column) {
        ColumnConfiguration configuration = this.getColumnConfiguration(column);
        return (int)Math.round(configuration.columnWidth);
    }

    @Override
    public void setColumnWidth(IColumn column, int width) {
        ColumnConfiguration configuration = this.getColumnConfiguration(column);
        if (configuration.columnWidth != (double)width) {
            int oldVal = (int)Math.round(configuration.columnWidth);
            if (this._columnResizeMode == ITableViewState.ColumnResizeMode.SUBSEQUENT) {
                IColumn sCol = this.getSubsequentColumn(column);
                if (sCol == null) {
                    configuration.columnWidth = width;
                    this.fireColumnWidthChanged(column, width);
                } else {
                    int delta = width - oldVal;
                    int max = this.getColumnWidth(sCol) - this._minimalColumnWidth;
                    delta = delta > max ? max : delta;
                    configuration.columnWidth += (double)delta;
                    ColumnConfiguration sConfiguration = this.getColumnConfiguration(sCol);
                    sConfiguration.columnWidth -= (double)delta;
                    this.fireColumnWidthsChanged();
                }
            } else if (this._columnResizeMode == ITableViewState.ColumnResizeMode.ALLSUBSEQUENT || this._columnResizeMode == ITableViewState.ColumnResizeMode.ALL) {
                List<IColumn> sCols = null;
                sCols = this._columnResizeMode == ITableViewState.ColumnResizeMode.ALLSUBSEQUENT ? this.getSubsequentColumns(column) : this.getAllVisibleCols(column);
                if (sCols.size() == 0) {
                    configuration.columnWidth = width;
                    this.fireColumnWidthChanged(column, width);
                } else {
                    int max = 0;
                    for (IColumn c : sCols) {
                        max += this.getColumnWidth(c) - this._minimalColumnWidth;
                    }
                    int delta = width - oldVal;
                    delta = delta > max ? max : delta;
                    configuration.columnWidth += (double)delta;
                    double distDelta = (double)delta / (double)sCols.size();
                    for (IColumn c : sCols) {
                        ColumnConfiguration sConfiguration = this.getColumnConfiguration(c);
                        sConfiguration.columnWidth -= distDelta;
                    }
                    this.fireColumnWidthsChanged();
                }
            } else {
                configuration.columnWidth = width;
                this.fireColumnWidthChanged(column, width);
            }
        }
    }

    private List<IColumn> getAllVisibleCols(IColumn without) {
        ArrayList<IColumn> result = new ArrayList<IColumn>();
        int idx = this._sortedColumns.indexOf(without);
        for (int i = 0; i < this._sortedColumns.size(); ++i) {
            if (idx == i || !this.getColumnVisible(this._sortedColumns.get(i))) continue;
            result.add(this._sortedColumns.get(i));
        }
        return result;
    }

    private IColumn getSubsequentColumn(IColumn column) {
        List<IColumn> l = this.getSubsequentColumns(column);
        if (l.size() > 0) {
            return l.get(0);
        }
        return null;
    }

    private List<IColumn> getSubsequentColumns(IColumn column) {
        ArrayList<IColumn> result = new ArrayList<IColumn>();
        int idx = this._sortedColumns.indexOf(column);
        if (idx == -1) {
            return result;
        }
        for (int i = idx + 1; i < this._sortedColumns.size(); ++i) {
            if (!this.getColumnVisible(this._sortedColumns.get(i))) continue;
            result.add(this._sortedColumns.get(i));
        }
        return result;
    }

    @Override
    public boolean getColumnVisible(IColumn column) {
        ColumnConfiguration configuration = this.getColumnConfiguration(column);
        return configuration.visible;
    }

    @Override
    public void setColumnVisible(IColumn column, boolean visible) {
        ColumnConfiguration configuration = this.getColumnConfiguration(column);
        if (configuration.visible != visible) {
            configuration.visible = visible;
            this.fireColumnVisibilityChanged(column, visible);
        }
    }

    @Override
    public void setColumnVisible(String columnId, boolean visible) {
        ColumnConfiguration configuration = this.getColumnConfiguration(columnId);
        if (configuration.visible != visible) {
            configuration.visible = visible;
        }
    }

    @Override
    public List<IColumn> getSortedColumns() {
        if (this._sortedColumns == null) {
            this._sortedColumns = new ArrayList<IColumn>();
        }
        return this._sortedColumns;
    }

    @Override
    public void setSortedColumns(List<IColumn> sortedColumns) {
        this._sortedColumns = sortedColumns;
        this.fireColumnOrderChanged();
    }

    @Override
    public int getColumnSortingPosition(IColumn column) {
        ColumnConfiguration configuration = this.getColumnConfiguration(column);
        return configuration.sortingPosition;
    }

    @Override
    public boolean getColumnSortingDirection(IColumn column) {
        ColumnConfiguration configuration = this.getColumnConfiguration(column);
        return configuration.sortingDirection;
    }

    @Override
    public void setSorting(IColumn column) {
        ColumnConfiguration conf = this.getColumnConfiguration(column);
        if (conf.sortingPosition == 0) {
            this.addShiftSorting();
            conf.sortingPosition = 1;
        } else if (conf.sortingDirection) {
            conf.sortingDirection = false;
        } else {
            conf.sortingDirection = true;
            this.remSorting(conf.sortingPosition);
            conf.sortingPosition = 0;
        }
        this.fireSortingChanged();
    }

    private void addShiftSorting() {
        for (ColumnConfiguration cconf : this._colConfigurations.values()) {
            if (cconf.sortingPosition <= 0) continue;
            ++cconf.sortingPosition;
        }
    }

    private void remSorting(int pos) {
        for (ColumnConfiguration cconf : this._colConfigurations.values()) {
            if (cconf.sortingPosition <= pos) continue;
            --cconf.sortingPosition;
        }
    }

    @Override
    public synchronized void addTableViewStateListener(ITableViewStateListener tvsl) {
        if (this._listeners == null) {
            this._listeners = new Vector<ITableViewStateListener>();
        }
        this._listeners.add(tvsl);
    }

    @Override
    public void removeTableViewStateListener(ITableViewStateListener tvsl) {
        if (this._listeners != null) {
            this._listeners.remove(tvsl);
        }
    }

    protected void fireRowHeightChanged(IRow row, int newHeight) {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.rowHeightChanged(row, newHeight);
            }
        }
    }

    protected void fireRowHeightModeChanged(IRow row, ITableViewState.RowHeightMode newMode) {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.rowHeightModeChanged(row, newMode);
            }
        }
    }

    protected void fireColumnWidthChanged(IColumn column, int newWidth) {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.columnWidthChanged(column, newWidth);
            }
        }
    }

    protected void fireColumnWidthsChanged() {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.columnWidthsChanged();
            }
        }
    }

    protected void fireColumnVisibilityChanged(IColumn column, boolean visible) {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.columnVisibilityChanged(column, visible);
            }
        }
    }

    protected void fireSortingChanged() {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.sortingChanged();
            }
        }
    }

    protected void fireColumnOrderChanged() {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.columnOrderChanged();
            }
        }
    }

    protected void fireCellStyleChanged(IRow row, IColumn column, ICellStyle cellStyle) {
        if (this._listeners != null) {
            for (ITableViewStateListener listener : this._listeners) {
                listener.cellStyleChanged(row, column, cellStyle);
            }
        }
    }

    @Override
    public int getMinimalRowHeight() {
        return this._minimalRowHeight;
    }

    @Override
    public void setMinimalRowHeight(int minimalRowHeight) {
        this._minimalRowHeight = minimalRowHeight;
    }

    @Override
    public int getMinimalColWidth() {
        return this._minimalColumnWidth;
    }

    @Override
    public void setMinimalColWidth(int minimalColumnWidth) {
        this._minimalColumnWidth = minimalColumnWidth;
    }

    @Override
    public ICellStyleProvider getCellStyleProvider() {
        return this._cellStyleProvider;
    }

    public void setCellStyleProvider(ICellStyleProvider cellStyleProvider) {
        if (this._cellStyleProvider != null) {
            this._cellStyleProvider.remCellStyleListener(this);
        }
        this._cellStyleProvider = cellStyleProvider;
        this._cellStyleProvider.addCellStyleListener(this);
    }

    @Override
    public ICellStyle getCellStyle(IRow row, IColumn column) {
        return this._cellStyleProvider.getCellStyle(row, column);
    }

    @Override
    public void cellStyleChanged(IRow row, IColumn column, ICellStyle style) {
        this.fireCellStyleChanged(row, column, style);
    }

    @Override
    public boolean columnResizingAllowed(IColumn column) {
        ColumnConfiguration conf = this.getColumnConfiguration(column);
        return conf.resizable;
    }

    @Override
    public void setColumnResizingAllowed(IColumn column, boolean resizingAllowed) {
        ColumnConfiguration conf = this.getColumnConfiguration(column);
        conf.resizable = resizingAllowed;
    }

    @Override
    public ITableViewState.ColumnResizeMode getColumnResizeMode() {
        return this._columnResizeMode;
    }

    @Override
    public void setColumnResizeMode(ITableViewState.ColumnResizeMode columnResizeMode) {
        this._columnResizeMode = columnResizeMode;
    }

    public class ColumnConfiguration {
        public double columnWidth;
        public boolean resizable = true;
        public boolean visible = true;
        public String id;
        public int sortingPosition;
        public boolean sortingDirection = true;
    }

    public class RowConfiguration {
        public ITableViewState.RowHeightMode heightMode;
        public int rowHeight;
    }
}

