/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IJaretTableCell;
import de.jaret.util.ui.table.model.IJaretTableModel;
import de.jaret.util.ui.table.model.IJaretTableSelection;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.JaretTableCellImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaretTableSelectionImpl
implements IJaretTableSelection {
    protected List<IRow> _rows = new ArrayList<IRow>();
    protected List<IColumn> _columns = new ArrayList<IColumn>();
    protected List<IJaretTableCell> _cells = new ArrayList<IJaretTableCell>();

    @Override
    public void clear() {
        this._rows.clear();
        this._columns.clear();
        this._cells.clear();
    }

    @Override
    public List<IRow> getSelectedRows() {
        return this._rows;
    }

    @Override
    public List<IColumn> getSelectedColumns() {
        return this._columns;
    }

    @Override
    public List<IJaretTableCell> getSelectedCells() {
        return this._cells;
    }

    @Override
    public void addRow(IRow row) {
        this._rows.add(row);
    }

    @Override
    public void remRow(IRow row) {
        this._rows.remove(row);
    }

    @Override
    public void addColumn(IColumn column) {
        this._columns.add(column);
    }

    @Override
    public void remColumn(IColumn column) {
        this._columns.remove(column);
    }

    @Override
    public void addCell(IJaretTableCell cell) {
        this._cells.add(cell);
    }

    @Override
    public void remCell(IJaretTableCell cell) {
        this._cells.remove(cell);
    }

    @Override
    public boolean isEmpty() {
        return this._rows.size() == 0 && this._columns.size() == 0 && this._cells.size() == 0;
    }

    @Override
    public Set<IJaretTableCell> getAllSelectedCells(IJaretTableModel model) {
        JaretTableCellImpl cell;
        int i;
        HashSet<IJaretTableCell> set = new HashSet<IJaretTableCell>();
        for (IRow row : this._rows) {
            for (i = 0; i < model.getColumnCount(); ++i) {
                cell = new JaretTableCellImpl(row, model.getColumn(i));
                set.add(cell);
            }
        }
        for (IColumn col : this._columns) {
            for (i = 0; i < model.getRowCount(); ++i) {
                cell = new JaretTableCellImpl(model.getRow(i), col);
                set.add(cell);
            }
        }
        set.addAll(this._cells);
        return set;
    }
}

