/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IJaretTableCell;
import de.jaret.util.ui.table.model.IJaretTableSelection;
import de.jaret.util.ui.table.model.IJaretTableSelectionModel;
import de.jaret.util.ui.table.model.IJaretTableSelectionModelListener;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.JaretTableSelectionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class JaretTableSelectionModelImpl
implements IJaretTableSelectionModel {
    protected List<IJaretTableSelectionModelListener> _listeners;
    protected boolean _fullRowSelectionAllowed = true;
    protected boolean _fullColumnSelectionAllowed = true;
    protected boolean _cellSelectioAllowed = true;
    protected boolean _multipleSelectionAllowed = true;
    protected boolean _onlyRowSelectionAllowed = false;
    protected IJaretTableSelection _selection = new JaretTableSelectionImpl();

    public void clearSelection() {
        ArrayList<IRow> l = new ArrayList<IRow>();
        l.addAll(this._selection.getSelectedRows());
        for (IRow row : l) {
            this.remSelectedRow(row);
        }
        ArrayList<IColumn> c = new ArrayList<IColumn>();
        c.addAll(this._selection.getSelectedColumns());
        for (IColumn col : c) {
            this.remSelectedColumn(col);
        }
        ArrayList<IJaretTableCell> t = new ArrayList<IJaretTableCell>();
        t.addAll(this._selection.getSelectedCells());
        for (IJaretTableCell cell : t) {
            this.remSelectedCell(cell);
        }
    }

    public boolean isFullRowSelectionAllowed() {
        return this._fullRowSelectionAllowed;
    }

    public void setFullRowSelectionAllowed(boolean allowed) {
        this._fullRowSelectionAllowed = allowed;
    }

    public boolean isFullColumnSelectionAllowed() {
        return this._fullColumnSelectionAllowed;
    }

    public void setFullColumnSelectionAllowed(boolean allowed) {
        this._fullColumnSelectionAllowed = allowed;
    }

    public boolean isCellSelectionAllowed() {
        return this._cellSelectioAllowed;
    }

    public void setCellSelectionAllowed(boolean allowed) {
        this._cellSelectioAllowed = allowed;
    }

    public boolean isMultipleSelectionAllowed() {
        return this._multipleSelectionAllowed;
    }

    public void setMultipleSelectionAllowed(boolean allowed) {
        this._multipleSelectionAllowed = allowed;
    }

    public void addSelectedRow(IRow row) {
        if (!this._selection.getSelectedRows().contains(row)) {
            this._selection.addRow(row);
            this.fireRowSelectionAdded(row);
        }
    }

    public void remSelectedRow(IRow row) {
        if (this._selection.getSelectedRows().contains(row)) {
            this._selection.remRow(row);
            this.fireRowSelectionRemoved(row);
        }
    }

    public void addSelectedColumn(IColumn column) {
        if (!this._selection.getSelectedColumns().contains(column)) {
            this._selection.addColumn(column);
            this.fireColumnSelectionAdded(column);
        }
    }

    public void remSelectedColumn(IColumn column) {
        if (this._selection.getSelectedColumns().contains(column)) {
            this._selection.remColumn(column);
            this.fireColumnSelectionRemoved(column);
        }
    }

    public void addSelectedCell(IJaretTableCell cell) {
        if (!this._selection.getSelectedCells().contains(cell)) {
            this._selection.addCell(cell);
            this.fireCellSelectionAdded(cell);
        }
    }

    public void remSelectedCell(IJaretTableCell cell) {
        if (this._selection.getSelectedCells().contains(cell)) {
            this._selection.remCell(cell);
            this.fireCellSelectionRemoved(cell);
        }
    }

    public IJaretTableSelection getSelection() {
        return this._selection;
    }

    private void fireRowSelectionAdded(IRow row) {
        if (this._listeners != null) {
            for (IJaretTableSelectionModelListener listener : this._listeners) {
                listener.rowSelectionAdded(row);
            }
        }
    }

    private void fireRowSelectionRemoved(IRow row) {
        if (this._listeners != null) {
            for (IJaretTableSelectionModelListener listener : this._listeners) {
                listener.rowSelectionRemoved(row);
            }
        }
    }

    private void fireColumnSelectionAdded(IColumn column) {
        if (this._listeners != null) {
            for (IJaretTableSelectionModelListener listener : this._listeners) {
                listener.columnSelectionAdded(column);
            }
        }
    }

    private void fireColumnSelectionRemoved(IColumn column) {
        if (this._listeners != null) {
            for (IJaretTableSelectionModelListener listener : this._listeners) {
                listener.columnSelectionRemoved(column);
            }
        }
    }

    private void fireCellSelectionAdded(IJaretTableCell cell) {
        if (this._listeners != null) {
            for (IJaretTableSelectionModelListener listener : this._listeners) {
                listener.cellSelectionAdded(cell);
            }
        }
    }

    private void fireCellSelectionRemoved(IJaretTableCell cell) {
        if (this._listeners != null) {
            for (IJaretTableSelectionModelListener listener : this._listeners) {
                listener.cellSelectionRemoved(cell);
            }
        }
    }

    public synchronized void addTableSelectionModelListener(IJaretTableSelectionModelListener jtsm) {
        if (this._listeners == null) {
            this._listeners = new Vector<IJaretTableSelectionModelListener>();
        }
        this._listeners.add(jtsm);
    }

    public void removeTableSelectionModelListener(IJaretTableSelectionModelListener jtsm) {
        if (this._listeners != null) {
            this._listeners.remove(jtsm);
        }
    }

    public boolean isOnlyRowSelectionAllowed() {
        return this._onlyRowSelectionAllowed;
    }

    public void setOnlyRowSelectionAllowed(boolean allowed) {
        this._onlyRowSelectionAllowed = allowed;
    }
}

