/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.ui.table.model.AbstractColumn;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IPropColAccessor;
import de.jaret.util.ui.table.model.IRow;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropCol
extends AbstractColumn
implements IColumn {
    protected String _id;
    protected String _headerLabel;
    protected String _prop;
    protected String[] _propPath;
    protected boolean _supportSorting = true;
    protected boolean _editable = true;
    protected Class<?> _contentClass;
    protected IPropColAccessor _accessor = null;

    public PropCol(String id, String label, String prop, Class<?> contentClass, IPropColAccessor accessor) {
        this._headerLabel = label;
        this._id = id;
        this._prop = prop;
        this.initPropPath();
        this._contentClass = contentClass;
        this._accessor = accessor;
    }

    public PropCol(String id, String label, String prop, Class<?> contentClass) {
        this(id, label, prop, contentClass, null);
    }

    public PropCol(String id, String label, String prop) {
        this(id, label, prop, null);
    }

    private void initPropPath() {
        StringTokenizer tokenizer = new StringTokenizer(this._prop, ".");
        ArrayList<String> l = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            l.add(tokenizer.nextToken());
        }
        this._propPath = l.toArray(new String[0]);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getHeaderLabel() {
        return this._headerLabel;
    }

    @Override
    public Object getValue(IRow row) {
        if (row != null) {
            try {
                Object base = row;
                for (int i = 0; i < this._propPath.length; ++i) {
                    String propName = this._propPath[i];
                    Method getter = base.getClass().getMethod("get" + propName, new Class[0]);
                    base = getter.invoke(base, new Object[0]);
                }
                if (this._accessor == null) {
                    return base;
                }
                return this._accessor.getValue(base);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Class<?> getContentClass(IRow row) {
        if (row != null) {
            try {
                Object base = row;
                for (int i = 0; i < this._propPath.length; ++i) {
                    String propName = this._propPath[i];
                    Method getter = base.getClass().getMethod("get" + propName, new Class[0]);
                    if (i == this._propPath.length - 1) {
                        return getter.getReturnType();
                    }
                    base = getter.invoke(base, new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected boolean isRealModification(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return true;
        }
        if (o2 != null && o1 == null) {
            return true;
        }
        return !o1.equals(o2);
    }

    @Override
    public void setValue(IRow row, Object value) {
        Object oldValue = this.getValue(row);
        if (this.isRealModification(oldValue, value)) {
            try {
                Object base = row;
                for (int i = 0; i < this._propPath.length - 1; ++i) {
                    String propName = this._propPath[i];
                    Method getter = base.getClass().getMethod("get" + propName, new Class[0]);
                    base = getter.invoke(base, new Object[0]);
                }
                if (this._accessor == null) {
                    Class<Object> clazz;
                    if (value == null) {
                        clazz = this.getContentClass(row);
                    } else {
                        clazz = value.getClass();
                        if (clazz.equals(Boolean.class)) {
                            clazz = Boolean.TYPE;
                        } else if (clazz.equals(Integer.class)) {
                            clazz = Integer.TYPE;
                        } else if (clazz.equals(Double.class)) {
                            clazz = Double.TYPE;
                        }
                    }
                    Method setter = base.getClass().getMethod("set" + this._propPath[this._propPath.length - 1], clazz);
                    setter.invoke(base, value);
                } else {
                    this._accessor.setValue(base, value);
                }
                this.fireValueChanged(row, this, oldValue, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not set value " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public int compare(IRow r1, IRow r2) {
        Object val1 = this.getValue(r1);
        Object val2 = this.getValue(r2);
        if (val1 == null && val2 == null) {
            return 0;
        }
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        if (val1.getClass().equals(val2.getClass()) && val1 instanceof Comparable) {
            return ((Comparable)val1).compareTo(val2);
        }
        return val1.toString().compareTo(val2.toString());
    }

    @Override
    public boolean supportsSorting() {
        return this._supportSorting;
    }

    public void setSupportSorting(boolean supportSorting) {
        this._supportSorting = supportSorting;
    }

    @Override
    public Class<?> getContentClass() {
        return this._contentClass;
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }
}

