/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model;

import de.jaret.util.misc.PropertyObservable;
import de.jaret.util.ui.table.model.AbstractJaretTableModel;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IHierarchicalJaretTableModel;
import de.jaret.util.ui.table.model.IHierarchicalTableViewState;
import de.jaret.util.ui.table.model.IHierarchicalTableViewStateListener;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.ITableNode;
import de.jaret.util.ui.table.model.ITableNodeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdHierarchicalTableModel
extends AbstractJaretTableModel
implements IHierarchicalTableViewStateListener,
ITableNodeListener,
PropertyChangeListener {
    protected List<ITableNode> _rows;
    protected IHierarchicalJaretTableModel _hModel;
    protected IHierarchicalTableViewState _hvs;
    protected List<IColumn> _cols = new ArrayList<IColumn>();

    public StdHierarchicalTableModel(IHierarchicalJaretTableModel hModel, IHierarchicalTableViewState hvs) {
        this._hModel = hModel;
        this._hvs = hvs;
        this._hvs.addHierarchicalViewstateListener(this);
        this.updateRowList();
    }

    private void registerPropChange(ITableNode node) {
        if (node instanceof PropertyObservable) {
            ((PropertyObservable)node).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void deRegisterPropChange(ITableNode node) {
        if (node instanceof PropertyObservable) {
            ((PropertyObservable)node).removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void updateRowList() {
        this._rows = new ArrayList<ITableNode>();
        this.updateRowList(this._rows, 0, this._hModel.getRootNode(), true);
    }

    private void updateRowList(List<ITableNode> rows, int level, ITableNode node, boolean visible) {
        if (visible) {
            rows.add(node);
            this.registerPropChange(node);
        }
        node.addTableNodeListener(this);
        node.setLevel(level);
        for (ITableNode n : node.getChildren()) {
            this.updateRowList(rows, level + 1, n, this._hvs.isExpanded(node) && visible);
        }
    }

    public boolean moreSiblings(ITableNode node, int level) {
        int idx = this._rows.indexOf(node);
        if (idx == -1) {
            throw new RuntimeException();
        }
        if (node.getLevel() == level) {
            return this.getNextSibling(node) != null;
        }
        ITableNode n = node;
        for (int l = node.getLevel(); l > level + 1; --l) {
            n = this.getParent(n);
        }
        return this.getNextSibling(n) != null;
    }

    public ITableNode getNextSibling(ITableNode node) {
        ITableNode parent = this.getParent(node);
        if (parent == null) {
            return null;
        }
        int idx = parent.getChildren().indexOf(node);
        if (parent.getChildren().size() > idx + 1) {
            return parent.getChildren().get(idx + 1);
        }
        return null;
    }

    private ITableNode getParent(ITableNode node) {
        int idx = this._rows.indexOf(node);
        if (idx == -1) {
            return null;
        }
        for (int i = idx - 1; i >= 0; --i) {
            ITableNode n = this._rows.get(i);
            if (!n.getChildren().contains(node)) continue;
            return n;
        }
        return null;
    }

    public boolean isVisible(ITableNode node) {
        return this.getIdxForNode(node) != -1;
    }

    private int getIdxForNode(ITableNode node) {
        return this._rows.indexOf(node);
    }

    @Override
    public IRow getRow(int rowIdx) {
        return this._rows.get(rowIdx);
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    @Override
    public void nodeAdded(ITableNode parent, ITableNode newChild) {
        newChild.addTableNodeListener(this);
        if (this._hvs.isExpanded(parent)) {
            HashMap<ITableNode, Integer> map = new HashMap<ITableNode, Integer>();
            this.posForNode(parent, map);
            int pos = (Integer)map.get(newChild);
            this._rows.add(pos, newChild);
            this.fireRowAdded(pos, newChild);
            ArrayList<ITableNode> toAdd = new ArrayList<ITableNode>();
            this.enumerateChildren(newChild, toAdd);
            ++pos;
            for (ITableNode tableNode : toAdd) {
                this._rows.add(pos, tableNode);
                this.fireRowAdded(pos, tableNode);
                ++pos;
            }
        }
    }

    private void enumerateChildren(ITableNode node, List<ITableNode> children) {
        if (node.getChildren() != null && this._hvs.isExpanded(node)) {
            for (ITableNode tableNode : node.getChildren()) {
                children.add(tableNode);
                this.enumerateChildren(tableNode, children);
            }
        }
    }

    private int posForNode(ITableNode node, Map<ITableNode, Integer> map) {
        int idx = this.getIdxForNode(node);
        int count = node.getChildren().size();
        int inserted = 0;
        for (int i = 0; i < count; ++i) {
            ITableNode n = node.getChildren().get(i);
            map.put(n, idx + 1 + inserted);
            ++inserted;
            if (!this._hvs.isExpanded(n) || n.getChildren().size() <= 0) continue;
            inserted += this.posForNode(n, map);
        }
        return inserted;
    }

    @Override
    public void nodeRemoved(ITableNode parent, ITableNode removedChild) {
        removedChild.removeTableNodeListener(this);
        if (this._hvs.isExpanded(parent)) {
            this._rows.remove(removedChild);
            this.fireRowRemoved(removedChild);
            ArrayList<ITableNode> toRemove = new ArrayList<ITableNode>();
            this.enumerateChildren(removedChild, toRemove);
            for (ITableNode tableNode : toRemove) {
                this._rows.remove(tableNode);
                this.fireRowRemoved(tableNode);
            }
        }
    }

    @Override
    public void nodeExpanded(ITableNode node) {
        this.nodeExpanded2(node);
    }

    private int nodeExpanded2(ITableNode node) {
        int idx = this.getIdxForNode(node);
        int count = node.getChildren().size();
        int inserted = 0;
        for (int i = 0; i < count; ++i) {
            ITableNode n = node.getChildren().get(i);
            int newIdx = idx + 1 + inserted;
            this._rows.add(newIdx, n);
            ++inserted;
            this.fireRowAdded(newIdx, n);
            this.registerPropChange(n);
            if (!this._hvs.isExpanded(n) || n.getChildren().size() <= 0) continue;
            inserted += this.nodeExpanded2(n);
        }
        return inserted;
    }

    @Override
    public void nodeFolded(ITableNode node) {
        int count = node.getChildren().size();
        for (int i = 0; i < count; ++i) {
            int idx2;
            ITableNode n = node.getChildren().get(i);
            if (this._hvs.isExpanded(n) && n.getChildren().size() > 0) {
                this.nodeFolded(n);
            }
            if ((idx2 = this.getIdxForNode(n)) != -1) {
                this._rows.remove(idx2);
            }
            this.fireRowRemoved(n);
            this.deRegisterPropChange(n);
        }
    }

    @Override
    public int getColumnCount() {
        return this._cols.size();
    }

    @Override
    public IColumn getColumn(int idx) {
        return this._cols.get(idx);
    }

    @Override
    public void addColumn(IColumn column) {
        this._cols.add(column);
        this.fireColumnAdded(this._cols.size() - 1, column);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof IRow) {
            this.fireRowChanged((IRow)evt.getSource());
        }
    }
}

