/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.model.simple;

import de.jaret.util.ui.table.model.AbstractJaretTableModel;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.simple.SimpleColumn;
import de.jaret.util.ui.table.model.simple.SimpleRow;
import java.util.HashMap;
import java.util.Map;

public class SimpleJaretTableModel
extends AbstractJaretTableModel {
    private Map<Integer, SimpleColumn> _cols = new HashMap<Integer, SimpleColumn>();
    private Map<Integer, SimpleRow> _rows = new HashMap<Integer, SimpleRow>();
    private int _colCount = -1;
    private int _rowCount = -1;

    public void setValueAt(int colIdx, int rowIdx, Object value) {
        IColumn col = this.getColumn(colIdx);
        IRow row = this.getRow(rowIdx);
        col.setValue(row, value);
    }

    public Object getValueAt(int colIdx, int rowIdx) {
        IColumn col = this.getColumn(colIdx);
        return col.getValue(this.getRow(rowIdx));
    }

    public void setHeaderLabel(int colIdx, String label) {
        ((SimpleColumn)this.getColumn(colIdx)).setHeaderLabel(label);
    }

    public IColumn getColumn(int idx) {
        SimpleColumn col = this._cols.get(idx);
        if (col == null) {
            col = new SimpleColumn(idx, this);
            this._cols.put(idx, col);
            this._colCount = Math.max(this._colCount, idx);
        }
        return col;
    }

    public int getColumnCount() {
        return this._colCount + 1;
    }

    public IRow getRow(int idx) {
        SimpleRow row = this._rows.get(idx);
        if (row == null) {
            row = new SimpleRow(idx);
            this._rows.put(idx, row);
            this._rowCount = Math.max(this._rowCount, idx);
        }
        return row;
    }

    public int getRowCount() {
        return this._rowCount + 1;
    }

    public void cellChanged(IRow row, SimpleColumn column, Object value) {
        this.fireCellChanged(row, column);
    }

    public void addColumn(IColumn column) {
    }
}

