/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.print;

import de.jaret.util.ui.table.JaretTablePrinter;
import de.jaret.util.ui.table.print.JaretTablePrintConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class JaretTablePrintDialog
extends Dialog {
    protected static PrinterData _printerData;
    protected int _pIdx = -1;
    protected String[] _printers;
    protected PrinterData[] _pdatas;
    protected CCombo _printerCombo;
    protected JaretTablePrintConfiguration _configuration;
    protected Button _repeatHeader;
    protected Label _pagesLabel;
    protected JaretTablePrinter _tablePrinter;

    public JaretTablePrintDialog(Shell parentShell, String printerName, JaretTablePrinter tablePrinter, JaretTablePrintConfiguration printConfiguration) {
        super(parentShell);
        this._tablePrinter = tablePrinter;
        this._configuration = printConfiguration;
        if (this._configuration == null) {
            this._configuration = new JaretTablePrintConfiguration("table", false, 1.0);
        }
        if (printerName == null && _printerData != null) {
            printerName = JaretTablePrintDialog._printerData.name;
        }
        this._pdatas = Printer.getPrinterList();
        this._printers = new String[this._pdatas.length];
        int stdIdx = -1;
        for (int i = 0; i < this._pdatas.length; ++i) {
            PrinterData pd = this._pdatas[i];
            this._printers[i] = pd.name;
            if (printerName != null && pd.name.equals(printerName)) {
                this._pIdx = i;
            }
            if (!pd.name.equals(Printer.getDefaultPrinterData().name)) continue;
            stdIdx = i;
        }
        if (this._pIdx == -1) {
            _printerData = Printer.getDefaultPrinterData();
            this._pIdx = stdIdx;
        } else {
            _printerData = this._pdatas[this._pIdx];
        }
    }

    public void setRowLimit(int limit) {
        this._configuration.setRowLimit(limit);
    }

    public void setColLimit(int limit) {
        this._configuration.setColLimit(limit);
    }

    public JaretTablePrintConfiguration getConfiguration() {
        return this._configuration;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Print");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridData gd1 = new GridData(1808);
        dialogArea.setLayoutData((Object)gd1);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        dialogArea.setLayout((Layout)gl);
        this.createPrinterSelection(dialogArea);
        Composite parameterArea = new Composite(dialogArea, 0);
        GridData gd = new GridData(1808);
        parameterArea.setLayoutData((Object)gd);
        this.createParameterArea(parameterArea);
        return dialogArea;
    }

    protected void okPressed() {
        _printerData = this._pdatas[this._printerCombo.getSelectionIndex()];
        super.okPressed();
    }

    private void createPrinterSelection(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new RowLayout());
        this._printerCombo = new CCombo(area, 2056);
        this._printerCombo.setItems(this._printers);
        this._printerCombo.select(this._pIdx);
        Button select = new Button(area, 8);
        select.setText("Configure");
        select.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PrintDialog pd = new PrintDialog(Display.getCurrent().getActiveShell());
                PrinterData pdata = pd.open();
                if (pdata != null) {
                    _printerData = pdata;
                    this.select(_printerData);
                }
            }

            private void select(PrinterData printerData) {
                for (int i = 0; i < JaretTablePrintDialog.this._pdatas.length; ++i) {
                    PrinterData pd = JaretTablePrintDialog.this._pdatas[i];
                    if (!pd.name.equals(printerData.name)) continue;
                    JaretTablePrintDialog.this._printerCombo.select(i);
                    break;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createParameterArea(Composite parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        parent.setLayout((Layout)gl);
        this._repeatHeader = new Button(parent, 32);
        this._repeatHeader.setSelection(this._configuration.getRepeatHeader());
        this._repeatHeader.setText("Repeat header");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this._repeatHeader.setLayoutData((Object)gd);
        final Label scaleText = new Label(parent, 131072);
        scaleText.setText(this.getScaleText());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        scaleText.setLayoutData((Object)gd);
        final Scale scale = new Scale(parent, 256);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        scale.setLayoutData((Object)gd);
        scale.setMaximum(1000);
        scale.setMinimum(10);
        scale.setSelection((int)(this._configuration.getScale() * 100.0));
        scale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent ev) {
                int val = scale.getSelection();
                double s = (double)val / 100.0;
                JaretTablePrintDialog.this._configuration.setScale(s);
                scaleText.setText(JaretTablePrintDialog.this.getScaleText());
                JaretTablePrintDialog.this.updateConf();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this._pagesLabel = new Label(parent, 131072);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this._pagesLabel.setLayoutData((Object)gd);
        _printerData = this._pdatas[this._printerCombo.getSelectionIndex()];
        Printer printer = new Printer(_printerData);
        this._tablePrinter.setPrinter(printer);
        Point pages = this._tablePrinter.calculatePageCount(this._configuration);
        printer.dispose();
        this._pagesLabel.setText(this.getPagesText(pages));
    }

    private String getScaleText() {
        int pc = (int)(this._configuration.getScale() * 100.0);
        return Integer.toString(pc) + "%";
    }

    private String getPagesText(Point pages) {
        return "X: " + pages.x + " Y: " + pages.y + " (" + pages.x * pages.y + " pages)";
    }

    private void updateConf() {
        this._configuration.setRepeatHeader(this._repeatHeader.getSelection());
        Printer printer = new Printer(_printerData);
        this._tablePrinter.setPrinter(printer);
        Point pages = this._tablePrinter.calculatePageCount(this._configuration);
        printer.dispose();
        this._pagesLabel.setText(this.getPagesText(pages));
    }

    public PrinterData getPrinterData() {
        return _printerData;
    }
}

