/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class BarCellRenderer
extends CellRendererBase
implements ICellRenderer {
    protected int _min = 0;
    protected int _max = 100;
    protected Color _barColor;

    public BarCellRenderer(Printer printer) {
        super(printer);
        if (printer != null) {
            this._barColor = printer.getSystemColor(4);
        }
    }

    public BarCellRenderer() {
        super(null);
        this._barColor = Display.getCurrent().getSystemColor(4);
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int max) {
        this._max = max;
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int min) {
        this._min = min;
    }

    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        this.drawBackground(gc, drawingArea, cellStyle, selected, printing);
        Rectangle drect = this.drawBorder(gc, cellStyle, drawingArea, printing);
        Rectangle rect = this.applyInsets(drect);
        Object value = column.getValue(row);
        if (value instanceof Integer) {
            int val = (Integer)value;
            double pixPer = (double)rect.width / (double)(this._max - this._min);
            int correctedValue = val - this._min;
            int drawingWidth = (int)((double)correctedValue * pixPer);
            Color bg = gc.getBackground();
            gc.setBackground(this._barColor);
            gc.fillRectangle(rect.x, rect.y, drawingWidth, rect.height);
            gc.setBackground(bg);
        } else {
            Color bg = gc.getBackground();
            gc.setBackground(Display.getCurrent().getSystemColor(3));
            gc.fillRectangle(rect);
            gc.setBackground(bg);
        }
        if (drawFocus) {
            this.drawFocus(gc, drawingArea);
        }
        this.drawSelection(gc, drawingArea, cellStyle, selected, printing);
    }

    public void dispose() {
    }

    public ICellRenderer createPrintRenderer(Printer printer) {
        return new BarCellRenderer(printer);
    }
}

