/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.ResourceImageDescriptor;
import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanCellRenderer
extends CellRendererBase
implements ICellRenderer {
    protected String _checkedRscName = "/de/jaret/util/ui/table/resource/checked.gif";
    protected String _uncheckedRscName = "/de/jaret/util/ui/table/resource/unchecked.gif";
    protected static final String CHECKED = "checked";
    protected static final String UNCHECKED = "unchecked";
    private ImageRegistry _imageRegistry;

    public BooleanCellRenderer(Printer printer) {
        super(printer);
    }

    public BooleanCellRenderer() {
        super(null);
    }

    public BooleanCellRenderer(Printer printer, String checkedRscName, String uncheckedRscName) {
        super(printer);
        this._checkedRscName = checkedRscName;
        this._uncheckedRscName = uncheckedRscName;
    }

    public BooleanCellRenderer(String checkedRscName, String uncheckedRscName) {
        super(null);
        this._checkedRscName = checkedRscName;
        this._uncheckedRscName = uncheckedRscName;
    }

    @Override
    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        this.drawBackground(gc, drawingArea, cellStyle, selected, printing);
        Rectangle drect = this.drawBorder(gc, cellStyle, drawingArea, printing);
        Rectangle rect = this.applyInsets(drect);
        Object value = column.getValue(row);
        if (value instanceof Boolean) {
            Image img = null;
            img = (Boolean)value != false ? this.getImageRegistry().get(CHECKED) : this.getImageRegistry().get(UNCHECKED);
            int x = rect.x + (rect.width - this.scaleX(img.getBounds().width)) / 2;
            int y = rect.y + (rect.height - this.scaleY(img.getBounds().height)) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, this.scaleX(img.getBounds().width), this.scaleY(img.getBounds().height));
        } else {
            Color bg = gc.getBackground();
            gc.setBackground(Display.getCurrent().getSystemColor(11));
            gc.fillRectangle(rect);
            gc.setBackground(bg);
        }
        if (drawFocus) {
            this.drawFocus(gc, drect);
        }
        this.drawSelection(gc, drawingArea, cellStyle, selected, printing);
    }

    @Override
    public int getPreferredWidth(List<IRow> rows, IColumn column) {
        return this.getImageRegistry().get((String)CHECKED).getBounds().width;
    }

    @Override
    public int getPreferredHeight(GC gc, ICellStyle cellStyle, int width, IRow row, IColumn column) {
        return this.getImageRegistry().get((String)CHECKED).getBounds().height;
    }

    private ImageRegistry getImageRegistry() {
        if (this._imageRegistry == null) {
            this._imageRegistry = new ImageRegistry();
            ResourceImageDescriptor imgDesc = new ResourceImageDescriptor(this._checkedRscName, this.getClass());
            this._imageRegistry.put(CHECKED, imgDesc.createImage());
            imgDesc = new ResourceImageDescriptor(this._uncheckedRscName, this.getClass());
            this._imageRegistry.put(UNCHECKED, imgDesc.createImage());
        }
        return this._imageRegistry;
    }

    @Override
    public void dispose() {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
    }

    @Override
    public ICellRenderer createPrintRenderer(Printer printer) {
        return new BooleanCellRenderer(printer, this._checkedRscName, this._uncheckedRscName);
    }
}

