/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.swt.ColorManager;
import de.jaret.util.swt.FontManager;
import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.IBorderConfiguration;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import de.jaret.util.ui.table.renderer.RendererBase;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CellRendererBase
extends RendererBase
implements ICellRenderer {
    protected static final Color SELECTIONCOLOR = Display.getCurrent().getSystemColor(15);
    private static final int SELECTIONALPHA = 150;
    protected static final int FOCUSINSETS = 2;
    protected static final RGB WHITERGB = new RGB(255, 255, 255);
    protected static final RGB BLACKRGB = new RGB(0, 0, 0);
    protected int _inset = 2;

    public CellRendererBase(Printer printer) {
        super(printer);
    }

    @Override
    public int getPreferredWidth(List<IRow> rows, IColumn column) {
        return -1;
    }

    @Override
    public int getPreferredHeight(GC gc, ICellStyle cellStyle, int width, IRow row, IColumn column) {
        return -1;
    }

    @Override
    public String getTooltip(JaretTable jaretTable, Rectangle drawingArea, IRow row, IColumn column, int x, int y) {
        return null;
    }

    protected int getInnerWidth(int width, ICellStyle cellStyle) {
        int sum = this._inset * 2 + cellStyle.getBorderConfiguration().getBorderLeft() + cellStyle.getBorderConfiguration().getBorderRight() - 1;
        return width - sum;
    }

    protected int getVerticalSpacesSum(ICellStyle cellStyle) {
        return this._inset * 2 + cellStyle.getBorderConfiguration().getBorderTop() + cellStyle.getBorderConfiguration().getBorderBottom() - 1;
    }

    protected void drawFocus(GC gc, Rectangle drawingArea) {
        Color bg = gc.getBackground();
        Color fg = gc.getForeground();
        gc.setForeground(Display.getCurrent().getSystemColor(2));
        gc.drawFocus(drawingArea.x + 2, drawingArea.y + 2, drawingArea.width - 4, drawingArea.height - 4 - 1);
        gc.setForeground(fg);
        gc.setBackground(bg);
    }

    protected Rectangle applyInsets(Rectangle rect) {
        int d = this._inset;
        return new Rectangle(rect.x + d, rect.y + d, rect.width - 2 * d, rect.height - 2 * d);
    }

    protected Rectangle drawBorder(GC gc, ICellStyle cellStyle, Rectangle drawingArea, boolean printing) {
        int lw;
        IBorderConfiguration borderConfiguration = cellStyle.getBorderConfiguration();
        int x = drawingArea.x;
        int y = drawingArea.y;
        int width = drawingArea.width;
        int height = drawingArea.height;
        Color fg = gc.getForeground();
        gc.setForeground(this.getBorderColor(cellStyle, printing));
        int lineWidth = gc.getLineWidth();
        if (borderConfiguration.getBorderLeft() > 0) {
            lw = this.scaleX(borderConfiguration.getBorderLeft());
            gc.setLineWidth(lw);
            gc.drawLine(drawingArea.x, drawingArea.y, drawingArea.x, drawingArea.y + drawingArea.height);
            x += lw;
            width -= lw;
        }
        if (borderConfiguration.getBorderRight() > 0) {
            lw = this.scaleX(borderConfiguration.getBorderRight());
            gc.setLineWidth(lw);
            gc.drawLine(drawingArea.x + drawingArea.width, drawingArea.y, drawingArea.x + drawingArea.width, drawingArea.y + drawingArea.height);
            width -= lw;
        }
        if (borderConfiguration.getBorderTop() > 0) {
            lw = this.scaleY(borderConfiguration.getBorderTop());
            gc.setLineWidth(lw);
            gc.drawLine(drawingArea.x, drawingArea.y, drawingArea.x + drawingArea.width - 1, drawingArea.y);
            y += lw;
            height -= lw;
        }
        if (borderConfiguration.getBorderBottom() > 0) {
            lw = this.scaleY(borderConfiguration.getBorderBottom());
            gc.setLineWidth(lw);
            gc.drawLine(drawingArea.x, drawingArea.y + drawingArea.height, drawingArea.x + drawingArea.width, drawingArea.y + drawingArea.height);
            height -= lw;
        }
        gc.setLineWidth(lineWidth);
        gc.setForeground(fg);
        return new Rectangle(x, y, width, height);
    }

    protected void drawBackground(GC gc, Rectangle area, ICellStyle style, boolean selected, boolean printing) {
        Color c = gc.getBackground();
        Color bg = this.getBackgroundColor(style, printing);
        gc.setBackground(bg);
        gc.fillRectangle(area);
        gc.setBackground(c);
    }

    protected void drawSelection(GC gc, Rectangle area, ICellStyle style, boolean selected, boolean printing) {
        Color c = gc.getBackground();
        if (selected && !printing) {
            Color bg = SELECTIONCOLOR;
            gc.setBackground(bg);
            int alpha = gc.getAlpha();
            gc.setAlpha(150);
            gc.fillRectangle(area);
            gc.setAlpha(alpha);
            gc.setBackground(c);
        }
    }

    protected void drawCommentMarker(GC gc, Rectangle area, Color color, int size) {
        Color bg = gc.getBackground();
        gc.setBackground(color);
        gc.fillRectangle(area.x + area.width - size, area.y, size, size);
        gc.setBackground(bg);
    }

    protected boolean isInCommentMarkerArea(Rectangle area, int size, int x, int y) {
        Rectangle r = new Rectangle(area.x + area.width - size, area.y, size, size);
        return r.contains(x, y);
    }

    protected Color getBackgroundColor(ICellStyle style, boolean printing) {
        Display device = printing ? this._printer : Display.getCurrent();
        ColorManager cm = ColorManager.getColorManager((Device)device);
        Color bg = cm.getColor(style.getBackgroundColor() != null ? style.getBackgroundColor() : WHITERGB);
        return bg;
    }

    protected Color getForegroundColor(ICellStyle style, boolean printing) {
        Display device = printing ? this._printer : Display.getCurrent();
        ColorManager cm = ColorManager.getColorManager((Device)device);
        Color bg = cm.getColor(style.getForegroundColor() != null ? style.getForegroundColor() : BLACKRGB);
        return bg;
    }

    protected Color getBorderColor(ICellStyle style, boolean printing) {
        Display device = printing ? this._printer : Display.getCurrent();
        ColorManager cm = ColorManager.getColorManager((Device)device);
        Color bg = cm.getColor(style.getBorderColor() != null ? style.getBorderColor() : new RGB(0, 0, 0));
        return bg;
    }

    protected Font getFont(ICellStyle style, boolean printing, Font defaultFont) {
        Display device = printing ? this._printer : Display.getCurrent();
        FontManager fm = FontManager.getFontManager((Device)device);
        Font f = style.getFont() != null ? fm.getFont(style.getFont()) : defaultFont;
        return f;
    }
}

