/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.ResourceImageDescriptor;
import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImageRenderer
extends CellRendererBase
implements ICellRenderer {
    protected Map<Class, String> _keyMap = new HashMap<Class, String>();
    private ImageRegistry _imageRegistry;

    public ClassImageRenderer(Printer printer) {
        super(printer);
    }

    public ClassImageRenderer() {
        super(null);
    }

    public void addClassImageDescriptorMapping(Class<?> clazz, String key, ImageDescriptor imageDescriptor) {
        this.getImageRegistry().put(key, imageDescriptor);
        this._keyMap.put(clazz, key);
    }

    public void addClassRessourceNameMapping(Class<?> clazz, String key, String ressourceName) {
        ResourceImageDescriptor imgDesc = new ResourceImageDescriptor(ressourceName, this.getClass());
        this.addClassImageDescriptorMapping(clazz, key, (ImageDescriptor)imgDesc);
    }

    protected String getKeyForClass(Class<?> clazz) {
        String result = this._keyMap.get(clazz);
        if (result != null) {
            return result;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            result = this._keyMap.get(interfaces[i]);
            if (result == null) continue;
            return result;
        }
        Class<?> sc = clazz.getSuperclass();
        if (sc != null) {
            result = this.getKeyForClass(sc);
        }
        return result;
    }

    @Override
    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        this.drawBackground(gc, drawingArea, cellStyle, selected, printing);
        Rectangle drect = this.drawBorder(gc, cellStyle, drawingArea, printing);
        Rectangle rect = this.applyInsets(drect);
        Object value = column.getValue(row);
        String key = this.getKeyForClass(value.getClass());
        if (key != null) {
            Image img = null;
            img = this.getImageRegistry().get(key);
            int x = rect.x + (rect.width - this.scaleX(img.getBounds().width)) / 2;
            int y = rect.y + (rect.height - this.scaleY(img.getBounds().height)) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, this.scaleX(img.getBounds().width), this.scaleY(img.getBounds().height));
        } else {
            Color bg = gc.getBackground();
            gc.setBackground(Display.getCurrent().getSystemColor(11));
            gc.fillRectangle(rect);
            gc.setBackground(bg);
        }
        if (drawFocus) {
            this.drawFocus(gc, drect);
        }
        this.drawSelection(gc, drawingArea, cellStyle, selected, printing);
    }

    @Override
    public int getPreferredWidth(List<IRow> rows, IColumn column) {
        return -1;
    }

    @Override
    public int getPreferredHeight(GC gc, ICellStyle cellStyle, int width, IRow row, IColumn column) {
        return -1;
    }

    private synchronized ImageRegistry getImageRegistry() {
        if (this._imageRegistry == null) {
            this._imageRegistry = new ImageRegistry();
        }
        return this._imageRegistry;
    }

    @Override
    public void dispose() {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
        this._keyMap.clear();
    }

    @Override
    public ICellRenderer createPrintRenderer(Printer printer) {
        ClassImageRenderer renderer = new ClassImageRenderer(printer);
        for (Class clazz : this._keyMap.keySet()) {
            String key = this._keyMap.get(clazz);
            ImageDescriptor imageDesc = this.getImageRegistry().getDescriptor(key);
            renderer.addClassImageDescriptorMapping(clazz, key, imageDesc);
        }
        return renderer;
    }
}

