/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.TextCellRenderer;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.swt.printing.Printer;

public class DateCellRenderer
extends TextCellRenderer {
    protected DateFormat _dateformat = DateFormat.getDateInstance(2);

    public DateCellRenderer(Printer printer) {
        super(printer);
    }

    public DateCellRenderer() {
    }

    protected String convertValue(IRow row, IColumn column) {
        Object value = column.getValue(row);
        if (value instanceof Date) {
            Date date = (Date)value;
            return this._dateformat.format(date);
        }
        if (value instanceof JaretDate) {
            Date date = ((JaretDate)value).getDate();
            return this._dateformat.format(date);
        }
        return "";
    }

    public DateFormat getDateformat() {
        return this._dateformat;
    }

    public void setDateformat(DateFormat dateformat) {
        this._dateformat = dateformat;
    }

    public ICellRenderer createPrintRenderer(Printer printer) {
        DateCellRenderer renderer = new DateCellRenderer(printer);
        renderer.setDateformat(this.getDateformat());
        return renderer;
    }
}

