/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.misc.PropertyObservableBase;
import de.jaret.util.ui.table.model.ITableViewState;
import de.jaret.util.ui.table.renderer.IBorderConfiguration;
import de.jaret.util.ui.table.renderer.ICellStyle;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class DefaultCellStyle
extends PropertyObservableBase
implements ICellStyle {
    protected IBorderConfiguration _borderConfiguration;
    protected RGB _foregroundColor;
    protected RGB _backgroundColor;
    protected RGB _borderColor;
    protected FontData _font;
    protected ITableViewState.HAlignment _hAlignment = ITableViewState.HAlignment.LEFT;
    protected ITableViewState.VAlignment _vAlignment = ITableViewState.VAlignment.TOP;
    protected boolean _multiLine = true;

    public DefaultCellStyle(RGB foregroundColor, RGB backgroundColor, IBorderConfiguration borderConfiguration, FontData font) {
        this._foregroundColor = foregroundColor;
        this._backgroundColor = backgroundColor;
        this._borderConfiguration = borderConfiguration;
        this._font = font;
    }

    public DefaultCellStyle copy() {
        DefaultCellStyle cs = new DefaultCellStyle(this._foregroundColor, this._backgroundColor, this._borderConfiguration.copy(), this._font);
        cs.setHorizontalAlignment(this._hAlignment);
        cs.setVerticalAlignment(this._vAlignment);
        return cs;
    }

    public RGB getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setBackgroundColor(RGB backgroundColor) {
        if (DefaultCellStyle.isRealModification((Object)this._backgroundColor, (Object)backgroundColor)) {
            RGB oldVal = this._backgroundColor;
            this._backgroundColor = backgroundColor;
            this.firePropertyChange("BackgroundColor", oldVal, backgroundColor);
        }
    }

    public RGB getBorderColor() {
        return this._borderColor;
    }

    public void setBorderColor(RGB borderColor) {
        if (DefaultCellStyle.isRealModification((Object)this._borderColor, (Object)borderColor)) {
            RGB oldVal = this._borderColor;
            this._borderColor = borderColor;
            this.firePropertyChange("BorderColor", oldVal, borderColor);
        }
    }

    public IBorderConfiguration getBorderConfiguration() {
        return this._borderConfiguration;
    }

    public void setBorderConfiguration(IBorderConfiguration borderConfiguration) {
        if (DefaultCellStyle.isRealModification((Object)this._borderConfiguration, (Object)borderConfiguration)) {
            IBorderConfiguration oldVal = this._borderConfiguration;
            this._borderConfiguration = borderConfiguration;
            this.firePropertyChange("BorderConfiguration", oldVal, borderConfiguration);
        }
    }

    public FontData getFont() {
        return this._font;
    }

    public void setFont(FontData font) {
        if (DefaultCellStyle.isRealModification((Object)this._font, (Object)font)) {
            FontData oldVal = this._font;
            this._font = font;
            this.firePropertyChange("Font", oldVal, font);
        }
    }

    public RGB getForegroundColor() {
        return this._foregroundColor;
    }

    public void setForegroundColor(RGB foregroundColor) {
        if (DefaultCellStyle.isRealModification((Object)this._foregroundColor, (Object)foregroundColor)) {
            RGB oldVal = this._foregroundColor;
            this._foregroundColor = foregroundColor;
            this.firePropertyChange("ForegroundColor", oldVal, foregroundColor);
        }
    }

    public ITableViewState.HAlignment getHorizontalAlignment() {
        return this._hAlignment;
    }

    public void setHorizontalAlignment(ITableViewState.HAlignment alignment) {
        if (!this._hAlignment.equals((Object)alignment)) {
            ITableViewState.HAlignment oldVal = this._hAlignment;
            this._hAlignment = alignment;
            this.firePropertyChange("HorizontalAlignment", (Object)oldVal, (Object)alignment);
        }
    }

    public ITableViewState.VAlignment getVerticalAlignment() {
        return this._vAlignment;
    }

    public void setVerticalAlignment(ITableViewState.VAlignment alignment) {
        if (!this._vAlignment.equals((Object)alignment)) {
            ITableViewState.VAlignment oldVal = this._vAlignment;
            this._vAlignment = alignment;
            this.firePropertyChange("VerticalAlignment", (Object)oldVal, (Object)alignment);
        }
    }

    public boolean getMultiLine() {
        return this._multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this._multiLine = multiLine;
    }
}

