/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IJaretTableCell;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.ITableViewState;
import de.jaret.util.ui.table.model.JaretTableCellImpl;
import de.jaret.util.ui.table.renderer.DefaultBorderConfiguration;
import de.jaret.util.ui.table.renderer.DefaultCellStyle;
import de.jaret.util.ui.table.renderer.ICellStyle;
import de.jaret.util.ui.table.renderer.ICellStyleListener;
import de.jaret.util.ui.table.renderer.ICellStyleProvider;
import de.jaret.util.ui.table.renderer.IStyleStrategy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCellStyleProvider
implements ICellStyleProvider,
PropertyChangeListener {
    protected Map<IRow, ICellStyle> _rowMap = new HashMap<IRow, ICellStyle>();
    protected Map<IColumn, ICellStyle> _columnMap = new HashMap<IColumn, ICellStyle>();
    protected Map<IRow, Map<IColumn, ICellStyle>> _cellMap = new HashMap<IRow, Map<IColumn, ICellStyle>>();
    protected List<ICellStyleListener> _listeners;
    protected ICellStyle _defaultCellStyle;
    protected ICellStyle _defaultCellStyleAlignRight;
    protected IStyleStrategy _styleStrategy;

    public DefaultCellStyleProvider() {
        DefaultBorderConfiguration borderConf = new DefaultBorderConfiguration(1, 1, 1, 1);
        this._defaultCellStyle = new DefaultCellStyle(null, null, borderConf, null);
        this._defaultCellStyle.addPropertyChangeListener(this);
        this._defaultCellStyleAlignRight = new DefaultCellStyle(null, null, borderConf, null);
        this._defaultCellStyleAlignRight.setHorizontalAlignment(ITableViewState.HAlignment.RIGHT);
        this._defaultCellStyleAlignRight.addPropertyChangeListener(this);
    }

    @Override
    public ICellStyle getCellStyle(IRow row, IColumn column) {
        ICellStyle style = null;
        style = this.getCellSpecificStyle(row, column, false);
        if (style == null) {
            style = this._rowMap.get(row);
        }
        if (style == null) {
            style = this._columnMap.get(column);
        }
        if (style == null) {
            Class<?> clazz = column.getContentClass(row);
            style = clazz != null && (clazz.equals(Double.class) || clazz.equals(Integer.class) || clazz.equals(Float.class) || clazz.equals(Double.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Float.TYPE)) ? this._defaultCellStyleAlignRight : this._defaultCellStyle;
        }
        if (this._styleStrategy != null) {
            style = this._styleStrategy.getCellStyle(row, column, style, this._defaultCellStyle);
        }
        return style;
    }

    @Override
    public void setRowCellStyle(IRow row, ICellStyle style) {
        ICellStyle old = this._rowMap.get(row);
        if (old != null) {
            old.removePropertyChangeListener(this);
        }
        this._rowMap.put(row, style);
        if (style != null) {
            style.addPropertyChangeListener(this);
        }
        this.fireCellStyleChanged(row, null, style);
    }

    @Override
    public ICellStyle getRowCellStyle(IRow row, boolean create) {
        ICellStyle style = null;
        style = this._rowMap.get(row);
        if (style != null) {
            return style;
        }
        if (style == null && !create) {
            return this._defaultCellStyle;
        }
        style = this._defaultCellStyle.copy();
        this.setRowCellStyle(row, style);
        return style;
    }

    @Override
    public void setColumnCellStyle(IColumn column, ICellStyle style) {
        ICellStyle old = this._columnMap.get(column);
        if (old != null) {
            old.removePropertyChangeListener(this);
        }
        this._columnMap.put(column, style);
        if (style != null) {
            style.addPropertyChangeListener(this);
        }
        this.fireCellStyleChanged(null, column, style);
    }

    @Override
    public ICellStyle getColumnCellStyle(IColumn column, boolean create) {
        ICellStyle style = null;
        style = this._columnMap.get(column);
        if (style != null) {
            return style;
        }
        if (style == null && !create) {
            return this._defaultCellStyle;
        }
        style = this._defaultCellStyle.copy();
        this.setColumnCellStyle(column, style);
        return style;
    }

    @Override
    public ICellStyle getCellSpecificStyle(IRow row, IColumn column, boolean create) {
        ICellStyle style = null;
        Map<IColumn, ICellStyle> cMap = this._cellMap.get(row);
        if (cMap != null) {
            style = cMap.get(column);
        }
        if (style == null && create) {
            style = this._defaultCellStyle.copy();
            this.setCellStyle(row, column, style);
        }
        return style;
    }

    @Override
    public void setCellStyle(IRow row, IColumn column, ICellStyle style) {
        Map<IColumn, ICellStyle> cMap;
        ICellStyle oldStyle = this.getCellSpecificStyle(row, column, false);
        if (oldStyle != null) {
            oldStyle.removePropertyChangeListener(this);
        }
        if ((cMap = this._cellMap.get(row)) == null) {
            cMap = new HashMap<IColumn, ICellStyle>();
            this._cellMap.put(row, cMap);
        }
        cMap.put(column, style);
        style.addPropertyChangeListener(this);
    }

    @Override
    public ICellStyle getDefaultCellStyle() {
        return this._defaultCellStyle;
    }

    @Override
    public void setDefaultCellStyle(ICellStyle cellStyle) {
        this._defaultCellStyle.removePropertyChangeListener(this);
        this._defaultCellStyle = cellStyle;
        cellStyle.addPropertyChangeListener(this);
    }

    @Override
    public synchronized void addCellStyleListener(ICellStyleListener csl) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<ICellStyleListener>();
        }
        this._listeners.add(csl);
    }

    @Override
    public void remCellStyleListener(ICellStyleListener csl) {
        if (this._listeners != null) {
            this._listeners.remove(csl);
        }
    }

    protected void fireCellStyleChanged(IRow row, IColumn column, ICellStyle cellStyle) {
        if (this._listeners != null) {
            for (ICellStyleListener listener : this._listeners) {
                listener.cellStyleChanged(row, column, cellStyle);
            }
        }
    }

    protected List<IJaretTableCell> getStyleLocations(ICellStyle style) {
        ArrayList<IJaretTableCell> result = new ArrayList<IJaretTableCell>();
        if (this._columnMap.containsValue(style)) {
            for (IColumn col : this._columnMap.keySet()) {
                if (this._columnMap.get(col) != style) continue;
                result.add(new JaretTableCellImpl(null, col));
            }
        }
        if (this._rowMap.containsValue(style)) {
            for (IRow row : this._rowMap.keySet()) {
                if (this._rowMap.get(row) != style) continue;
                result.add(new JaretTableCellImpl(row, null));
            }
        }
        for (IRow row : this._cellMap.keySet()) {
            Map<IColumn, ICellStyle> cmap = this._cellMap.get(row);
            if (cmap == null) continue;
            for (IColumn col : cmap.keySet()) {
                ICellStyle cs = cmap.get(col);
                if (style != cs) continue;
                result.add(new JaretTableCellImpl(row, col));
            }
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        ICellStyle style = (ICellStyle)event.getSource();
        List<IJaretTableCell> locs = this.getStyleLocations(style);
        for (IJaretTableCell loc : locs) {
            this.fireCellStyleChanged(loc.getRow(), loc.getColumn(), style);
        }
    }

    @Override
    public IStyleStrategy getStyleStrategy() {
        return this._styleStrategy;
    }

    @Override
    public void setStyleStrategy(IStyleStrategy startegy) {
        this._styleStrategy = startegy;
    }

    @Override
    public void setBackground(IRow row, RGB background) {
        ICellStyle style = this.getRowCellStyle(row, true);
        style.setBackgroundColor(background);
        this.setRowCellStyle(row, style);
    }

    @Override
    public void setBackground(IColumn column, RGB background) {
        ICellStyle style = this.getColumnCellStyle(column, true);
        style.setBackgroundColor(background);
        this.setColumnCellStyle(column, style);
    }

    @Override
    public void setBackground(IRow row, IColumn column, RGB background) {
        ICellStyle style = this.getCellSpecificStyle(row, column, true);
        style.setBackgroundColor(background);
        this.setCellStyle(row, column, style);
    }

    @Override
    public void setForeground(IRow row, RGB foreground) {
        ICellStyle style = this.getRowCellStyle(row, true);
        style.setForegroundColor(foreground);
        this.setRowCellStyle(row, style);
    }

    @Override
    public void setForeground(IColumn column, RGB foreground) {
        ICellStyle style = this.getColumnCellStyle(column, true);
        style.setForegroundColor(foreground);
        this.setColumnCellStyle(column, style);
    }

    @Override
    public void setForeground(IRow row, IColumn column, RGB foreground) {
        ICellStyle style = this.getCellSpecificStyle(row, column, true);
        style.setForegroundColor(foreground);
        this.setCellStyle(row, column, style);
    }

    @Override
    public void setHorizontalAlignment(IRow row, ITableViewState.HAlignment alignment) {
        ICellStyle style = this.getRowCellStyle(row, true);
        style.setHorizontalAlignment(alignment);
        this.setRowCellStyle(row, style);
    }

    @Override
    public void setHorizontalAlignment(IColumn column, ITableViewState.HAlignment alignment) {
        ICellStyle style = this.getColumnCellStyle(column, true);
        style.setHorizontalAlignment(alignment);
        this.setColumnCellStyle(column, style);
    }

    @Override
    public void setHorizontalAlignment(IRow row, IColumn column, ITableViewState.HAlignment alignment) {
        ICellStyle style = this.getCellSpecificStyle(row, column, true);
        style.setHorizontalAlignment(alignment);
        this.setCellStyle(row, column, style);
    }

    @Override
    public void setVerticalAlignment(IRow row, ITableViewState.VAlignment alignment) {
        ICellStyle style = this.getRowCellStyle(row, true);
        style.setVerticalAlignment(alignment);
        this.setRowCellStyle(row, style);
    }

    @Override
    public void setVerticalAlignment(IColumn column, ITableViewState.VAlignment alignment) {
        ICellStyle style = this.getColumnCellStyle(column, true);
        style.setVerticalAlignment(alignment);
        this.setColumnCellStyle(column, style);
    }

    @Override
    public void setVerticalAlignment(IRow row, IColumn column, ITableViewState.VAlignment alignment) {
        ICellStyle style = this.getCellSpecificStyle(row, column, true);
        style.setVerticalAlignment(alignment);
        this.setCellStyle(row, column, style);
    }

    @Override
    public void setFont(IRow row, FontData fontdata) {
        ICellStyle style = this.getRowCellStyle(row, true);
        style.setFont(fontdata);
        this.setRowCellStyle(row, style);
    }

    @Override
    public void setFont(IColumn column, FontData fontdata) {
        ICellStyle style = this.getColumnCellStyle(column, true);
        style.setFont(fontdata);
        this.setColumnCellStyle(column, style);
    }

    @Override
    public void setFont(IRow row, IColumn column, FontData fontdata) {
        ICellStyle style = this.getCellSpecificStyle(row, column, true);
        style.setFont(fontdata);
        this.setCellStyle(row, column, style);
    }
}

