/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.renderer.ITableHeaderRenderer;
import de.jaret.util.ui.table.renderer.RendererBase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DefaultTableHeaderRenderer
extends RendererBase
implements ITableHeaderRenderer {
    private static RGB DEFAULTBACKGROUND = new RGB(220, 220, 220);
    protected Alignment _alignment = Alignment.LEFT;
    protected boolean _drawBox = true;
    protected RGB _backgroundRGB = DEFAULTBACKGROUND;
    protected Color _bgColor;
    protected FontData _fontData;
    protected Font _font;
    protected int _rotation = 0;
    protected Transform _transform;
    protected Transform _transformInv;
    protected ImageRegistry _imageRegistry;
    protected static final String UP = "up";
    protected static final String DOWN = "down";
    protected static final int SORTINGAREAINDICATORWIDTH = 16;
    private static final int PREFHEIGHT = 20;

    public DefaultTableHeaderRenderer(Printer printer) {
        super(printer);
    }

    public DefaultTableHeaderRenderer() {
        super(null);
    }

    public void setRotation(int rotation) {
        if (rotation < 0 || rotation > 90) {
            throw new IllegalArgumentException("Rotation range 0..90");
        }
        if (this._rotation != rotation) {
            this.disposeTransformations();
            this._rotation = rotation;
            this._transform = new Transform((Device)Display.getCurrent());
            this._transformInv = new Transform((Device)Display.getCurrent());
            this._transform.rotate((float)(-rotation));
            this._transformInv.rotate((float)(-rotation));
            this._transformInv.invert();
        }
    }

    public void draw(GC gc, Rectangle drawingArea, IColumn column, int sortingOrder, boolean sortDir, boolean printing) {
        Color bg = gc.getBackground();
        Font font = gc.getFont();
        String label = column.getHeaderLabel();
        if (this._fontData != null && this._font == null) {
            this._font = new Font(gc.getDevice(), this._fontData);
        }
        if (this._font != null) {
            gc.setFont(this._font);
        }
        if (this._rotation == 0) {
            int offx;
            if (this._bgColor == null) {
                this._bgColor = new Color(gc.getDevice(), this._backgroundRGB);
            }
            gc.setBackground(this._bgColor);
            if (drawingArea.height > 20) {
                drawingArea.y += drawingArea.height - 20;
                drawingArea.height = 20;
            }
            gc.fillRectangle(drawingArea);
            if (sortingOrder > 0) {
                Image img = this.getImageRegistry().get(sortDir ? DOWN : UP);
                gc.drawImage(img, drawingArea.x + 2, drawingArea.y + drawingArea.height - img.getBounds().height - 1);
            }
            if (this._drawBox) {
                gc.drawRectangle(drawingArea.x, drawingArea.y, drawingArea.width - 1, drawingArea.height - 1);
            } else {
                gc.drawLine(drawingArea.x, drawingArea.y + drawingArea.height - 1, drawingArea.width - 1, drawingArea.y + drawingArea.height - 1);
            }
            int n = offx = column.supportsSorting() ? 16 : 2;
            if (this._alignment.equals((Object)Alignment.LEFT)) {
                gc.drawString(label, drawingArea.x + offx, drawingArea.y + this.scaleY(2));
            } else if (this._alignment.equals((Object)Alignment.CENTER)) {
                Rectangle rect = new Rectangle(drawingArea.x + offx, drawingArea.y + this.scaleY(2), drawingArea.width - offx, drawingArea.height - 2 * this.scaleY(2));
                SwtGraphicsHelper.drawStringCentered((GC)gc, (String)label, (Rectangle)rect);
            } else if (this._alignment.equals((Object)Alignment.RIGHT)) {
                SwtGraphicsHelper.drawStringRightAlignedVTop((GC)gc, (String)label, (int)(drawingArea.x + drawingArea.width), (int)(drawingArea.y + this.scaleY(2)));
            }
        } else {
            gc.setBackground(gc.getDevice().getSystemColor(1));
            Point extent = gc.stringExtent(label);
            float[] cords = new float[]{drawingArea.x + (drawingArea.width - extent.x / 2) / 2, drawingArea.y + drawingArea.height - 9};
            this._transformInv.transform(cords);
            gc.setTransform(this._transform);
            gc.drawString(label, (int)cords[0], (int)cords[1]);
            gc.setTransform(null);
        }
        gc.setFont(font);
        gc.setBackground(bg);
    }

    public boolean disableClipping() {
        return this._rotation != 0;
    }

    public void dispose() {
        this.disposeTransformations();
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
        if (this._bgColor != null) {
            this._bgColor.dispose();
        }
        if (this._font != null) {
            this._font.dispose();
        }
    }

    private ImageRegistry getImageRegistry() {
        if (this._imageRegistry == null) {
            this._imageRegistry = new ImageRegistry();
            LocalResourceImageDescriptor imgDesc = new LocalResourceImageDescriptor("/de/jaret/util/ui/table/resource/smallarrow_down.gif");
            this._imageRegistry.put(DOWN, imgDesc.createImage());
            imgDesc = new LocalResourceImageDescriptor("/de/jaret/util/ui/table/resource/smallarrow_up.gif");
            this._imageRegistry.put(UP, imgDesc.createImage());
        }
        return this._imageRegistry;
    }

    private void disposeTransformations() {
        if (this._transform != null) {
            this._transform.dispose();
        }
        if (this._transformInv != null) {
            this._transformInv.dispose();
        }
    }

    public boolean isSortingClick(Rectangle drawingArea, IColumn column, int x, int y) {
        return x - drawingArea.x < 16;
    }

    public ITableHeaderRenderer getPrintRenderer(Printer printer) {
        return new DefaultTableHeaderRenderer(printer);
    }

    public Alignment getAlignment() {
        return this._alignment;
    }

    public void setAlignment(Alignment alignment) {
        this._alignment = alignment;
    }

    public boolean getDrawBox() {
        return this._drawBox;
    }

    public void setDrawBox(boolean drawBox) {
        this._drawBox = drawBox;
    }

    public RGB getBackgroundRGB() {
        return this._backgroundRGB;
    }

    public void setBackgroundRGB(RGB backgroundRGB) {
        if (this._bgColor != null) {
            this._bgColor.dispose();
            this._bgColor = null;
        }
        this._backgroundRGB = backgroundRGB;
    }

    public FontData getFontData() {
        return this._fontData;
    }

    public void setFontData(FontData fontData) {
        if (this._font != null) {
            this._font.dispose();
            this._font = null;
        }
        this._fontData = fontData;
    }

    public class LocalResourceImageDescriptor
    extends ImageDescriptor {
        String rscString;

        public LocalResourceImageDescriptor(String rscString) {
            this.rscString = rscString;
        }

        public ImageData getImageData() {
            Image img = new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream(this.rscString));
            return img.getImageData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

