/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.TextCellRenderer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.swt.printing.Printer;

public class DoubleCellRenderer
extends TextCellRenderer {
    protected static final int DEFAULT_FRACTION_DIGITS = 2;
    protected NumberFormat _numberFormat = DecimalFormat.getIntegerInstance();

    public DoubleCellRenderer(Printer printer) {
        super(printer);
        this._numberFormat.setMaximumFractionDigits(2);
        this._numberFormat.setMinimumFractionDigits(2);
    }

    public DoubleCellRenderer() {
        this(null);
    }

    public NumberFormat getNumberFormat() {
        return this._numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this._numberFormat = numberFormat;
    }

    protected String convertValue(IRow row, IColumn column) {
        Double value = (Double)column.getValue(row);
        return value != null ? this._numberFormat.format(value) : null;
    }

    public ICellRenderer createPrintRenderer(Printer printer) {
        DoubleCellRenderer dcr = new DoubleCellRenderer(printer);
        dcr.setNumberFormat(this.getNumberFormat());
        return dcr;
    }
}

