/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class ImageCellRenderer
extends CellRendererBase
implements ICellRenderer {
    public ImageCellRenderer(Printer printer) {
        super(printer);
    }

    public ImageCellRenderer() {
        super(null);
    }

    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        this.drawBackground(gc, drawingArea, cellStyle, selected, printing);
        Rectangle drect = this.drawBorder(gc, cellStyle, drawingArea, printing);
        Rectangle rect = this.applyInsets(drect);
        Object value = column.getValue(row);
        if (value != null) {
            if (value instanceof Image) {
                Image img = (Image)value;
                int x = rect.x + (rect.width - img.getBounds().width) / 2;
                int y = rect.y + (rect.height - img.getBounds().height) / 2;
                gc.drawImage(img, x, y);
            } else {
                Color bg = gc.getBackground();
                gc.setBackground(Display.getCurrent().getSystemColor(3));
                gc.fillRectangle(rect);
                gc.setBackground(bg);
            }
        }
        if (drawFocus) {
            this.drawFocus(gc, drawingArea);
        }
        this.drawSelection(gc, drawingArea, cellStyle, selected, printing);
    }

    public void dispose() {
    }

    public ICellRenderer createPrintRenderer(Printer printer) {
        return new ImageCellRenderer(printer);
    }
}

