/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.ResourceImageDescriptor;
import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectImageRenderer
extends CellRendererBase
implements ICellRenderer {
    protected Map<Object, String> _keyMap = new HashMap<Object, String>();
    private ImageRegistry _imageRegistry;

    public ObjectImageRenderer(Printer printer) {
        super(printer);
    }

    public ObjectImageRenderer() {
        super(null);
    }

    public void addObjectImageDescriptorMapping(Object o, String key, ImageDescriptor imageDescriptor) {
        this.getImageRegistry().put(key, imageDescriptor);
        this._keyMap.put(o, key);
    }

    public void addObjectRessourceNameMapping(Object o, String key, String ressourceName) {
        ResourceImageDescriptor imgDesc = new ResourceImageDescriptor(ressourceName, this.getClass());
        this.addObjectImageDescriptorMapping(o, key, (ImageDescriptor)imgDesc);
    }

    @Override
    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        this.drawBackground(gc, drawingArea, cellStyle, selected, printing);
        Rectangle drect = this.drawBorder(gc, cellStyle, drawingArea, printing);
        Rectangle rect = this.applyInsets(drect);
        Object value = column.getValue(row);
        String key = this._keyMap.get(value);
        if (key != null) {
            Image img = null;
            img = this.getImageRegistry().get(key);
            int x = rect.x + (rect.width - this.scaleX(img.getBounds().width)) / 2;
            int y = rect.y + (rect.height - this.scaleY(img.getBounds().height)) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, this.scaleX(img.getBounds().width), this.scaleY(img.getBounds().height));
        } else {
            Color bg = gc.getBackground();
            gc.setBackground(Display.getCurrent().getSystemColor(11));
            gc.fillRectangle(rect);
            gc.setBackground(bg);
        }
        if (drawFocus) {
            this.drawFocus(gc, drect);
        }
        this.drawSelection(gc, drawingArea, cellStyle, selected, printing);
    }

    @Override
    public int getPreferredWidth(List<IRow> rows, IColumn column) {
        return -1;
    }

    @Override
    public int getPreferredHeight(GC gc, ICellStyle cellStyle, int width, IRow row, IColumn column) {
        return -1;
    }

    private synchronized ImageRegistry getImageRegistry() {
        if (this._imageRegistry == null) {
            this._imageRegistry = new ImageRegistry();
        }
        return this._imageRegistry;
    }

    @Override
    public void dispose() {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
        this._keyMap.clear();
    }

    @Override
    public ICellRenderer createPrintRenderer(Printer printer) {
        ObjectImageRenderer renderer = new ObjectImageRenderer(printer);
        for (Object o : this._keyMap.keySet()) {
            String key = this._keyMap.get(o);
            ImageDescriptor imageDesc = this.getImageRegistry().getDescriptor(key);
            renderer.addObjectImageDescriptorMapping(o, key, imageDesc);
        }
        return renderer;
    }
}

