/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;

public abstract class RendererBase {
    protected Printer _printer;
    protected static final double SCREEN_DPI_X = 96.0;
    protected static final double SCREEN_DPI_Y = 96.0;
    protected double _scaleX = 1.0;
    protected double _scaleY = 1.0;
    private Color _bgColor;
    private Color _fgColor;
    private int _lineWidth;
    private Font _font;

    public RendererBase(Printer printer) {
        this._printer = printer;
        if (this._printer != null) {
            Point dpi = this._printer.getDPI();
            this._scaleX = (double)dpi.x / 96.0;
            this._scaleY = (double)dpi.y / 96.0;
        }
    }

    public int scaleX(int in) {
        return (int)Math.round(this._scaleX * (double)in);
    }

    public double getScaleX() {
        return this._scaleX;
    }

    public int scaleY(int in) {
        return (int)Math.round(this._scaleY * (double)in);
    }

    public double getScaleY() {
        return this._scaleY;
    }

    public Printer getPrinter() {
        return this._printer;
    }

    protected void saveGCAttributes(GC gc) {
        this._bgColor = gc.getBackground();
        this._fgColor = gc.getForeground();
        this._font = gc.getFont();
        this._lineWidth = gc.getLineWidth();
    }

    protected void restoreGCAttributes(GC gc) {
        if (this._bgColor == null) {
            throw new RuntimeException("no attributes saved");
        }
        gc.setBackground(this._bgColor);
        gc.setForeground(this._fgColor);
        gc.setFont(this._font);
        gc.setLineWidth(this._lineWidth);
    }
}

