/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import de.jaret.util.ui.table.renderer.TextCellRenderer;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class SmileyCellRenderer
extends CellRendererBase
implements ICellRenderer {
    private BoundedRangeModel _brModel = new DefaultBoundedRangeModel(50, 0, 0, 100);
    private boolean _eyeBrows = true;
    private boolean _colorChange = true;
    private boolean _forceCircle = true;
    private Color _neutral;
    private Color _positive;
    private Color _negative;
    private Color _currentColor;
    private Color _black;
    private double _currentValue;

    public SmileyCellRenderer(Printer printer) {
        super(printer);
        if (printer != null) {
            this._neutral = printer.getSystemColor(7);
            this._positive = printer.getSystemColor(5);
            this._negative = printer.getSystemColor(3);
            this._black = printer.getSystemColor(2);
        }
    }

    public SmileyCellRenderer() {
        super(null);
        this._neutral = Display.getCurrent().getSystemColor(7);
        this._positive = Display.getCurrent().getSystemColor(5);
        this._negative = Display.getCurrent().getSystemColor(3);
        this._black = Display.getCurrent().getSystemColor(2);
    }

    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        this.drawBackground(gc, drawingArea, cellStyle, selected, printing);
        Rectangle drect = this.drawBorder(gc, cellStyle, drawingArea, printing);
        Rectangle rect = this.applyInsets(drect);
        Object value = column.getValue(row);
        if (value != null) {
            this.saveGCAttributes(gc);
            int val = (Integer)value;
            this._brModel.setValue(val);
            this.calcSmileFactor();
            if (this._forceCircle) {
                int a = Math.min(rect.width, rect.height);
                Rectangle nrect = new Rectangle(0, 0, a, a);
                nrect.x = rect.x + (rect.width - a) / 2;
                nrect.y = rect.y + (rect.height - a) / 2;
                rect = nrect;
            }
            int width = rect.width;
            int height = rect.height;
            int offx = rect.x;
            int offy = rect.y;
            float foffx = offx;
            float foffy = offy;
            int lineWidth = height / 40;
            if (!this._colorChange) {
                gc.setBackground(this._neutral);
            } else if (this._currentValue >= 0.0) {
                gc.setBackground(this.calcColor(this._positive, printing));
            } else {
                gc.setBackground(this.calcColor(this._negative, printing));
            }
            Display device = printing ? this._printer : Display.getCurrent();
            Path p = new Path((Device)device);
            p.addArc(foffx + 0.0f + (float)(lineWidth / 2), foffy + 0.0f + (float)(lineWidth / 2), (float)(width - 1 - lineWidth), (float)(height - 1 - lineWidth), 0.0f, 360.0f);
            gc.fillPath(p);
            gc.setForeground(this._black);
            gc.setLineWidth(lineWidth);
            gc.drawPath(p);
            p.dispose();
            int y = height / 3;
            int x1 = width / 3;
            int x2 = width - width / 3;
            int r = width / 30;
            if (r == 0) {
                r = 1;
            }
            gc.setBackground(this._black);
            gc.fillOval(offx + x1 - r, offy + y - r, 2 * r, 2 * r);
            gc.fillOval(offx + x2 - r, offy + y - r, 2 * r, 2 * r);
            if (this._eyeBrows) {
                gc.setLineWidth(lineWidth / 2);
                int ebWidth = width / 10;
                int yDist = height / 13;
                int yOff = (int)(this._currentValue * (double)height / 30.0);
                int xShift = (int)(this._currentValue * (double)width / 90.0);
                p = new Path((Device)device);
                p.moveTo(foffx + (float)x1 - (float)(ebWidth / 2) + (float)xShift, foffy + (float)y - (float)yDist + (float)yOff);
                p.lineTo(foffx + (float)x1 + (float)(ebWidth / 2) - (float)xShift, foffy + (float)y - (float)yDist - (float)yOff);
                gc.drawPath(p);
                p.dispose();
                p = new Path((Device)device);
                p.moveTo(foffx + (float)x2 - (float)(ebWidth / 2) + (float)xShift, foffy + (float)y - (float)yDist - (float)yOff);
                p.lineTo(foffx + (float)x2 + (float)(ebWidth / 2) - (float)xShift, foffy + (float)y - (float)yDist + (float)yOff);
                gc.drawPath(p);
                p.dispose();
            }
            gc.setLineWidth(lineWidth);
            x1 = (int)((double)width / 4.5);
            x2 = width - x1;
            y = height - height / 3;
            int midX = width / 2;
            int offset = (int)(this._currentValue * (double)height / 3.0);
            p = new Path((Device)Display.getCurrent());
            p.moveTo(foffx + (float)x1, foffy + (float)y);
            p.quadTo(foffx + (float)midX, foffy + (float)y + (float)offset, foffx + (float)x2, foffy + (float)y);
            gc.drawPath(p);
            p.dispose();
            this.restoreGCAttributes(gc);
        }
        if (drawFocus) {
            this.drawFocus(gc, drect);
        }
        this.drawSelection(gc, drawingArea, cellStyle, selected, printing);
    }

    private void calcSmileFactor() {
        int range = this._brModel.getMaximum() - this._brModel.getMinimum();
        int mid = this._brModel.getMinimum() + range / 2;
        int value = this._brModel.getValue();
        this._currentValue = (double)(value - mid) / (double)(range / 2);
        if (this._currentValue > 1.0) {
            this._currentValue = 1.0;
        } else if (this._currentValue < -1.0) {
            this._currentValue = -1.0;
        }
    }

    private Color calcColor(Color destColor, boolean printing) {
        int rDiff = destColor.getRed() - this._neutral.getRed();
        int gDiff = destColor.getGreen() - this._neutral.getGreen();
        int bDiff = destColor.getBlue() - this._neutral.getBlue();
        double factor = Math.abs(this._currentValue);
        int r = (int)((double)rDiff * factor);
        int g = (int)((double)gDiff * factor);
        int b = (int)((double)bDiff * factor);
        if (this._currentColor != null) {
            this._currentColor.dispose();
        }
        this._currentColor = !printing ? new Color((Device)Display.getCurrent(), this._neutral.getRed() + r, this._neutral.getGreen() + g, this._neutral.getBlue() - b) : new Color((Device)this._printer, this._neutral.getRed() + r, this._neutral.getGreen() + g, this._neutral.getBlue() - b);
        return this._currentColor;
    }

    public void dispose() {
        if (this._currentColor != null) {
            this._currentColor.dispose();
        }
    }

    public ICellRenderer createPrintRenderer(Printer printer) {
        return new TextCellRenderer(printer);
    }
}

