/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IHierarchicalTableViewState;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.ITableNode;
import de.jaret.util.ui.table.model.StdHierarchicalTableModel;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import de.jaret.util.ui.table.renderer.IHierarchyRenderer;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableHierarchyRenderer
extends CellRendererBase
implements IHierarchyRenderer {
    protected int SIZE = 12;
    protected int SIGNINSETS = 3;
    protected boolean _drawTree = true;
    protected int _levelWidth = 30;
    protected boolean _drawIcons = false;
    protected boolean _drawLabels = false;
    protected ILabelProvider _labelProvider = null;
    protected int _nodeMarkType = 2;

    public TableHierarchyRenderer(Printer printer) {
        super(printer);
        this.SIZE = this.scaleX(this.SIZE);
        this.SIGNINSETS = this.scaleX(this.SIGNINSETS);
    }

    public TableHierarchyRenderer() {
        super(null);
    }

    @Override
    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        int offx = this.scaleX(this._levelWidth);
        ITableNode node = (ITableNode)row;
        int level = node.getLevel();
        boolean leaf = node.getChildren().size() == 0;
        boolean expanded = ((IHierarchicalTableViewState)jaretTable.getTableViewState()).isExpanded(node);
        int x = drawingArea.x + offx * level + this.SIZE / 2;
        int y = drawingArea.y + (drawingArea.height - this.SIZE) / 2;
        if (leaf && !this._drawIcons) {
            this.drawLeaf(gc, this.SIZE, x, y);
        } else if (expanded && !leaf) {
            if (this._nodeMarkType == 1) {
                this.drawMinus(gc, this.SIZE, x, y);
            } else if (this._nodeMarkType == 2) {
                this.drawTriangleDown(gc, this.SIZE, x, y);
            }
        } else if (!leaf) {
            if (this._nodeMarkType == 1) {
                this.drawPlus(gc, this.SIZE, x, y);
            } else if (this._nodeMarkType == 2) {
                this.drawTriangleRight(gc, this.SIZE, x, y);
            }
        }
        if (this._nodeMarkType != 0) {
            x += this.SIZE + 4;
        }
        Rectangle labelrect = drawingArea;
        if (this._labelProvider != null && (this._drawIcons || this._drawLabels)) {
            String label;
            Image img;
            int labelx = x;
            labelrect = new Rectangle(x, y, 0, 0);
            if (this._drawIcons && (img = this._labelProvider.getImage((Object)row)) != null) {
                if (!printing) {
                    gc.drawImage(img, x, y);
                    labelx += img.getBounds().width;
                    labelrect.width += img.getBounds().width;
                    labelrect.height = img.getBounds().height;
                } else {
                    gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, this.scaleX(img.getBounds().width), this.scaleY(img.getBounds().height));
                    labelx += this.scaleX(img.getBounds().width);
                    labelrect.width += this.scaleX(img.getBounds().width);
                    labelrect.height = this.scaleY(img.getBounds().height);
                }
            }
            if (this._drawLabels && (label = this._labelProvider.getText((Object)row)) != null) {
                gc.drawString(label, labelx, y);
                Point extent = gc.stringExtent(label);
                labelrect.width += extent.x;
                labelrect.height = Math.max(labelrect.height, extent.y);
            }
        }
        if (this._drawTree) {
            StdHierarchicalTableModel model;
            if (printing) {
                gc.setLineWidth(3);
            }
            gc.setLineStyle(3);
            int midy = drawingArea.y + (drawingArea.height - this.SIZE) / 2 + this.SIZE / 2;
            int icoy = drawingArea.y + (drawingArea.height - this.SIZE) / 2 + this.SIZE;
            int icox = drawingArea.x + offx * level + this.SIZE - this.SIZE / 2;
            int midx = drawingArea.x + offx * level + this.SIZE;
            int beginx = drawingArea.x + offx * (level - 1) + this.SIZE;
            int endx = drawingArea.x + offx * (level + 1) + this.SIZE;
            gc.drawLine(beginx, midy, icox, midy);
            gc.drawLine(beginx, drawingArea.y, beginx, midy);
            if (!leaf && expanded) {
                gc.drawLine(midx, icoy, midx, drawingArea.y + drawingArea.height);
            }
            boolean hasMoreSiblings = true;
            if (jaretTable.getTableModel() instanceof StdHierarchicalTableModel) {
                model = (StdHierarchicalTableModel)jaretTable.getTableModel();
                hasMoreSiblings = model.moreSiblings(node, node.getLevel());
            }
            if (jaretTable.getTableModel() instanceof StdHierarchicalTableModel) {
                model = (StdHierarchicalTableModel)jaretTable.getTableModel();
                for (int i = 0; i < level; ++i) {
                    if (!model.moreSiblings(node, i)) continue;
                    x = drawingArea.x + offx * i + this.SIZE;
                    gc.drawLine(x, drawingArea.y, x, drawingArea.y + drawingArea.height);
                }
            }
            gc.setLineStyle(1);
            gc.setLineWidth(1);
        }
        if (drawFocus) {
            this.drawFocus(gc, labelrect);
        }
        this.drawSelection(gc, labelrect, cellStyle, selected, printing);
    }

    protected void drawPlus(GC gc, int size, int x, int y) {
        gc.drawLine(x + this.SIGNINSETS, y + size / 2, x + size - this.SIGNINSETS, y + size / 2);
        gc.drawLine(x + size / 2, y + this.SIGNINSETS, x + size / 2, y + size - this.SIGNINSETS);
        gc.drawRectangle(x, y, size, size);
    }

    protected void drawMinus(GC gc, int size, int x, int y) {
        gc.drawLine(x + this.SIGNINSETS, y + size / 2, x + size - this.SIGNINSETS, y + size / 2);
        gc.drawRectangle(x, y, size, size);
    }

    protected void drawTriangleDown(GC gc, int size, int x, int y) {
        Color bg = gc.getBackground();
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        int[] pArray = new int[]{x, y, x + size, y, x + size / 2, y + size - 3};
        gc.fillPolygon(pArray);
        gc.setBackground(bg);
    }

    protected void drawTriangleRight(GC gc, int size, int x, int y) {
        Color bg = gc.getBackground();
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        int[] pArray = new int[]{x, y, x + size - 3, y + size / 2, x, y + size};
        gc.fillPolygon(pArray);
        gc.setBackground(bg);
    }

    protected void drawLeaf(GC gc, int size, int x, int y) {
        Color bg = gc.getBackground();
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        gc.fillOval(x + size / 2, y + size / 2, size / 2, size / 2);
        gc.setBackground(bg);
    }

    public boolean contains(Rectangle drawingArea, int x, int y) {
        return true;
    }

    public int getPreferredWidth() {
        return this.scaleX(this.SIZE + 4);
    }

    @Override
    public void dispose() {
        if (this._labelProvider != null) {
            this._labelProvider.dispose();
        }
    }

    public ILabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this._labelProvider = labelProvider;
    }

    public int getLevelWidth() {
        return this._levelWidth;
    }

    public void setLevelWidth(int levelWidth) {
        this._levelWidth = levelWidth;
    }

    public boolean getDrawIcons() {
        return this._drawIcons;
    }

    public void setDrawIcons(boolean drawIcons) {
        this._drawIcons = drawIcons;
    }

    public boolean getDrawLabels() {
        return this._drawLabels;
    }

    public void setDrawLabels(boolean drawLabels) {
        this._drawLabels = drawLabels;
    }

    @Override
    public ICellRenderer createPrintRenderer(Printer printer) {
        TableHierarchyRenderer r = new TableHierarchyRenderer(printer);
        r.setDrawIcons(this._drawIcons);
        r.setDrawLabels(this._drawLabels);
        r.setLevelWidth(this._levelWidth);
        r.setLabelProvider(this._labelProvider);
        return r;
    }

    @Override
    public int getPreferredWidth(List<IRow> rows, IColumn column) {
        return -1;
    }

    public int getPreferredHeight(IRow row, IColumn column) {
        return -1;
    }

    @Override
    public boolean isInActiveArea(IRow row, Rectangle drawingArea, int xx, int yy) {
        boolean leaf;
        int offx = this.scaleX(this._levelWidth);
        ITableNode node = (ITableNode)row;
        int level = node.getLevel();
        boolean bl = leaf = node.getChildren().size() == 0;
        if (leaf) {
            return false;
        }
        int x = drawingArea.x + offx * level + this.SIZE / 2;
        int y = drawingArea.y + (drawingArea.height - this.SIZE) / 2;
        return x <= xx && xx <= x + this.SIZE && y <= yy && yy <= y + this.SIZE;
    }
}

