/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.renderer;

import de.jaret.util.swt.TextRenderer;
import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IRow;
import de.jaret.util.ui.table.model.ITableViewState;
import de.jaret.util.ui.table.renderer.CellRendererBase;
import de.jaret.util.ui.table.renderer.ICellRenderer;
import de.jaret.util.ui.table.renderer.ICellStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class TextCellRenderer
extends CellRendererBase
implements ICellRenderer {
    private static final int COMMENTMARKER_SIZE = 5;
    protected Color _commentColor;

    public TextCellRenderer(Printer printer) {
        super(printer);
    }

    public TextCellRenderer() {
        super(null);
        this._commentColor = Display.getCurrent().getSystemColor(3);
    }

    public String getTooltip(JaretTable jaretTable, Rectangle drawingArea, IRow row, IColumn column, int x, int y) {
        if (this.getComment(row, column) != null && this.isInCommentMarkerArea(drawingArea, 5, x, y)) {
            return this.getComment(row, column);
        }
        return null;
    }

    protected String convertValue(IRow row, IColumn column) {
        Object value = column.getValue(row);
        return value != null ? value.toString() : null;
    }

    protected String getComment(IRow row, IColumn column) {
        return null;
    }

    public void draw(GC gc, JaretTable jaretTable, ICellStyle cellStyle, Rectangle drawingArea, IRow row, IColumn column, boolean drawFocus, boolean selected, boolean printing) {
        this.drawBackground(gc, drawingArea, cellStyle, selected, printing);
        Rectangle drect = this.drawBorder(gc, cellStyle, drawingArea, printing);
        Rectangle rect = this.applyInsets(drect);
        String s = this.convertValue(row, column);
        Color fg = gc.getForeground();
        Color bg = gc.getBackground();
        Font font = gc.getFont();
        if (s != null) {
            if (selected && !printing) {
                gc.setBackground(SELECTIONCOLOR);
            } else {
                gc.setBackground(this.getBackgroundColor(cellStyle, printing));
            }
            gc.setForeground(this.getForegroundColor(cellStyle, printing));
            gc.setFont(this.getFont(cellStyle, printing, gc.getFont()));
            this.drawCellString(gc, rect, s, cellStyle);
        }
        if (!printing && this.getComment(row, column) != null) {
            this.drawCommentMarker(gc, drawingArea, this._commentColor, 5);
        }
        if (drawFocus) {
            this.drawFocus(gc, drect);
        }
        this.drawSelection(gc, drawingArea, cellStyle, selected, printing);
        gc.setForeground(fg);
        gc.setBackground(bg);
        gc.setFont(font);
    }

    private void drawCellString(GC gc, Rectangle rect, String s, ICellStyle cellStyle) {
        if (cellStyle.getMultiLine()) {
            this.drawCellStringMulti(gc, rect, s, cellStyle);
        } else {
            this.drawCellStringSingle(gc, rect, s);
        }
    }

    private void drawCellStringSingle(GC gc, Rectangle rect, String s) {
        gc.drawString(s, rect.x, rect.y + 10, true);
    }

    private void drawCellStringMulti(GC gc, Rectangle rect, String s, ICellStyle cellStyle) {
        int halign = 0;
        if (cellStyle.getHorizontalAlignment() == ITableViewState.HAlignment.RIGHT) {
            halign = 1;
        } else if (cellStyle.getHorizontalAlignment() == ITableViewState.HAlignment.CENTER) {
            halign = 2;
        }
        int valign = 0;
        if (cellStyle.getVerticalAlignment() == ITableViewState.VAlignment.BOTTOM) {
            valign = 1;
        } else if (cellStyle.getVerticalAlignment() == ITableViewState.VAlignment.CENTER) {
            valign = 2;
        }
        TextRenderer.renderText((GC)gc, (Rectangle)rect, (boolean)true, (boolean)false, (String)s, (int)halign, (int)valign);
    }

    public int getPreferredHeight(GC gc, ICellStyle cellStyle, int width, IRow row, IColumn column) {
        String value = this.convertValue(row, column);
        Font font = gc.getFont();
        int height = -1;
        if (value != null) {
            String s = value.toString();
            gc.setFont(this.getFont(cellStyle, false, gc.getFont()));
            height = TextRenderer.getHeight((GC)gc, (int)this.getInnerWidth(width, cellStyle), (boolean)true, (String)s);
        }
        gc.setFont(font);
        return height + this.getVerticalSpacesSum(cellStyle);
    }

    public void dispose() {
    }

    public ICellRenderer createPrintRenderer(Printer printer) {
        return new TextCellRenderer(printer);
    }
}

