/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.strategies;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IJaretTableCell;
import de.jaret.util.ui.table.model.IJaretTableSelection;
import de.jaret.util.ui.table.strategies.ICCPStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DefaultCCPStrategy
implements ICCPStrategy {
    private static final String COPY_DELIMITER = "\t";
    private static final String PASTE_DELIMITERS = "\t;";
    private Clipboard _clipboard;
    private boolean _includeHeadersInCopy = false;

    private synchronized Clipboard getClipboard() {
        if (this._clipboard == null) {
            this._clipboard = new Clipboard(Display.getCurrent());
        }
        return this._clipboard;
    }

    public void dispose() {
        if (this._clipboard != null) {
            this._clipboard.dispose();
        }
    }

    public void copy(JaretTable table) {
        this.cutOrCopy(table, false);
    }

    public void cut(JaretTable table) {
        this.cutOrCopy(table, true);
    }

    protected void cutOrCopy(JaretTable table, boolean cut) {
        IJaretTableSelection selection = table.getSelectionModel().getSelection();
        Clipboard cb = this.getClipboard();
        if (!selection.isEmpty()) {
            Set<IJaretTableCell> cells = selection.getAllSelectedCells(table.getTableModel());
            int minx = -1;
            int maxx = -1;
            int miny = -1;
            int maxy = -1;
            HashMap cellMap = new HashMap();
            for (IJaretTableCell cell : cells) {
                Point p = table.getCellDisplayIdx(cell);
                HashMap<Integer, IJaretTableCell> lineMap = (HashMap<Integer, IJaretTableCell>)cellMap.get(p.y);
                if (lineMap == null) {
                    lineMap = new HashMap<Integer, IJaretTableCell>();
                    cellMap.put(p.y, lineMap);
                }
                if (miny == -1 || p.y < miny) {
                    miny = p.y;
                }
                if (maxy == -1 || p.y > maxy) {
                    maxy = p.y;
                }
                lineMap.put(p.x, cell);
                if (minx == -1 || p.x < minx) {
                    minx = p.x;
                }
                if (maxx != -1 && p.x <= maxx) continue;
                maxx = p.x;
            }
            StringBuilder buf = new StringBuilder();
            if (this._includeHeadersInCopy) {
                for (int x = minx; x <= maxx; ++x) {
                    String headerLabel = table.getColumn(x).getHeaderLabel();
                    buf.append(headerLabel);
                    buf.append(COPY_DELIMITER);
                }
                buf.append("\n");
            }
            for (int y = miny; y <= maxy; ++y) {
                Map lineMap = (Map)cellMap.get(y);
                if (lineMap == null) continue;
                for (int x = minx; x <= maxx; ++x) {
                    IJaretTableCell cell = (IJaretTableCell)lineMap.get(x);
                    String value = null;
                    if (cell != null) {
                        Object val = cell.getColumn().getValue(cell.getRow());
                        String string = value = val != null ? val.toString() : null;
                        if (cut) {
                            this.emptyCell(cell);
                        }
                    }
                    if (value != null) {
                        buf.append(value);
                    }
                    buf.append(COPY_DELIMITER);
                }
                buf.append("\n");
            }
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{buf.toString()}, new Transfer[]{textTransfer});
        }
    }

    protected void emptyCell(IJaretTableCell cell) {
        try {
            cell.getColumn().setValue(cell.getRow(), null);
        }
        catch (Exception e) {
            try {
                cell.getColumn().setValue(cell.getRow(), "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paste(JaretTable table) {
        TextTransfer textTransfer;
        Clipboard cb = this.getClipboard();
        Object content = cb.getContents((Transfer)(textTransfer = TextTransfer.getInstance()));
        if (content != null && content instanceof String) {
            String string = (String)content;
            ArrayList<String> lines = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(string, "\n");
            while (tokenizer.hasMoreTokens()) {
                lines.add(tokenizer.nextToken());
            }
            Point focus = table.getFocussedCellIdx();
            if (focus == null) {
                table.setFocus();
                focus = table.getFocussedCellIdx();
            }
            int lineOff = 0;
            for (String line : lines) {
                tokenizer = new StringTokenizer(line, PASTE_DELIMITERS, true);
                int colOff = 0;
                String last = null;
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    boolean ignore = false;
                    if (PASTE_DELIMITERS.indexOf(value) != -1) {
                        if (last != null && last.equals(value)) {
                            value = "";
                        } else {
                            ignore = true;
                        }
                    }
                    if (!ignore) {
                        try {
                            table.setValue(focus.x + colOff, focus.y + lineOff, value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++colOff;
                    }
                    last = value;
                }
                ++lineOff;
            }
        }
    }

    public boolean getIncludeHeadersInCopy() {
        return this._includeHeadersInCopy;
    }

    public void setIncludeHeadersInCopy(boolean includeHeadersInCopy) {
        this._includeHeadersInCopy = includeHeadersInCopy;
    }
}

