/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.util;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.IJaretTableCell;
import de.jaret.util.ui.table.model.IJaretTableSelectionModelListener;
import de.jaret.util.ui.table.model.IRow;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class AbstractSelectionProvider
implements ISelectionProvider,
IJaretTableSelectionModelListener {
    protected JaretTable _table;
    protected List<ISelectionChangedListener> _selectionChangeListeners;

    public AbstractSelectionProvider(JaretTable table) {
        this._table = table;
        this._table.getSelectionModel().addTableSelectionModelListener(this);
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this._selectionChangeListeners == null) {
            this._selectionChangeListeners = new Vector<ISelectionChangedListener>();
        }
        this._selectionChangeListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this._selectionChangeListeners != null) {
            this._selectionChangeListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.setISelection(selection);
    }

    public ISelection getSelection() {
        return this.getISelection();
    }

    protected abstract ISelection getISelection();

    protected abstract void setISelection(ISelection var1);

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        if (this._selectionChangeListeners != null) {
            for (ISelectionChangedListener listener : this._selectionChangeListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    public void rowSelectionAdded(IRow row) {
        this.fireSelectionChanged();
    }

    public void rowSelectionRemoved(IRow row) {
        this.fireSelectionChanged();
    }

    public void cellSelectionAdded(IJaretTableCell cell) {
        this.fireSelectionChanged();
    }

    public void cellSelectionRemoved(IJaretTableCell cell) {
        this.fireSelectionChanged();
    }

    public void columnSelectionAdded(IColumn column) {
        this.fireSelectionChanged();
    }

    public void columnSelectionRemoved(IColumn column) {
        this.fireSelectionChanged();
    }
}

